/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.characteristic;

import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.units.MeasuringUnitValue;
import de.elpro.ewms.core.variable.ValuesBounds;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public class Characteristic2DFunction {
    private final MeasuringUnit inputMU;
    private final MeasuringUnit outputMU;
    private Double inputLowLimit = null;
    private Double inputHighLimit = null;
    private Double outputLowLimit = null;
    private Double outputHighLimit = null;
    private double[] inputValues;
    private double[] outputValues;
    private transient TreeMap<Double, Double> valuesMap = null;

    public Characteristic2DFunction(MeasuringUnit inputMU, MeasuringUnit outputMU, ValuesBounds inputBounds, ValuesBounds outputBounds) {
        this.inputMU = inputMU;
        this.outputMU = outputMU;
        if (inputBounds != null) {
            if (inputBounds.getLowLimit() != null) {
                this.inputLowLimit = inputMU.convert(inputBounds.getLowLimit(), inputBounds.getMeasuringUnit());
            }
            if (inputBounds.getHighLimit() != null) {
                this.inputHighLimit = inputMU.convert(inputBounds.getHighLimit(), inputBounds.getMeasuringUnit());
            }
        }
        if (outputBounds != null) {
            if (outputBounds.getLowLimit() != null) {
                this.outputLowLimit = outputMU.convert(outputBounds.getLowLimit(), outputBounds.getMeasuringUnit());
            }
            if (outputBounds.getLowLimit() != null) {
                this.outputHighLimit = outputMU.convert(outputBounds.getHighLimit(), outputBounds.getMeasuringUnit());
            }
        }
    }

    public MeasuringUnit getInputMU() {
        return this.inputMU;
    }

    public MeasuringUnit getOutputMU() {
        return this.outputMU;
    }

    public Map.Entry<Double, Double> getFloorEntry(double x) {
        return this.getValuesMap().floorEntry(x);
    }

    public Map.Entry<Double, Double> getCeilingEntry(double x) {
        return this.getValuesMap().ceilingEntry(x);
    }

    public FunctionPoint getFloorPoint(double x) {
        Map.Entry<Double, Double> entry = this.getValuesMap().floorEntry(x);
        return entry != null ? new FunctionPoint(entry.getKey(), entry.getValue()) : null;
    }

    public FunctionPoint getCeilingPoint(double x) {
        Map.Entry<Double, Double> entry = this.getValuesMap().ceilingEntry(x);
        return entry != null ? new FunctionPoint(entry.getKey(), entry.getValue()) : null;
    }

    public FunctionPoint addPoint(MeasuringUnitValue inputValue, MeasuringUnitValue outputValue) {
        double input = this.inputMU.convert(inputValue.getValue(), inputValue.getMeasuringUnit());
        double output = this.outputMU.convert(outputValue.getValue(), outputValue.getMeasuringUnit());
        if (this.inputLowLimit != null && input < this.inputLowLimit) {
            return null;
        }
        if (this.inputHighLimit != null && input > this.inputHighLimit) {
            return null;
        }
        if (this.outputLowLimit != null && output < this.outputLowLimit) {
            return null;
        }
        if (this.outputHighLimit != null && output > this.outputHighLimit) {
            return null;
        }
        if (this.getValuesMap().containsKey(input)) {
            input = Double.longBitsToDouble(Double.doubleToLongBits(input) + 1L);
        }
        this.getValuesMap().put(input, output);
        return new FunctionPoint(input, output);
    }

    public FunctionPoint findPoint(MeasuringUnitValue inputValue, MeasuringUnitValue outputValue, MeasuringUnitValue inputEpsilon, MeasuringUnitValue outputEpsilon) {
        double closestDistance = Double.MAX_VALUE;
        FunctionPoint closestPoint = null;
        double input = this.inputMU.convert(inputValue.getValue(), inputValue.getMeasuringUnit());
        double output = this.outputMU.convert(outputValue.getValue(), outputValue.getMeasuringUnit());
        double iEpsilon = this.inputMU.convert(inputEpsilon.getValue(), inputEpsilon.getMeasuringUnit());
        double oEpsilon = this.outputMU.convert(outputEpsilon.getValue(), outputEpsilon.getMeasuringUnit());
        Map.Entry<Double, Double> candidate = this.getValuesMap().ceilingEntry(input - iEpsilon);
        while (candidate != null) {
            Double distance;
            double inputCandidate = candidate.getKey();
            double outputCandidate = candidate.getValue();
            if (inputCandidate > input + iEpsilon) break;
            if (outputCandidate >= output - oEpsilon && outputCandidate <= output + oEpsilon && (distance = Double.valueOf(Math.sqrt(Math.pow((inputCandidate - input) / iEpsilon, 2.0) + Math.pow((outputCandidate - output) / oEpsilon, 2.0)))) < closestDistance) {
                closestPoint = new FunctionPoint(inputCandidate, outputCandidate);
                closestDistance = distance;
            }
            candidate = this.getValuesMap().higherEntry(candidate.getKey());
        }
        return closestPoint;
    }

    public boolean canInsertPoint(MeasuringUnitValue inputValue, MeasuringUnitValue outputValue, MeasuringUnitValue inputEpsilon, MeasuringUnitValue outputEpsilon) {
        if (this.getValuesMap().size() <= 1) {
            return true;
        }
        double input = this.inputMU.convert(inputValue.getValue(), inputValue.getMeasuringUnit());
        double output = this.outputMU.convert(outputValue.getValue(), outputValue.getMeasuringUnit());
        double iEpsilon = this.inputMU.convert(inputEpsilon.getValue(), inputEpsilon.getMeasuringUnit());
        double oEpsilon = this.outputMU.convert(outputEpsilon.getValue(), outputEpsilon.getMeasuringUnit());
        Map.Entry<Double, Double> leftEntry = this.getValuesMap().lowerEntry(input);
        Map.Entry<Double, Double> rightEntry = this.getValuesMap().ceilingEntry(input);
        if (leftEntry == null) {
            return rightEntry.getKey() - input < iEpsilon * 10.0 && Math.abs(rightEntry.getValue() - output) < oEpsilon * 10.0;
        }
        if (rightEntry == null) {
            return input - leftEntry.getKey() < iEpsilon * 10.0 && Math.abs(leftEntry.getValue() - output) < oEpsilon * 10.0;
        }
        double lX = leftEntry.getKey();
        double lY = leftEntry.getValue();
        double rX = rightEntry.getKey();
        double rY = rightEntry.getValue();
        if (output > Math.max(lY, rY) + oEpsilon) {
            return false;
        }
        if (output < Math.min(lY, rY) - oEpsilon) {
            return false;
        }
        double expectedLY = lY + (input - iEpsilon - lX) / (rX - lX) * (rY - lY);
        double expectedRY = lY + (input + iEpsilon - lX) / (rX - lX) * (rY - lY);
        return expectedLY - oEpsilon < output && output < expectedRY + oEpsilon || expectedLY + oEpsilon > output && output > expectedRY - oEpsilon;
    }

    public FunctionPoint movePoint(FunctionPoint point, MeasuringUnitValue targetInput, MeasuringUnitValue targetOutput) {
        Double oldY = this.getValuesMap().get(point.getInput());
        if (oldY == null) {
            return null;
        }
        if (oldY.doubleValue() != point.getOutput()) {
            return null;
        }
        double input = this.inputMU.convert(targetInput.getValue(), targetInput.getMeasuringUnit());
        double output = this.outputMU.convert(targetOutput.getValue(), targetOutput.getMeasuringUnit());
        if (this.inputLowLimit != null && input < this.inputLowLimit) {
            input = this.inputLowLimit;
        }
        if (this.inputHighLimit != null && input > this.inputHighLimit) {
            input = this.inputHighLimit;
        }
        if (this.outputLowLimit != null && output < this.outputLowLimit) {
            output = this.outputLowLimit;
        }
        if (this.outputHighLimit != null && output > this.outputHighLimit) {
            output = this.outputHighLimit;
        }
        this.getValuesMap().remove(point.getInput());
        if (this.getValuesMap().containsKey(input)) {
            Map.Entry<Double, Double> nextKey;
            if (input < point.getInput()) {
                Map.Entry<Double, Double> prevKey = this.getValuesMap().lowerEntry(point.getInput());
                if (prevKey != null && prevKey.getKey() >= input) {
                    input = Double.longBitsToDouble(Double.doubleToLongBits(prevKey.getKey()) - 1L);
                }
            } else if (input > point.getInput() && (nextKey = this.getValuesMap().higherEntry(point.getInput())) != null && nextKey.getKey() <= input) {
                input = Double.longBitsToDouble(Double.doubleToLongBits(nextKey.getKey()) + 1L);
            }
        }
        this.getValuesMap().put(input, output);
        return new FunctionPoint(input, output);
    }

    public void removePoint(FunctionPoint point) {
        this.getValuesMap().remove(point.getInput());
    }

    public Collection<FunctionPoint> getPoints() {
        ArrayList<FunctionPoint> points = new ArrayList<FunctionPoint>();
        for (Map.Entry<Double, Double> p : this.getValuesMap().entrySet()) {
            points.add(new FunctionPoint(p.getKey(), p.getValue()));
        }
        return Collections.unmodifiableCollection(points);
    }

    public void clear() {
        this.getValuesMap().clear();
    }

    public boolean isEmpty() {
        return this.getValuesMap().isEmpty();
    }

    public int size() {
        return this.getValuesMap().size();
    }

    public void commitChanges() {
        this.inputValues = new double[this.getValuesMap().size()];
        this.outputValues = new double[this.getValuesMap().size()];
        int i = 0;
        for (Map.Entry<Double, Double> entry : this.getValuesMap().entrySet()) {
            this.inputValues[i] = entry.getKey();
            this.outputValues[i++] = entry.getValue();
        }
    }

    private TreeMap<Double, Double> getValuesMap() {
        if (this.valuesMap == null) {
            this.valuesMap = new TreeMap();
            this.valuesMap.clear();
            if (this.inputValues != null && this.outputValues != null) {
                int i = 0;
                while (i < this.inputValues.length) {
                    this.valuesMap.put(this.inputValues[i], this.outputValues[i]);
                    ++i;
                }
            }
        }
        return this.valuesMap;
    }

    public Characteristic2DFunction copy() {
        Characteristic2DFunction copy = new Characteristic2DFunction(this.inputMU, this.outputMU, null, null);
        copy.inputLowLimit = this.inputLowLimit;
        copy.inputHighLimit = this.inputHighLimit;
        copy.outputLowLimit = this.outputLowLimit;
        copy.outputHighLimit = this.outputHighLimit;
        if (this.inputValues != null && this.outputValues != null) {
            copy.inputValues = Arrays.copyOf(this.inputValues, this.inputValues.length);
            copy.outputValues = Arrays.copyOf(this.outputValues, this.outputValues.length);
        }
        if (this.valuesMap != null) {
            copy.valuesMap = new TreeMap();
            for (Map.Entry<Double, Double> entry : this.valuesMap.entrySet()) {
                copy.valuesMap.put(entry.getKey(), entry.getValue());
            }
        }
        return copy;
    }

    public static final class FunctionPoint {
        private final double input;
        private final double output;

        public FunctionPoint(double input, double output) {
            this.input = input;
            this.output = output;
        }

        public double getInput() {
            return this.input;
        }

        public double getOutput() {
            return this.output;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FunctionPoint)) {
                return false;
            }
            FunctionPoint other = (FunctionPoint)obj;
            return this.input == other.input && this.output == other.output;
        }
    }
}

