/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.characteristic;

import de.elpro.ewms.core.characteristic.Characteristic2DFunction;
import de.elpro.ewms.core.json.JsonUtils;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.ValueSource;
import de.elpro.ewms.core.variable.value.VarValue;
import java.time.Instant;
import java.util.Map;
import java.util.TreeMap;

public class Characteristic2DFunctions
extends TreeMap<Instant, Characteristic2DFunction> {
    private static final long serialVersionUID = 6704727658998053613L;

    public String toJson() {
        return JsonUtils.GSON.toJson((Object)this);
    }

    public static Characteristic2DFunctions parse(String text) {
        try {
            return (Characteristic2DFunctions)JsonUtils.GSON.fromJson(text, Characteristic2DFunctions.class);
        }
        catch (Exception exception) {
            return new Characteristic2DFunctions();
        }
    }

    public Instant getNextFunctionBegin(Instant timestamp) {
        return this.higherKey(timestamp);
    }

    public IVarValue getOutput(IVarValue input) {
        return this.getOutput(input, null, null);
    }

    public IVarValue getOutput(IVarValue input, MeasuringUnit inputMU, MeasuringUnit outputMU) {
        Map.Entry<Double, Double> floorPoint;
        if (!input.isValid()) {
            return VarValue.nan(input.getEndTimestamp());
        }
        long timestamp = input.getEndTimestamp();
        Map.Entry pointMapEntry = this.floorEntry(Instant.ofEpochMilli(timestamp));
        if (pointMapEntry == null) {
            return VarValue.nan(timestamp);
        }
        Characteristic2DFunction pointMap = (Characteristic2DFunction)pointMapEntry.getValue();
        double x = input.getValue();
        if (inputMU != null) {
            x = pointMap.getInputMU().convert(x, inputMU);
        }
        if ((floorPoint = pointMap.getFloorEntry(x)) == null) {
            return VarValue.nan(timestamp);
        }
        Map.Entry<Double, Double> ceilingPoint = pointMap.getCeilingEntry(x);
        if (ceilingPoint == null) {
            return VarValue.nan(timestamp);
        }
        double x1 = floorPoint.getKey();
        double y1 = floorPoint.getValue();
        double x2 = ceilingPoint.getKey();
        double y2 = ceilingPoint.getValue();
        double y = (y2 - y1) * (x - x1) / (x2 - x1) + y1;
        if (outputMU != null) {
            y = outputMU.convert(y, pointMap.getOutputMU());
        }
        return new VarValue(timestamp, y, 1.0, ValueSource.Model);
    }
}

