/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.characteristic;

import de.elpro.ewms.core.characteristic.Characteristic3DExtremeLine;
import de.elpro.ewms.core.characteristic.ExtremePoint;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ui.fx.charts.xyz.series.XYAreaBounds;
import java.util.LinkedList;
import java.util.List;

public class Characteristic3DExtremeYLine
implements Characteristic3DExtremeLine {
    private final MeasuringUnit xAxisMU;
    private final MeasuringUnit yAxisMU;
    private final MeasuringUnit zAxisMU;
    private final MeasuringUnit wAxisMU;
    private final double minY;
    private final double maxY;
    private final int yAxisResolution;
    private final double[] xValues;
    private final double[] zValues;
    private final double[] wValues;

    public Characteristic3DExtremeYLine(boolean searchForMinimum, boolean overZ, MeasuringUnit xAxisMU, MeasuringUnit yAxisMU, MeasuringUnit zAxisMU, MeasuringUnit wAxisMU, double minX, double maxX, double minY, double maxY, int xAxisResolution, int yAxisResolution, double[][] zValues, double[][] wValues, XYAreaBounds xyAreaBounds) {
        this.xAxisMU = xAxisMU;
        this.yAxisMU = yAxisMU;
        this.zAxisMU = zAxisMU;
        this.wAxisMU = wAxisMU;
        this.minY = minY;
        this.maxY = maxY;
        this.yAxisResolution = xAxisResolution;
        this.xValues = new double[xAxisResolution];
        this.zValues = new double[xAxisResolution];
        this.wValues = (double[])(wAxisMU != null ? new double[xAxisResolution] : null);
        int yIndex = 0;
        while (yIndex < yAxisResolution) {
            double y = minY + (double)yIndex * (maxY - minY) / (double)(yAxisResolution - 1);
            double mZ = Double.NaN;
            double mW = Double.NaN;
            double mX = Double.NaN;
            int xIndex = 0;
            while (xIndex < xAxisResolution) {
                double x = minX + (double)xIndex * (maxX - minX) / (double)(xAxisResolution - 1);
                if (xyAreaBounds == null || xyAreaBounds.contains(x, y)) {
                    double v;
                    double d = v = overZ ? zValues[xIndex][yIndex] : wValues[xIndex][yIndex];
                    if (Double.isFinite(v)) {
                        if (!Double.isFinite(overZ ? mZ : mW)) {
                            mZ = zValues[xIndex][yIndex];
                            mW = wValues != null ? wValues[xIndex][yIndex] : Double.NaN;
                            mX = x;
                        } else if (searchForMinimum) {
                            double d2 = overZ ? mZ : mW;
                            if (v < d2) {
                                mZ = zValues[xIndex][yIndex];
                                mW = wValues != null ? wValues[xIndex][yIndex] : Double.NaN;
                                mX = x;
                            }
                        } else {
                            double d3 = overZ ? mZ : mW;
                            if (v > d3) {
                                mZ = zValues[xIndex][yIndex];
                                mW = wValues != null ? wValues[xIndex][yIndex] : Double.NaN;
                                mX = x;
                            }
                        }
                    }
                }
                ++xIndex;
            }
            this.xValues[yIndex] = mX;
            this.zValues[yIndex] = mZ;
            if (this.wValues != null) {
                this.wValues[yIndex] = mW;
            }
            ++yIndex;
        }
    }

    @Override
    public ExtremePoint getPoint(double atY) {
        return this.getPoint(atY, this.xAxisMU, this.yAxisMU, this.zAxisMU, this.wAxisMU);
    }

    @Override
    public ExtremePoint getPoint(double atY, MeasuringUnit xAxisMU, MeasuringUnit yAxisMU, MeasuringUnit zAxisMU, MeasuringUnit wAxisMU) {
        double wValue;
        double zValue;
        double xValue;
        double yValue = this.yAxisMU.convert(atY, yAxisMU);
        if (yValue < this.minY || yValue > this.maxY) {
            return null;
        }
        double yValueIndex = (yValue - this.minY) / (this.maxY - this.minY) * (double)(this.yAxisResolution - 1);
        if (yValueIndex != (double)((int)yValueIndex)) {
            double x1 = this.xValues[(int)yValueIndex];
            double x2 = this.xValues[(int)yValueIndex + 1];
            if (!Double.isFinite(x1) || !Double.isFinite(x2)) {
                return null;
            }
            double ratio = yValueIndex - (double)((int)yValueIndex);
            xValue = x1 + (x2 - x1) * ratio;
            double z1 = this.zValues[(int)yValueIndex];
            double z2 = this.zValues[(int)yValueIndex + 1];
            double w1 = this.wValues != null ? this.wValues[(int)yValueIndex] : Double.NaN;
            double w2 = this.wValues != null ? this.wValues[(int)yValueIndex + 1] : Double.NaN;
            zValue = z1 + (z2 - z1) * ratio;
            wValue = w1 + (w2 - w1) * ratio;
        } else {
            xValue = this.xValues[(int)yValueIndex];
            if (!Double.isFinite(yValue)) {
                return null;
            }
            zValue = this.zValues[(int)yValueIndex];
            wValue = this.wValues != null ? this.wValues[(int)yValueIndex] : Double.NaN;
        }
        return new ExtremePoint(xAxisMU.convert(xValue, this.xAxisMU), atY, zAxisMU.convert(zValue, this.zAxisMU), wAxisMU.convert(wValue, this.wAxisMU));
    }

    @Override
    public List<ExtremePoint> getPoints(MeasuringUnit xAxisMU, MeasuringUnit yAxisMU, MeasuringUnit zAxisMU, MeasuringUnit wAxisMU) {
        LinkedList<ExtremePoint> points = new LinkedList<ExtremePoint>();
        int yIndex = 0;
        while (yIndex < this.yAxisResolution) {
            double x = this.xValues[yIndex];
            if (Double.isFinite(x)) {
                double y = this.minY + (double)yIndex * (this.maxY - this.minY) / (double)(this.yAxisResolution - 1);
                double z = this.zValues[yIndex];
                double w = this.wValues != null ? this.wValues[yIndex] : Double.NaN;
                points.add(new ExtremePoint(xAxisMU.convert(x, this.xAxisMU), yAxisMU.convert(y, this.yAxisMU), zAxisMU.convert(z, this.zAxisMU), this.wValues != null ? wAxisMU.convert(w, this.wAxisMU) : Double.NaN));
            }
            ++yIndex;
        }
        return points;
    }
}

