/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.characteristic;

import de.elpro.ewms.core.characteristic.Characteristic3D;
import de.elpro.ewms.core.characteristic.Characteristic3DFunction;
import de.elpro.ewms.core.characteristic.Characteristic3DFunctions;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.resources.Resources;
import de.elpro.ui.model.CustomUILabelElement;
import de.elpro.ui.model.IdObject;
import de.elpro.ui.model.UIModelElement;
import java.net.URL;
import java.time.Instant;
import java.util.Map;
import java.util.Set;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="ewms_characteristic_3d_instance", uniqueConstraints={@UniqueConstraint(columnNames={"characteristic", "structure_object"})})
@Access(value=AccessType.PROPERTY)
public class Characteristic3DInstance
extends CustomUILabelElement
implements UIModelElement,
IdObject {
    public static final String DAO_NAMESPACE = "characteristic/3d_instance";
    public static final URL ENABLED_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"ewms/characteristic2DInstance_enabled.png");
    public static final URL DISABLED_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"ewms/characteristic2DInstance_disabled.png");
    private final ObjectProperty<Integer> id = new SimpleObjectProperty();
    private final ObjectProperty<Characteristic3D> characteristic = new SimpleObjectProperty();
    private final ObjectProperty<StructureObject> structureObject = new SimpleObjectProperty();
    private Characteristic3DFunctions functions = new Characteristic3DFunctions();

    public Characteristic3DInstance() {
    }

    public Characteristic3DInstance(Characteristic3D characteristic, StructureObject object) {
        this();
        this.setCharacteristic(characteristic);
        this.setStructureObject(object);
    }

    public Characteristic3DInstance(int id) {
        this();
        this.setId(id);
    }

    public ObjectProperty<Integer> idProperty() {
        return this.id;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ewms_characteristic_3d_instance_sequence")
    @SequenceGenerator(name="ewms_characteristic_3d_instance_sequence", sequenceName="ewms_characteristic_3d_instance_sequence")
    public Integer getId() {
        return (Integer)this.idProperty().get();
    }

    public void setId(Integer id) {
        this.idProperty().set((Object)id);
    }

    public ObjectProperty<Characteristic3D> characteristicProperty() {
        return this.characteristic;
    }

    @ManyToOne
    @JoinColumn(name="characteristic", nullable=false)
    public Characteristic3D getCharacteristic() {
        return (Characteristic3D)this.characteristicProperty().get();
    }

    public void setCharacteristic(Characteristic3D characteristic) {
        this.characteristicProperty().set((Object)characteristic);
    }

    public ObjectProperty<StructureObject> structureObjectProperty() {
        return this.structureObject;
    }

    @ManyToOne
    @JoinColumn(name="structure_object", nullable=false)
    public StructureObject getStructureObject() {
        return (StructureObject)this.structureObjectProperty().get();
    }

    public void setStructureObject(StructureObject structureObject) {
        this.structureObjectProperty().set((Object)structureObject);
    }

    @Column(name="functions", columnDefinition="TEXT")
    public String getFunctionsSerialized() {
        if (this.functions == null) {
            return null;
        }
        return this.functions.toJson();
    }

    public void setFunctionsSerialized(String functionsSerialized) {
        this.functions = functionsSerialized == null ? new Characteristic3DFunctions() : Characteristic3DFunctions.parse(functionsSerialized);
    }

    public final void putFunction(Instant from, Characteristic3DFunction function) {
        this.functions.put(from, function);
    }

    @Transient
    public Characteristic3DFunctions getFunctions() {
        return this.functions;
    }

    public void setFunctions(Characteristic3DFunctions functions) {
        this.functions = functions;
    }

    @Transient
    public final Characteristic3DFunction getFunction(Instant beginTimestamp) {
        return (Characteristic3DFunction)this.functions.get(beginTimestamp);
    }

    @Transient
    public final Instant getCurrentFunctionTimestamp(Instant timestamp) {
        return this.functions.floorKey(timestamp);
    }

    @Transient
    public final Characteristic3DFunction getCurrentFunction(Instant timestamp) {
        Map.Entry currentFunctionEntry = this.functions.floorEntry(timestamp);
        return currentFunctionEntry != null ? (Characteristic3DFunction)currentFunctionEntry.getValue() : null;
    }

    @Transient
    public final Set<Instant> getFunctionsBeginTimestamps() {
        return this.functions.keySet();
    }

    public final void removeFunction(Instant beginTimestamp) {
        this.functions.remove(beginTimestamp);
    }

    public String toString() {
        if (this.buildTextLableCallback != null) {
            return this.buildTextLableCallback.buildTextLabel((CustomUILabelElement)this);
        }
        if (this.getStructureObject() != null) {
            return this.getStructureObject().toString();
        }
        return this.getId().toString();
    }

    @Transient
    public String getFullName() {
        return String.format("%s - %s", this.getCharacteristic(), this.getStructureObject());
    }

    @Transient
    public String getIconUri() {
        return DISABLED_ICON.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Characteristic3DInstance) {
            if (this.getId() == null) {
                return super.equals(obj);
            }
            if (this.getId().equals(((Characteristic3DInstance)((Object)obj)).getId())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.getId() == null) {
            return super.hashCode();
        }
        return Characteristic3DInstance.class.hashCode() + 17 * this.getId();
    }
}

