/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.charts;

import de.elpro.ewms.core.charts.Characteristic2DSeries;
import de.elpro.ewms.core.charts.ChartGroup;
import de.elpro.ewms.core.charts.PlotType;
import de.elpro.ewms.core.charts.RendererType;
import de.elpro.ewms.core.charts.SeriesGroup;
import de.elpro.ewms.core.charts.VarSeries2D;
import de.elpro.ewms.core.charts.XAxisType;
import de.elpro.ewms.core.charts.YAxis;
import de.elpro.ewms.core.notes.NoteType;
import de.elpro.ewms.core.structure.SearchPolicy;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.units.PhysicalUnit;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.virtualtime.VirtualRaster;
import de.elpro.resources.Icons;
import de.elpro.ui.model.IdObject;
import de.elpro.ui.model.UIModelElement;
import de.elpro.ui.text.LocaleText;
import java.io.Serializable;
import java.net.URL;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="ewms_charts_chart")
@Access(value=AccessType.PROPERTY)
public class Chart2D
implements UIModelElement,
IdObject,
Serializable {
    private static final long serialVersionUID = 5932754447326403972L;
    public static final String DAO_NAMESPACE = "charts/chart2d";
    public static final URL XY_CHART_ICON = Icons.CHART_ITEM_URL;
    public static final URL RING_PIE_CHART_ICON = Icons.PIE_CHART_ITEM_URL;
    public static final URL BAR_CHART_ICON = Icons.BAR_CHART_ITEM_URL;
    private final ObjectProperty<Integer> id = new SimpleObjectProperty();
    private final ObjectProperty<ChartGroup> chartGroup = new SimpleObjectProperty();
    private final ObjectProperty<PlotType> plotType = new SimpleObjectProperty((Object)PlotType.XYPlot);
    private final ObjectProperty<VirtualRaster> defaultRaster = new SimpleObjectProperty();
    private final StringProperty name = new SimpleStringProperty();
    private final StringProperty title = new SimpleStringProperty();
    private final ObjectProperty<Integer> visualOrderPosition = new SimpleObjectProperty();
    private final ObjectProperty<SearchPolicy> notesSearchPolicy = new SimpleObjectProperty((Object)SearchPolicy.Auto);
    private final ObjectProperty<NoteType> notesFilter = new SimpleObjectProperty((Object)NoteType.Common);
    private final ObjectProperty<XAxisType> xAxisType = new SimpleObjectProperty((Object)XAxisType.Time);
    private final StringProperty xAxisTitle = new SimpleStringProperty();
    private final ObjectProperty<PhysicalUnit> xAxisPU = new SimpleObjectProperty();
    private final ObjectProperty<MeasuringUnit> xAxisMU = new SimpleObjectProperty();
    private final ObjectProperty<Variable> xAxisVariable = new SimpleObjectProperty();
    private final ObjectProperty<Variable> clusteringVariable = new SimpleObjectProperty();
    private final ObjectProperty<Characteristic2DSeries> characteristic2DSeries = new SimpleObjectProperty();
    private Set<StructureClass> structureClasses = new HashSet<StructureClass>();
    private List<YAxis> yAxes = new LinkedList<YAxis>();

    public Chart2D() {
    }

    public Chart2D(int id) {
        this();
        this.setId(id);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ewms_charts_chart_sequence")
    @SequenceGenerator(name="ewms_charts_chart_sequence", sequenceName="ewms_charts_chart_sequence")
    public Integer getId() {
        return (Integer)this.id.get();
    }

    protected void setId(int id) {
        this.id.set((Object)id);
    }

    public final ObjectProperty<Integer> idProperty() {
        return this.id;
    }

    @ManyToOne
    @JoinColumn(name="chart_group", nullable=true)
    public ChartGroup getChartGroup() {
        return (ChartGroup)this.chartGroup.get();
    }

    public void setChartGroup(ChartGroup chartGroup) {
        this.chartGroup.set((Object)chartGroup);
    }

    public final ObjectProperty<ChartGroup> chartGroupProperty() {
        return this.chartGroup;
    }

    @Column(name="plot_type", nullable=false, columnDefinition="INTEGER DEFAULT 0")
    public PlotType getPlotType() {
        return (PlotType)((Object)this.plotType.get());
    }

    public void setPlotType(PlotType plotType) {
        this.plotType.set((Object)plotType);
    }

    public final ObjectProperty<PlotType> plotTypeProperty() {
        return this.plotType;
    }

    @Column(name="default_raster")
    public VirtualRaster getDefaultRaster() {
        return (VirtualRaster)((Object)this.defaultRaster.get());
    }

    public void setDefaultRaster(VirtualRaster virtualRaster) {
        this.defaultRaster.set((Object)virtualRaster);
    }

    public final ObjectProperty<VirtualRaster> defaultRasterProperty() {
        return this.defaultRaster;
    }

    @Column(name="name", nullable=false, columnDefinition="TEXT")
    public String getName() {
        return (String)this.name.get();
    }

    @Transient
    public final String getLocalName() {
        return LocaleText.tryParse((String)this.getName()).getTextOrDefault();
    }

    public void setName(String displayName) {
        this.name.set((Object)displayName);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    @Column(name="title", columnDefinition="TEXT")
    public String getTitle() {
        return (String)this.title.get();
    }

    @Transient
    public final String getLocalTitle() {
        return LocaleText.tryParse((String)this.getTitle()).getTextOrDefault();
    }

    public void setTitle(String title) {
        this.title.set((Object)title);
    }

    public final StringProperty titleProperty() {
        return this.title;
    }

    @Column(name="visual_order_position")
    public Integer getVisualOrderPosition() {
        return (Integer)this.visualOrderPosition.get();
    }

    public void setVisualOrderPosition(Integer visualOrderPosition) {
        this.visualOrderPosition.set((Object)visualOrderPosition);
    }

    public final ObjectProperty<Integer> visualOrderPositionProperty() {
        return this.visualOrderPosition;
    }

    @Column(name="notes_search_policy", columnDefinition="INTEGER DEFAULT 0")
    public SearchPolicy getNotesSearchPolicy() {
        return (SearchPolicy)((Object)this.notesSearchPolicy.get());
    }

    public void setNotesSearchPolicy(SearchPolicy notesSearchPolicy) {
        this.notesSearchPolicy.set((Object)notesSearchPolicy);
    }

    public final ObjectProperty<SearchPolicy> notesSearchPolicyProperty() {
        return this.notesSearchPolicy;
    }

    @Column(name="notes_filter", nullable=false, columnDefinition="INTEGER DEFAULT 1")
    public NoteType getNotesFilter() {
        return (NoteType)((Object)this.notesFilter.get());
    }

    public void setNotesFilter(NoteType filter) {
        this.notesFilter.set((Object)filter);
    }

    public final ObjectProperty<NoteType> notesFilterProperty() {
        return this.notesFilter;
    }

    @Column(name="x_axis_type", nullable=false)
    public XAxisType getXAxisType() {
        return (XAxisType)((Object)this.xAxisType.get());
    }

    public void setXAxisType(XAxisType xAxisType) {
        this.xAxisType.set((Object)xAxisType);
    }

    public final ObjectProperty<XAxisType> xAxisTypeProperty() {
        return this.xAxisType;
    }

    @Column(name="x_axis_title", columnDefinition="TEXT")
    public String getXAxisTitle() {
        return (String)this.xAxisTitle.get();
    }

    @Transient
    public final String getLocalXAxisTitle() {
        return LocaleText.tryParse((String)this.getXAxisTitle()).getTextOrDefault();
    }

    public void setXAxisTitle(String xAxisTitle) {
        this.xAxisTitle.set((Object)xAxisTitle);
    }

    public final StringProperty xAxisTitleProperty() {
        return this.xAxisTitle;
    }

    @Column(name="x_axis_pu_id")
    public PhysicalUnit getXAxisPU() {
        return (PhysicalUnit)this.xAxisPU.get();
    }

    public void setXAxisPU(PhysicalUnit physicalUnit) {
        this.xAxisPU.set((Object)physicalUnit);
    }

    public final ObjectProperty<PhysicalUnit> xAxisPUProperty() {
        return this.xAxisPU;
    }

    @Column(name="x_axis_mu_id")
    public MeasuringUnit getXAxisMU() {
        return (MeasuringUnit)this.xAxisMU.get();
    }

    public void setXAxisMU(MeasuringUnit measuringUnit) {
        this.xAxisMU.set((Object)measuringUnit);
    }

    public final ObjectProperty<MeasuringUnit> xAxisMUProperty() {
        return this.xAxisMU;
    }

    @Transient
    public final MeasuringUnit getXAxisResultMU() {
        if (this.getXAxisMU() != null) {
            return this.getXAxisMU();
        }
        if (this.getXAxisType() == XAxisType.Duration) {
            return null;
        }
        return this.getXAxisVariable().getMeasuringUnit();
    }

    @ManyToOne
    @JoinColumn(name="x_axis_variable")
    public Variable getXAxisVariable() {
        return (Variable)this.xAxisVariable.get();
    }

    public void setXAxisVariable(Variable variable) {
        this.xAxisVariable.set((Object)variable);
    }

    public final ObjectProperty<Variable> xAxisVariableProperty() {
        return this.xAxisVariable;
    }

    @ManyToOne
    @JoinColumn(name="clustering_variable")
    public Variable getClusteringVariable() {
        return (Variable)this.clusteringVariableProperty().get();
    }

    public void setClusteringVariable(Variable variable) {
        this.clusteringVariableProperty().set((Object)variable);
    }

    public final ObjectProperty<Variable> clusteringVariableProperty() {
        return this.clusteringVariable;
    }

    @OneToOne(mappedBy="chart", cascade={CascadeType.ALL}, fetch=FetchType.LAZY, optional=true)
    public Characteristic2DSeries getCharacteristic2DSeries() {
        return (Characteristic2DSeries)this.characteristic2DSeries.get();
    }

    public void setCharacteristic2DSeries(Characteristic2DSeries characteristic) {
        this.characteristic2DSeries.set((Object)characteristic);
    }

    public final ObjectProperty<Characteristic2DSeries> characteristic2DSeriesProperty() {
        return this.characteristic2DSeries;
    }

    @ManyToMany
    @JoinTable(name="ewms_charts_chart_classes", joinColumns={@JoinColumn(name="ewms_charts_chart_id")}, inverseJoinColumns={@JoinColumn(name="structureclasses_id")})
    public Set<StructureClass> getStructureClasses() {
        return this.structureClasses;
    }

    protected void setStructureClasses(Set<StructureClass> structureClasses) {
        this.structureClasses = structureClasses;
    }

    @OneToMany(mappedBy="chart", cascade={CascadeType.REMOVE})
    public List<YAxis> getYAxes() {
        return this.yAxes;
    }

    protected void setYAxes(List<YAxis> yAxes) {
        this.yAxes = yAxes;
    }

    public void normilize() {
        for (YAxis yAxis : this.getYAxes()) {
            yAxis.setChart(this);
            HashSet<VarSeries2D> groupedSeries = new HashSet<VarSeries2D>();
            for (SeriesGroup seriesGroup : yAxis.getSeriesGroups()) {
                seriesGroup.setYAxis(yAxis);
                for (VarSeries2D series : seriesGroup.getSeries()) {
                    series.setYAxis(yAxis);
                    series.setSeriesGroup(seriesGroup);
                    groupedSeries.add(series);
                }
            }
            SeriesGroup axisGroup = new SeriesGroup();
            for (VarSeries2D series : yAxis.getSeries()) {
                if (groupedSeries.contains(series)) continue;
                series.setYAxis(yAxis);
                series.setSeriesGroup(axisGroup);
                axisGroup.getSeries().add(series);
            }
            if (axisGroup.getSeries().isEmpty()) continue;
            if (yAxis.getDefaultRendererType() != null) {
                axisGroup.setType(yAxis.getDefaultRendererType());
            }
            yAxis.getSeriesGroups().add(0, axisGroup);
        }
    }

    @Transient
    public boolean hasCustomDataSeries() {
        for (YAxis yAxis : this.getYAxes()) {
            for (VarSeries2D series : yAxis.getSeries()) {
                if (!series.isCustomData()) continue;
                return true;
            }
            for (SeriesGroup sg : yAxis.getSeriesGroups()) {
                for (VarSeries2D series : sg.getSeries()) {
                    if (!series.isCustomData()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public String toString() {
        return this.getLocalName();
    }

    public boolean hasAreaStacks() {
        for (YAxis axis : this.getYAxes()) {
            if (axis.getDefaultRendererType() == RendererType.StackedArea) {
                return true;
            }
            for (SeriesGroup group : axis.getSeriesGroups()) {
                if (group.getType() != RendererType.StackedArea) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Chart2D) {
            if (this.getId() == null) {
                return super.equals(obj);
            }
            if (this.getId().equals(((Chart2D)obj).getId())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.getId() == null) {
            return super.hashCode();
        }
        return Chart2D.class.hashCode() + 17 * (Integer)this.id.get();
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        if (o instanceof ChartGroup) {
            return 1;
        }
        if (!(o instanceof Chart2D)) {
            return this.toString().compareTo(o.toString());
        }
        Chart2D chart = (Chart2D)o;
        if (this.getVisualOrderPosition() != chart.getVisualOrderPosition() && this.getVisualOrderPosition() != null && chart.getVisualOrderPosition() != null) {
            return this.getVisualOrderPosition().compareTo(chart.getVisualOrderPosition());
        }
        if (this.toString() == null) {
            return chart.toString() == null ? 0 : -1;
        }
        if (chart.toString() == null) {
            return 1;
        }
        return this.toString().compareTo(chart.toString());
    }

    @Transient
    public String getIconUri() {
        switch (this.getPlotType()) {
            case XYPlot: {
                return XY_CHART_ICON.toString();
            }
            case RingPlot: 
            case PiePlot: {
                return RING_PIE_CHART_ICON.toString();
            }
            case BarPlot: {
                return BAR_CHART_ICON.toString();
            }
        }
        return null;
    }
}

