/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.charts;

import de.elpro.ewms.core.charts.RendererType;
import de.elpro.ewms.core.charts.VarSeries2D;
import de.elpro.ewms.core.charts.YAxis;
import de.elpro.resources.Resources;
import de.elpro.ui.model.IdObject;
import de.elpro.ui.model.UIModelElement;
import de.elpro.ui.text.LocaleText;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="ewms_charts_series_group")
@Access(value=AccessType.PROPERTY)
public class SeriesGroup
implements UIModelElement,
IdObject {
    public static final String DAO_NAMESPACE = "charts/seriesgroup";
    public static final URL LINE_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"ewms/charts/seriesgroup-line.png");
    public static final URL STACK_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"ewms/charts/seriesgroup-area.png");
    public static final URL BAR_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"ewms/charts/seriesgroup-bar.png");
    private final ObjectProperty<Integer> id = new SimpleObjectProperty();
    private final ObjectProperty<YAxis> axis = new SimpleObjectProperty();
    private final StringProperty name = new SimpleStringProperty();
    private final ObjectProperty<RendererType> type = new SimpleObjectProperty((Object)RendererType.Line);
    private final ObjectProperty<Integer> visualOrderPosition = new SimpleObjectProperty();
    private List<VarSeries2D> series = new LinkedList<VarSeries2D>();

    public SeriesGroup() {
    }

    public SeriesGroup(int id) {
        this();
        this.setId(id);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ewms_charts_series_group_sequence")
    @SequenceGenerator(name="ewms_charts_series_group_sequence", sequenceName="ewms_charts_series_group_sequence")
    public Integer getId() {
        return (Integer)this.id.get();
    }

    protected void setId(int id) {
        this.id.set((Object)id);
    }

    public final ObjectProperty<Integer> idProperty() {
        return this.id;
    }

    @ManyToOne
    @JoinColumn(name="y_axis", nullable=false)
    public YAxis getYAxis() {
        return (YAxis)this.axis.get();
    }

    public void setYAxis(YAxis axis) {
        this.axis.set((Object)axis);
    }

    public final ObjectProperty<YAxis> yAxisProperty() {
        return this.axis;
    }

    @Column(name="name", columnDefinition="TEXT")
    public String getName() {
        return (String)this.name.get();
    }

    @Transient
    public final String getLocalName() {
        return LocaleText.tryParse((String)this.getName()).getTextOrDefault();
    }

    public void setName(String name) {
        this.name.set((Object)name);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    @Column(name="type", nullable=false)
    public RendererType getType() {
        return (RendererType)((Object)this.type.get());
    }

    public void setType(RendererType type) {
        this.type.set((Object)type);
    }

    public final ObjectProperty<RendererType> typeProperty() {
        return this.type;
    }

    @Column(name="visual_order_position")
    public Integer getVisualOrderPosition() {
        return (Integer)this.visualOrderPosition.get();
    }

    public void setVisualOrderPosition(Integer visualOrderPosition) {
        this.visualOrderPosition.set((Object)visualOrderPosition);
    }

    public final ObjectProperty<Integer> visualOrderPositionProperty() {
        return this.visualOrderPosition;
    }

    @OneToMany(mappedBy="seriesGroup", cascade={CascadeType.REMOVE})
    public List<VarSeries2D> getSeries() {
        return this.series;
    }

    protected void setSeries(List<VarSeries2D> series) {
        this.series = series;
    }

    public String toString() {
        return this.getLocalName() == null || this.getLocalName().isEmpty() ? this.getType().name() : this.getLocalName();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SeriesGroup) {
            if (this.getId() == null) {
                return super.equals(obj);
            }
            if (this.getId().equals(((SeriesGroup)obj).getId())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.getId() == null) {
            return super.hashCode();
        }
        return SeriesGroup.class.hashCode() + 17 * (Integer)this.id.get();
    }

    @Transient
    public String getIconUri() {
        if (this.getType() != null) {
            return this.getType().getIconUri();
        }
        return null;
    }
}

