/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.charts.viewprefs;

import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.charts.Chart2D;
import de.elpro.ewms.core.charts.YAxis;
import de.elpro.ewms.core.charts.viewprefs.AxisViewPrefs;
import de.elpro.ewms.core.charts.viewprefs.Series2DViewPrefs;
import de.elpro.ewms.core.notes.NoteType;
import de.elpro.ewms.core.prefs.IViewPrefs;
import de.elpro.ewms.core.structure.SearchPolicy;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.time.TimeRangeFilterType;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.virtualtime.ComplexRaster;
import de.elpro.ewms.core.virtualtime.VirtualRaster;
import de.elpro.ui.model.IdObject;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="ewms_charts_viewprefs_chart", uniqueConstraints={@UniqueConstraint(columnNames={"user_id", "chart", "structure_object"})})
@Access(value=AccessType.PROPERTY)
public class Chart2DViewPrefs
implements IViewPrefs,
IdObject {
    public static final String DAO_NAMESPACE = "charts/chart_view_prefs";
    private final ObjectProperty<Integer> id = new SimpleObjectProperty();
    private final ObjectProperty<Chart2D> chart = new SimpleObjectProperty();
    private final ObjectProperty<User> user = new SimpleObjectProperty();
    private final ObjectProperty<StructureObject> structureObject = new SimpleObjectProperty();
    private final StringProperty title = new SimpleStringProperty();
    private final ObjectProperty<TimeRangeFilterType> timeRangeFilterType = new SimpleObjectProperty();
    private final ObjectProperty<Integer> customViewIndex = new SimpleObjectProperty();
    private final ObjectProperty<Raster> raster = new SimpleObjectProperty();
    private final ObjectProperty<VirtualRaster> virtualRaster = new SimpleObjectProperty();
    private final BooleanProperty autoupdate = new SimpleBooleanProperty(false);
    private final ObjectProperty<SearchPolicy> notesSearchPolicy = new SimpleObjectProperty();
    private final ObjectProperty<NoteType> notesFilter = new SimpleObjectProperty();
    private List<AxisViewPrefs> axisViewPrefs = new LinkedList<AxisViewPrefs>();
    private List<Series2DViewPrefs> seriesViewsPrefs = new LinkedList<Series2DViewPrefs>();

    Chart2DViewPrefs() {
    }

    public Chart2DViewPrefs(int id) {
        this.setId(id);
    }

    public Chart2DViewPrefs(int id, Chart2D chartDefinition, StructureObject structureObject) {
        this(chartDefinition, structureObject);
        this.setId(id);
    }

    public Chart2DViewPrefs(Chart2D chartDefinition, StructureObject structureObject) {
        this.setVirtualRaster(chartDefinition.getDefaultRaster());
        this.setChart(chartDefinition);
        this.setStructureObject(structureObject);
        this.setTitle(chartDefinition.getTitle());
        this.setNotesSearchPolicy(chartDefinition.getNotesSearchPolicy());
        this.setNotesFilter(chartDefinition.getNotesFilter());
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ewms_charts_viewprefs_chart_sequence")
    @SequenceGenerator(name="ewms_charts_viewprefs_chart_sequence", sequenceName="ewms_charts_viewprefs_chart_sequence")
    public Integer getId() {
        return (Integer)this.id.get();
    }

    public void setId(int id) {
        this.id.set((Object)id);
    }

    @ManyToOne
    @JoinColumn(name="chart", nullable=false)
    public Chart2D getChart() {
        return (Chart2D)this.chart.get();
    }

    public void setChart(Chart2D chart) {
        this.chart.set((Object)chart);
    }

    @ManyToOne
    @JoinColumn(name="user_id", nullable=false)
    public User getUser() {
        return (User)this.user.get();
    }

    public void setUser(User user) {
        this.user.set((Object)user);
    }

    @ManyToOne
    @JoinColumn(name="structure_object", nullable=true)
    public StructureObject getStructureObject() {
        return (StructureObject)this.structureObject.get();
    }

    public void setStructureObject(StructureObject object) {
        this.structureObject.set((Object)object);
    }

    @Column(name="title")
    public String getTitle() {
        return (String)this.title.get();
    }

    public void setTitle(String title) {
        this.title.set((Object)title);
    }

    public final StringProperty titleProperty() {
        return this.title;
    }

    public ObjectProperty<TimeRangeFilterType> timeRangeFilterTypeProperty() {
        return this.timeRangeFilterType;
    }

    @Override
    @Column(name="time_range_filter_type")
    public TimeRangeFilterType getTimeRangeFilterType() {
        return (TimeRangeFilterType)((Object)this.timeRangeFilterTypeProperty().get());
    }

    @Override
    public void setTimeRangeFilterType(TimeRangeFilterType timeRangeFilterType) {
        this.timeRangeFilterTypeProperty().set((Object)timeRangeFilterType);
    }

    public ObjectProperty<Integer> customViewIndexProperty() {
        return this.customViewIndex;
    }

    @Override
    @Column(name="custom_view_index")
    public Integer getCustomViewIndex() {
        return (Integer)this.customViewIndexProperty().get();
    }

    @Override
    public void setCustomViewIndex(Integer index) {
        this.customViewIndexProperty().set((Object)index);
    }

    @Override
    @Column(name="raster")
    public Raster getRaster() {
        return (Raster)((Object)this.raster.get());
    }

    @Override
    public void setRaster(Raster raster) {
        this.raster.set((Object)raster);
    }

    public final ObjectProperty<Raster> rasterProperty() {
        return this.raster;
    }

    @Override
    @Column(name="virtual_raster")
    public VirtualRaster getVirtualRaster() {
        return (VirtualRaster)((Object)this.virtualRaster.get());
    }

    @Override
    public void setVirtualRaster(VirtualRaster virtualRaster) {
        this.virtualRaster.set((Object)virtualRaster);
    }

    public final ObjectProperty<VirtualRaster> virtualRasterProperty() {
        return this.virtualRaster;
    }

    @Override
    @Transient
    public ComplexRaster getComplexRaster() {
        if (this.getVirtualRaster() != null) {
            return ComplexRaster.of(this.getVirtualRaster());
        }
        if (this.getRaster() != null) {
            return ComplexRaster.of(this.getRaster());
        }
        return null;
    }

    @Column(name="autoupdate")
    public boolean isAutoupdate() {
        return this.autoupdate.get();
    }

    public void setAutoupdate(boolean autoupdate) {
        this.autoupdate.set(autoupdate);
    }

    public final BooleanProperty autoupdateProperty() {
        return this.autoupdate;
    }

    @Column(name="notes_search_policy")
    public SearchPolicy getNotesSearchPolicy() {
        return (SearchPolicy)((Object)this.notesSearchPolicy.get());
    }

    public void setNotesSearchPolicy(SearchPolicy notesSearchPolicy) {
        this.notesSearchPolicy.set((Object)notesSearchPolicy);
    }

    public final ObjectProperty<SearchPolicy> notesSearchPolicyProperty() {
        return this.notesSearchPolicy;
    }

    @Column(name="notes_filter")
    public NoteType getNotesFilter() {
        return (NoteType)((Object)this.notesFilter.get());
    }

    public void setNotesFilter(NoteType filter) {
        this.notesFilter.set((Object)filter);
    }

    public final ObjectProperty<NoteType> notesFilterProperty() {
        return this.notesFilter;
    }

    @OneToMany(mappedBy="chartViewPrefs", orphanRemoval=true, cascade={CascadeType.REMOVE})
    public List<AxisViewPrefs> getAxesViewPrefs() {
        return this.axisViewPrefs;
    }

    protected void setAxesViewPrefs(List<AxisViewPrefs> yAxesViewPrefs) {
        this.axisViewPrefs = yAxesViewPrefs;
    }

    @Transient
    public final AxisViewPrefs getXAxisViewPrefs() {
        for (AxisViewPrefs viewPrefs : this.axisViewPrefs) {
            if (viewPrefs.getYAxis() != null) continue;
            return viewPrefs;
        }
        return null;
    }

    @Transient
    public final AxisViewPrefs getYAxisViewPrefs(YAxis yAxis) {
        for (AxisViewPrefs viewPrefs : this.axisViewPrefs) {
            if (viewPrefs.getYAxis() == null || !viewPrefs.getYAxis().equals(yAxis)) continue;
            return viewPrefs;
        }
        return null;
    }

    @Transient
    public final List<AxisViewPrefs> getYAxesViewPrefs() {
        LinkedList<AxisViewPrefs> yAxisViewPrefs = new LinkedList<AxisViewPrefs>();
        for (AxisViewPrefs viewPrefs : this.axisViewPrefs) {
            if (viewPrefs.getYAxis() == null) continue;
            yAxisViewPrefs.add(viewPrefs);
        }
        return yAxisViewPrefs;
    }

    @Transient
    public final MeasuringUnit getYAxisMU(YAxis yAxis) {
        return this.getYAxisViewPrefs(yAxis).getMeasuringUnit();
    }

    @OneToMany(mappedBy="chartViewPrefs", orphanRemoval=true, cascade={CascadeType.REMOVE})
    public List<Series2DViewPrefs> getSeriesViewPrefs() {
        return this.seriesViewsPrefs;
    }

    protected void setSeriesViewPrefs(List<Series2DViewPrefs> seriesViewPrefs) {
        this.seriesViewsPrefs = seriesViewPrefs;
    }
}

