/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.charts.viewprefs;

import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.charts.Chart3D;
import de.elpro.ewms.core.prefs.IViewPrefs;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.time.TimeRangeFilterType;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.virtualtime.ComplexRaster;
import de.elpro.ewms.core.virtualtime.VirtualRaster;
import de.elpro.ui.model.IdObject;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="ewms_charts_viewprefs_chart3d", uniqueConstraints={@UniqueConstraint(columnNames={"user_id", "chart", "structure_object"})})
@Access(value=AccessType.PROPERTY)
public class Chart3DViewPrefs
implements IViewPrefs,
IdObject {
    public static final String DAO_NAMESPACE = "charts/chart3d_view_prefs";
    private final ObjectProperty<Integer> id = new SimpleObjectProperty();
    private final ObjectProperty<Chart3D> chart = new SimpleObjectProperty();
    private final ObjectProperty<User> user = new SimpleObjectProperty();
    private final ObjectProperty<StructureObject> structureObject = new SimpleObjectProperty();
    private final ObjectProperty<TimeRangeFilterType> timeRangeFilterType = new SimpleObjectProperty();
    private final ObjectProperty<Integer> customViewIndex = new SimpleObjectProperty();
    private final ObjectProperty<Raster> raster = new SimpleObjectProperty();
    private final ObjectProperty<VirtualRaster> virtualRaster = new SimpleObjectProperty();
    private final BooleanProperty autoupdate = new SimpleBooleanProperty(false);
    private final ObjectProperty<MeasuringUnit> xAxisMeasuringUnit = new SimpleObjectProperty();
    private final ObjectProperty<Double> xAxisLowerRange = new SimpleObjectProperty();
    private final ObjectProperty<Double> xAxisUpperRange = new SimpleObjectProperty();
    private final ObjectProperty<MeasuringUnit> yAxisMeasuringUnit = new SimpleObjectProperty();
    private final ObjectProperty<Double> yAxisLowerRange = new SimpleObjectProperty();
    private final ObjectProperty<Double> yAxisUpperRange = new SimpleObjectProperty();
    private final ObjectProperty<MeasuringUnit> zAxisMeasuringUnit = new SimpleObjectProperty();
    private final ObjectProperty<Double> zAxisLowerRange = new SimpleObjectProperty();
    private final ObjectProperty<Double> zAxisUpperRange = new SimpleObjectProperty();
    private final ObjectProperty<MeasuringUnit> wAxisMeasuringUnit = new SimpleObjectProperty();
    private final ObjectProperty<Double> wAxisLowerRange = new SimpleObjectProperty();
    private final ObjectProperty<Double> wAxisUpperRange = new SimpleObjectProperty();

    public Chart3DViewPrefs() {
    }

    public Chart3DViewPrefs(int id) {
        this.setId(this.getId());
    }

    public Chart3DViewPrefs(Chart3D chart, StructureObject structureObject) {
        this.setChart(chart);
        this.setStructureObject(structureObject);
    }

    public Chart3DViewPrefs(int id, Chart3D chart, StructureObject structureObject) {
        this.setId(id);
        this.setChart(chart);
        this.setStructureObject(structureObject);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ewms_charts_viewprefs_chart3d_sequence")
    @SequenceGenerator(name="ewms_charts_viewprefs_chart3d_sequence", sequenceName="ewms_charts_viewprefs_chart3d_sequence")
    public Integer getId() {
        return (Integer)this.id.get();
    }

    public void setId(Integer id) {
        this.id.set((Object)id);
    }

    @ManyToOne
    @JoinColumn(name="chart", nullable=false)
    public Chart3D getChart() {
        return (Chart3D)this.chart.get();
    }

    public void setChart(Chart3D chart) {
        this.chart.set((Object)chart);
    }

    @ManyToOne
    @JoinColumn(name="user_id", nullable=false)
    public User getUser() {
        return (User)this.user.get();
    }

    public void setUser(User user) {
        this.user.set((Object)user);
    }

    @ManyToOne
    @JoinColumn(name="structure_object", nullable=true)
    public StructureObject getStructureObject() {
        return (StructureObject)this.structureObject.get();
    }

    public void setStructureObject(StructureObject structureObject) {
        this.structureObject.set((Object)structureObject);
    }

    public ObjectProperty<TimeRangeFilterType> timeRangeFilterTypeProperty() {
        return this.timeRangeFilterType;
    }

    @Override
    @Column(name="time_range_filter_type")
    public TimeRangeFilterType getTimeRangeFilterType() {
        return (TimeRangeFilterType)((Object)this.timeRangeFilterTypeProperty().get());
    }

    @Override
    public void setTimeRangeFilterType(TimeRangeFilterType timeRangeFilterType) {
        this.timeRangeFilterTypeProperty().set((Object)timeRangeFilterType);
    }

    public ObjectProperty<Integer> customViewIndexProperty() {
        return this.customViewIndex;
    }

    @Override
    @Column(name="custom_view_index")
    public Integer getCustomViewIndex() {
        return (Integer)this.customViewIndexProperty().get();
    }

    @Override
    public void setCustomViewIndex(Integer index) {
        this.customViewIndexProperty().set((Object)index);
    }

    @Override
    @Column(name="raster")
    public Raster getRaster() {
        return (Raster)((Object)this.rasterProperty().get());
    }

    @Override
    public void setRaster(Raster raster) {
        this.rasterProperty().set((Object)raster);
    }

    public final ObjectProperty<Raster> rasterProperty() {
        return this.raster;
    }

    @Override
    @Column(name="virtual_raster")
    public VirtualRaster getVirtualRaster() {
        return (VirtualRaster)((Object)this.virtualRasterProperty().get());
    }

    @Override
    public void setVirtualRaster(VirtualRaster virtualRaster) {
        this.virtualRasterProperty().set((Object)virtualRaster);
    }

    public final ObjectProperty<VirtualRaster> virtualRasterProperty() {
        return this.virtualRaster;
    }

    @Override
    @Transient
    public ComplexRaster getComplexRaster() {
        if (this.getVirtualRaster() != null) {
            return ComplexRaster.of(this.getVirtualRaster());
        }
        if (this.getRaster() != null) {
            return ComplexRaster.of(this.getRaster());
        }
        return null;
    }

    @Column(name="autoupdate")
    public boolean isAutoupdate() {
        return this.autoupdateProperty().get();
    }

    public void setAutoupdate(boolean autoupdate) {
        this.autoupdateProperty().set(autoupdate);
    }

    public BooleanProperty autoupdateProperty() {
        return this.autoupdate;
    }

    public final ObjectProperty<MeasuringUnit> xAxisMeasuringUnitProperty() {
        return this.xAxisMeasuringUnit;
    }

    public MeasuringUnit getXAxisMeasuringUnit() {
        return (MeasuringUnit)this.xAxisMeasuringUnitProperty().get();
    }

    public void setXAxisMeasuringUnit(MeasuringUnit xAxisMeasuringUnit) {
        this.xAxisMeasuringUnitProperty().set((Object)xAxisMeasuringUnit);
    }

    @Transient
    public MeasuringUnit getXAxisResultMeasuringUnit() {
        if (this.getXAxisMeasuringUnit() != null) {
            return this.getXAxisMeasuringUnit();
        }
        return this.getChart().getXAxisResultMeasuringUnit();
    }

    public final ObjectProperty<Double> xAxisLowerRangeProperty() {
        return this.xAxisLowerRange;
    }

    public Double getXAxisLowerRange() {
        return (Double)this.xAxisLowerRangeProperty().get();
    }

    public void setXAxisLowerRange(Double xAxisLowerRange) {
        this.xAxisLowerRangeProperty().set((Object)xAxisLowerRange);
    }

    public final ObjectProperty<Double> xAxisUpperRangeProperty() {
        return this.xAxisUpperRange;
    }

    public Double getXAxisUpperRange() {
        return (Double)this.xAxisUpperRangeProperty().get();
    }

    public void setXAxisUpperRange(Double xAxisUpperRange) {
        this.xAxisUpperRangeProperty().set((Object)xAxisUpperRange);
    }

    public final ObjectProperty<MeasuringUnit> yAxisMeasuringUnitProperty() {
        return this.yAxisMeasuringUnit;
    }

    public MeasuringUnit getYAxisMeasuringUnit() {
        return (MeasuringUnit)this.yAxisMeasuringUnitProperty().get();
    }

    public void setYAxisMeasuringUnit(MeasuringUnit yAxisMeasuringUnit) {
        this.yAxisMeasuringUnitProperty().set((Object)yAxisMeasuringUnit);
    }

    @Transient
    public MeasuringUnit getYAxisResultMeasuringUnit() {
        if (this.getYAxisMeasuringUnit() != null) {
            return this.getYAxisMeasuringUnit();
        }
        return this.getChart().getYAxisResultMeasuringUnit();
    }

    public final ObjectProperty<Double> yAxisLowerRangeProperty() {
        return this.yAxisLowerRange;
    }

    public Double getYAxisLowerRange() {
        return (Double)this.yAxisLowerRangeProperty().get();
    }

    public void setYAxisLowerRange(Double yAxisLowerRange) {
        this.yAxisLowerRangeProperty().set((Object)yAxisLowerRange);
    }

    public final ObjectProperty<Double> yAxisUpperRangeProperty() {
        return this.yAxisUpperRange;
    }

    public Double getYAxisUpperRange() {
        return (Double)this.yAxisUpperRangeProperty().get();
    }

    public void setYAxisUpperRange(Double yAxisUpperRange) {
        this.yAxisUpperRangeProperty().set((Object)yAxisUpperRange);
    }

    public final ObjectProperty<MeasuringUnit> zAxisMeasuringUnitProperty() {
        return this.zAxisMeasuringUnit;
    }

    public MeasuringUnit getZAxisMeasuringUnit() {
        return (MeasuringUnit)this.zAxisMeasuringUnitProperty().get();
    }

    @Transient
    public MeasuringUnit getZAxisResultMeasuringUnit() {
        if (this.getZAxisMeasuringUnit() != null) {
            return this.getZAxisMeasuringUnit();
        }
        return this.getChart().getZAxisResultMeasuringUnit();
    }

    public void setZAxisMeasuringUnit(MeasuringUnit zAxisMeasuringUnit) {
        this.zAxisMeasuringUnitProperty().set((Object)zAxisMeasuringUnit);
    }

    public final ObjectProperty<Double> zAxisLowerRangeProperty() {
        return this.zAxisLowerRange;
    }

    public Double getZAxisLowerRange() {
        return (Double)this.zAxisLowerRangeProperty().get();
    }

    public void setZAxisLowerRange(Double zAxisLowerRange) {
        this.zAxisLowerRangeProperty().set((Object)zAxisLowerRange);
    }

    public final ObjectProperty<Double> zAxisUpperRangeProperty() {
        return this.zAxisUpperRange;
    }

    public Double getZAxisUpperRange() {
        return (Double)this.zAxisUpperRangeProperty().get();
    }

    public void setZAxisUpperRange(Double zAxisUpperRange) {
        this.zAxisUpperRangeProperty().set((Object)zAxisUpperRange);
    }

    public ObjectProperty<MeasuringUnit> wAxisMeasuringUnitProperty() {
        return this.wAxisMeasuringUnit;
    }

    public MeasuringUnit getWAxisMeasuringUnit() {
        return (MeasuringUnit)this.wAxisMeasuringUnitProperty().get();
    }

    @Transient
    public MeasuringUnit getWAxisResultMeasuringUnit() {
        if (this.getWAxisMeasuringUnit() != null) {
            return this.getWAxisMeasuringUnit();
        }
        return this.getChart().getWAxisResultMeasuringUnit();
    }

    public void setWAxisMeasuringUnit(MeasuringUnit wAxisMeasuringUnit) {
        this.wAxisMeasuringUnitProperty().set((Object)wAxisMeasuringUnit);
    }

    public ObjectProperty<Double> wAxisLowerRangeProperty() {
        return this.wAxisLowerRange;
    }

    public Double getWAxisLowerRange() {
        return (Double)this.wAxisLowerRangeProperty().get();
    }

    public void setWAxisLowerRange(Double wAxisLowerRange) {
        this.wAxisLowerRangeProperty().set((Object)wAxisLowerRange);
    }

    public ObjectProperty<Double> wAxisUpperRangeProperty() {
        return this.wAxisUpperRange;
    }

    public Double getWAxisUpperRange() {
        return (Double)this.wAxisUpperRangeProperty().get();
    }

    public void setWAxisUpperRange(Double wAxisUpperRange) {
        this.wAxisUpperRangeProperty().set((Object)wAxisUpperRange);
    }
}

