/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.charts.viewprefs;

import de.elpro.ewms.core.charts.LineType;
import de.elpro.ewms.core.charts.ShapeType;
import de.elpro.ewms.core.charts.VarSeries2D;
import de.elpro.ewms.core.charts.viewprefs.Chart2DViewPrefs;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.time.TimelinePhase;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ui.fx.utils.FXUtils;
import de.elpro.ui.model.IdObject;
import de.elpro.ui.model.UIModelElement;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="ewms_charts_viewprefs_series", uniqueConstraints={@UniqueConstraint(columnNames={"chart_view_prefs", "var_series", "variable_instance", "timeline_phase"})})
@Access(value=AccessType.PROPERTY)
public class Series2DViewPrefs
implements UIModelElement,
IdObject {
    public static final String DAO_NAMESPACE = "charts/chart2d/var_series_view_prefs";
    private final ObjectProperty<Integer> id = new SimpleObjectProperty();
    private final ObjectProperty<Chart2DViewPrefs> chartViewPrefs = new SimpleObjectProperty();
    private final ObjectProperty<VarSeries2D> series = new SimpleObjectProperty();
    private final ObjectProperty<StructureObject> customDataStructureObject = new SimpleObjectProperty();
    private final ObjectProperty<VariableInstance> variableInstance = new SimpleObjectProperty();
    private final ObjectProperty<TimelinePhase> timelinePhase = new SimpleObjectProperty();
    private final BooleanProperty isVisible = new SimpleBooleanProperty(true);
    private final ObjectProperty<LineType> lineType = new SimpleObjectProperty((Object)LineType.Solid);
    private final ObjectProperty<Integer> lineWidth = new SimpleObjectProperty();
    private final ObjectProperty<Color> color = new SimpleObjectProperty();
    private final ObjectProperty<ShapeType> shapeType = new SimpleObjectProperty((Object)ShapeType.None);
    private final ObjectProperty<Integer> shapeSize = new SimpleObjectProperty();
    private final BooleanProperty showValuesBounds = new SimpleBooleanProperty(false);
    private final ObjectProperty<Integer> visualOrderPosition = new SimpleObjectProperty();
    private transient ChangeListener<Object> listener;

    public Series2DViewPrefs() {
    }

    public Series2DViewPrefs(int id) {
        this.setId(id);
    }

    public Series2DViewPrefs(Chart2DViewPrefs chartViewPrefs, VarSeries2D series, VariableInstance instance) {
        this(chartViewPrefs, series, instance, null);
    }

    public Series2DViewPrefs(Chart2DViewPrefs chartViewPrefs, VarSeries2D series, VariableInstance instance, TimelinePhase phase) {
        this.setChartViewPrefs(chartViewPrefs);
        this.setSeries(series);
        this.setVariableInstance(instance);
        this.setTimelinePhase(phase);
        this.setColor(series.getDefaultColor());
        this.setLineType(series.getLineType());
        this.setLineWidth(series.getLineWidth());
        this.setShapeType(series.getShapeType());
        this.setShapeSize(series.getShapeSize());
        this.setShowValuesBounds(series.isShowValuesBounds());
        this.setVisible(series.isVisible());
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ewms_charts_viewprefs_series_sequence")
    @SequenceGenerator(name="ewms_charts_viewprefs_series_sequence", sequenceName="ewms_charts_viewprefs_series_sequence")
    public Integer getId() {
        return (Integer)this.id.get();
    }

    public void setId(int id) {
        this.id.set((Object)id);
    }

    @ManyToOne
    @JoinColumn(name="chart_view_prefs", nullable=false)
    public Chart2DViewPrefs getChartViewPrefs() {
        return (Chart2DViewPrefs)this.chartViewPrefs.get();
    }

    public void setChartViewPrefs(Chart2DViewPrefs prefs) {
        this.chartViewPrefs.set((Object)prefs);
    }

    @ManyToOne
    @JoinColumn(name="var_series", nullable=false)
    public VarSeries2D getSeries() {
        return (VarSeries2D)this.series.get();
    }

    public void setSeries(VarSeries2D series) {
        this.series.set((Object)series);
    }

    @ManyToOne
    @JoinColumn(name="variable_instance", nullable=false)
    public VariableInstance getVariableInstance() {
        return (VariableInstance)((Object)this.variableInstance.get());
    }

    public void setVariableInstance(VariableInstance instance) {
        this.variableInstance.set((Object)instance);
    }

    @Transient
    public StructureObject getCustomDataStructureObject() {
        return (StructureObject)this.customDataStructureObject.get();
    }

    public void setCustomDataStructureObject(StructureObject customDataStructureObject) {
        this.customDataStructureObject.set((Object)customDataStructureObject);
    }

    @ManyToOne
    @JoinColumn(name="timeline_phase", nullable=true)
    public TimelinePhase getTimelinePhase() {
        return (TimelinePhase)this.timelinePhase.get();
    }

    public void setTimelinePhase(TimelinePhase phase) {
        this.timelinePhase.set((Object)phase);
    }

    @Column(name="is_visible", nullable=false)
    public boolean isVisible() {
        return this.isVisible.get();
    }

    public void setVisible(boolean isVisible) {
        this.isVisible.set(isVisible);
    }

    @Transient
    public final BooleanProperty isVisibleProperty() {
        return this.isVisible;
    }

    @Column(name="line_type")
    public LineType getLineType() {
        return (LineType)((Object)this.lineType.get());
    }

    public void setLineType(LineType lineType) {
        this.lineType.set((Object)lineType);
    }

    public final ObjectProperty<LineType> lineTypeProperty() {
        return this.lineType;
    }

    @Column(name="line_width")
    public Integer getLineWidth() {
        return (Integer)this.lineWidth.get();
    }

    public void setLineWidth(Integer lineWidth) {
        this.lineWidth.set((Object)lineWidth);
    }

    public final ObjectProperty<Integer> lineWidthProperty() {
        return this.lineWidth;
    }

    @Column(name="color")
    public Color getColor() {
        return (Color)this.color.get();
    }

    public void setColor(Color pain) {
        this.color.set((Object)pain);
    }

    public final ObjectProperty<Color> colorProperty() {
        return this.color;
    }

    @Transient
    public java.awt.Color getAwtColor() {
        return FXUtils.getAwtColor((Paint)this.getColor());
    }

    @Column(name="shape_type")
    public ShapeType getShapeType() {
        return (ShapeType)((Object)this.shapeType.get());
    }

    public void setShapeType(ShapeType shapeType) {
        this.shapeType.set((Object)shapeType);
    }

    public final ObjectProperty<ShapeType> shapeTypeProperty() {
        return this.shapeType;
    }

    @Column(name="shape_size")
    public Integer getShapeSize() {
        return (Integer)this.shapeSize.get();
    }

    public void setShapeSize(Integer shapeSize) {
        this.shapeSize.set((Object)shapeSize);
    }

    public final ObjectProperty<Integer> shapeSizeProperty() {
        return this.shapeSize;
    }

    @Column(name="show_values_bounds", nullable=false, columnDefinition="BOOLEAN DEFAULT FALSE")
    public boolean isShowValuesBounds() {
        return this.showValuesBounds.get();
    }

    public void setShowValuesBounds(boolean showValuesBounds) {
        this.showValuesBounds.set(showValuesBounds);
    }

    public final BooleanProperty showValuesBoundsProperty() {
        return this.showValuesBounds;
    }

    @Column(name="visual_order_position")
    public Integer getVisualOrderPosition() {
        return (Integer)this.visualOrderPosition.get();
    }

    public void setVisualOrderPosition(Integer visualOrderPosition) {
        this.visualOrderPosition.set((Object)visualOrderPosition);
    }

    public final ObjectProperty<Integer> visualOrderPositionProperty() {
        return this.visualOrderPosition;
    }

    @Transient
    public Node getGraphic() {
        Group container = new Group();
        Node c = VarSeries2D.createGraphic(this.getColor(), this.getLineType(), this.getShapeType());
        if (c != null) {
            container.getChildren().add((Object)c);
        }
        if (this.listener != null) {
            this.lineType.removeListener(this.listener);
            this.shapeType.removeListener(this.listener);
            this.color.removeListener(this.listener);
        }
        this.listener = (o, ov, nv) -> {
            if (ov != nv) {
                container.getChildren().setAll((Object[])new Node[]{VarSeries2D.createGraphic(this.getColor(), this.getLineType(), this.getShapeType())});
            }
        };
        this.lineType.addListener(this.listener);
        this.shapeType.addListener(this.listener);
        this.color.addListener(this.listener);
        return container;
    }

    public String toString() {
        String resultTitle = this.getSeries().getResultTitle();
        if (this.getTimelinePhase() == null) {
            return resultTitle;
        }
        if (resultTitle == null || resultTitle.isEmpty()) {
            return this.getTimelinePhase().getLocalLabel();
        }
        return String.format("%s (%s)", resultTitle, this.getTimelinePhase().getLocalLabel());
    }

    @Transient
    public String getAltId() {
        return String.format("[%s - %s]", new Object[]{this.toString(), this.getVariableInstance()});
    }

    public Series2DViewPrefs clone(Chart2DViewPrefs prefs, VariableInstance instance) {
        Series2DViewPrefs clone = new Series2DViewPrefs(prefs, this.getSeries(), instance, this.getTimelinePhase());
        clone.setVisible(this.isVisible());
        clone.setLineType(this.getLineType());
        clone.setLineWidth(this.getLineWidth());
        clone.setColor(this.getColor());
        clone.setShapeType(this.getShapeType());
        clone.setShapeSize(this.getShapeSize());
        return clone;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Series2DViewPrefs) {
            if (this.getId() == null) {
                return super.equals(obj);
            }
            if (this.getId().equals(((Series2DViewPrefs)obj).getId())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.getId() == null) {
            return super.hashCode();
        }
        return Series2DViewPrefs.class.hashCode() + 17 * this.getId();
    }
}

