/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.component;

import de.elpro.ewms.core.component.ClientComponentBase;
import de.elpro.ewms.core.component.CompatibilityException;
import de.elpro.ewms.core.component.ComponentBase;
import de.elpro.ewms.core.component.ComponentCompatibilityError;
import de.elpro.ewms.core.component.ComponentDependency;
import de.elpro.ewms.core.component.ProductInfo;
import de.elpro.ewms.core.component.ServerInfo;
import java.util.ArrayList;
import java.util.Arrays;
import org.osgi.framework.Version;

public class ClientInfo
extends ProductInfo {
    private final ClientComponentBase[] components;

    public ClientInfo(String productName, String productId, Version productVersion, String javaVersion, ClientComponentBase[] components) {
        super(productName, productId, productVersion, javaVersion);
        this.components = components;
    }

    public ClientComponentBase[] getComponents() {
        return this.components;
    }

    public ClientComponentBase getComponent(String id) {
        return Arrays.stream(this.components).filter(c -> c.getId().equals(id)).findAny().orElse(null);
    }

    public ClientComponentBase getCoreComponent() {
        return this.getComponent("com.eos.core");
    }

    public void checkCompatibility(ServerInfo serverInfo) throws CompatibilityException {
        ArrayList<ComponentCompatibilityError> errors = new ArrayList<ComponentCompatibilityError>();
        ClientComponentBase[] clientComponentBaseArray = this.components;
        int n = this.components.length;
        int n2 = 0;
        while (n2 < n) {
            ClientComponentBase clientComponent = clientComponentBaseArray[n2];
            ArrayList<ComponentDependency> missingDependencies = new ArrayList<ComponentDependency>();
            ArrayList<ComponentDependency> missmatchDependencies = new ArrayList<ComponentDependency>();
            ComponentDependency[] componentDependencyArray = clientComponent.getServerDependencies();
            int n3 = componentDependencyArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ComponentBase serverComponent;
                ComponentDependency depenency = componentDependencyArray[n4];
                ComponentBase componentBase = serverComponent = serverInfo != null ? serverInfo.getComponent(depenency.getId()) : null;
                if (serverComponent == null) {
                    missingDependencies.add(depenency);
                } else {
                    boolean versionMatch = depenency.matchNoQualifier(serverComponent.getVersion());
                    if (!versionMatch) {
                        missmatchDependencies.add(depenency);
                    }
                }
                if (!missingDependencies.isEmpty() || !missmatchDependencies.isEmpty()) {
                    errors.add(new ComponentCompatibilityError(this.getCoreComponent(), (ComponentDependency[])missingDependencies.toArray(ComponentDependency[]::new), (ComponentDependency[])missingDependencies.toArray(ComponentDependency[]::new)));
                }
                ++n4;
            }
            ++n2;
        }
        if (!errors.isEmpty()) {
            throw new CompatibilityException((ComponentCompatibilityError[])errors.toArray(ComponentCompatibilityError[]::new));
        }
    }
}

