/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.component;

import de.elpro.ewms.core.component.ComponentCompatibilityError;
import de.elpro.ewms.core.component.ComponentDependency;

public class CompatibilityException
extends Exception {
    private static final long serialVersionUID = 6192639726121411997L;
    private final ComponentCompatibilityError[] errors;

    public CompatibilityException(ComponentCompatibilityError[] errors) {
        this.errors = errors;
    }

    public ComponentCompatibilityError[] getErrors() {
        return this.errors;
    }

    @Override
    public String toString() {
        String versionWarning = "";
        ComponentCompatibilityError[] componentCompatibilityErrorArray = this.errors;
        int n = this.errors.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentCompatibilityError error = componentCompatibilityErrorArray[n2];
            versionWarning = String.valueOf(versionWarning) + String.format("Client component %s (id: %s) errors:", error.getClientComponent().getName(), error.getClientComponent().getId());
            ComponentDependency[] componentDependencyArray = error.getMissingDependencies();
            int n3 = componentDependencyArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ComponentDependency missingDependency = componentDependencyArray[n4];
                versionWarning = String.valueOf(versionWarning) + String.format("\tMissing required server component (id: %s)", missingDependency.getId());
                ++n4;
            }
            componentDependencyArray = error.getMissmatchDependencies();
            n3 = componentDependencyArray.length;
            n4 = 0;
            while (n4 < n3) {
                ComponentDependency missmatchDependency = componentDependencyArray[n4];
                versionWarning = String.valueOf(versionWarning) + String.format("\tMissmatching component version (id: %s) %s", missmatchDependency.getId(), missmatchDependency.getMinVersion().equals((Object)missmatchDependency.getMaxVersion()) ? String.format("[%s]", missmatchDependency.getMinVersion()) : String.format("[%s, %s)", missmatchDependency.getMinVersion(), missmatchDependency.getMaxVersion()));
                ++n4;
            }
            ++n2;
        }
        return versionWarning;
    }
}

