/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.component;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.osgi.framework.Version;

public class VersionUtils {
    public static Version noQualifier(Version version) {
        if (version == null) {
            return null;
        }
        return new Version(version.getMajor(), version.getMinor(), version.getMicro());
    }

    public static String toString(Version version) {
        if (version == null) {
            return Version.emptyVersion.toString();
        }
        return version.toString();
    }

    public static String toStringNoQualifier(Version version) {
        if (version == null) {
            return Version.emptyVersion.toString();
        }
        return VersionUtils.toString(VersionUtils.noQualifier(version));
    }

    public static ZonedDateTime getBuildTimestamp(Version version) {
        if (version == null || version.getQualifier() == null || version.getQualifier().equals("qualifier")) {
            return null;
        }
        String qualifier = version.getQualifier();
        if (!"qualifier".equals(qualifier) && qualifier.length() == 12) {
            try {
                int year = Integer.parseInt(qualifier.substring(0, 4));
                int month = Integer.parseInt(qualifier.substring(4, 6));
                int day = Integer.parseInt(qualifier.substring(6, 8));
                int hour = Integer.parseInt(qualifier.substring(8, 10));
                int minute = Integer.parseInt(qualifier.substring(10, 12));
                LocalDateTime localTime = LocalDateTime.of(year, month, day, hour, minute);
                ZonedDateTime utcTime = ZonedDateTime.of(localTime, ZoneOffset.UTC);
                return utcTime;
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public static boolean exactMatchNoQualifier(Version version1, Version version2) {
        if (version1 == version2) {
            return true;
        }
        if (version1.equals((Object)version2)) {
            return true;
        }
        if (version1 != null && version2 != null) {
            return VersionUtils.noQualifier(version1).equals((Object)VersionUtils.noQualifier(version2));
        }
        return false;
    }

    public static boolean matchBetweenNoQualifier(Version version, Version minVersion, Version maxVersion) {
        version = VersionUtils.noQualifier(version);
        return !((minVersion = VersionUtils.noQualifier(minVersion)).equals((Object)(maxVersion = VersionUtils.noQualifier(maxVersion))) ? !version.equals((Object)minVersion) : minVersion.compareTo(version) > 0 || maxVersion != null && maxVersion.compareTo(version) <= 0);
    }
}

