/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.datasource;

import de.elpro.ewms.core.datasource.DataClientState;
import de.elpro.ewms.core.datasource.DataSource;
import de.elpro.ewms.core.datasource.IDataSource;
import de.elpro.ewms.core.datasource.opcua.MessageSecurityMode;
import de.elpro.ewms.core.datasource.opcua.MessageSecurityPolicy;
import de.elpro.ui.model.IdObject;
import de.elpro.ui.model.UIModelElement;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="ewms_datasource_source_alt", uniqueConstraints={@UniqueConstraint(columnNames={"master", "source_name"})})
public class DataSourceAlt
implements UIModelElement,
IDataSource,
IdObject {
    public static final String DAO_NAMESPACE = "datasource/source_alt";
    private final ObjectProperty<Integer> id = new SimpleObjectProperty();
    private final ObjectProperty<DataSource> master = new SimpleObjectProperty();
    private final StringProperty name = new SimpleStringProperty();
    private final IntegerProperty pritority = new SimpleIntegerProperty(1);
    private final StringProperty hostName = new SimpleStringProperty();
    private final StringProperty hostIpAddr = new SimpleStringProperty();
    private final ObjectProperty<Integer> hostPortNr = new SimpleObjectProperty();
    private final StringProperty instance = new SimpleStringProperty();
    private final ObjectProperty<MessageSecurityPolicy> securityPolicy = new SimpleObjectProperty((Object)MessageSecurityPolicy.None);
    private final ObjectProperty<MessageSecurityMode> messageSecurityMode = new SimpleObjectProperty((Object)MessageSecurityMode.None);
    private final StringProperty user = new SimpleStringProperty();
    private final StringProperty password = new SimpleStringProperty();
    private final StringProperty cultureInfo = new SimpleStringProperty();
    private final StringProperty plcAliasMapText = new SimpleStringProperty();
    private SimpleObjectProperty<DataClientState> connected = new SimpleObjectProperty();

    public DataSourceAlt() {
    }

    public DataSourceAlt(int id) {
        this.setId(id);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ewms_datasource_source_alt_sequence")
    @SequenceGenerator(name="ewms_datasource_source_alt_sequence", sequenceName="ewms_datasource_source_alt_sequence")
    public Integer getId() {
        return (Integer)this.id.get();
    }

    public void setId(int id) {
        this.id.set((Object)id);
    }

    public final ObjectProperty<Integer> idProperty() {
        return this.id;
    }

    @ManyToOne
    @JoinColumn(name="master", nullable=false)
    public DataSource getMaster() {
        return (DataSource)this.master.get();
    }

    public void setMaster(DataSource master) {
        this.master.set((Object)master);
    }

    public final ObjectProperty<DataSource> masterProperty() {
        return this.master;
    }

    @Column(name="priority", nullable=false)
    public int getPriority() {
        return this.pritority.get();
    }

    public void setPriority(int priority) {
        this.pritority.set(priority);
    }

    public final IntegerProperty priorityProperty() {
        return this.pritority;
    }

    @Column(name="source_name")
    public String getName() {
        return (String)this.name.get();
    }

    public void setName(String opcName) {
        this.name.set((Object)opcName);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    @Override
    @Column(name="host_name")
    public String getHostName() {
        return (String)this.hostName.get();
    }

    public void setHostName(String hostName) {
        this.hostName.set((Object)hostName);
    }

    public final StringProperty hostNameProperty() {
        return this.hostName;
    }

    @Override
    @Column(name="host_ip_addr")
    public String getHostIpAddr() {
        return (String)this.hostIpAddr.get();
    }

    public void setHostIpAddr(String hostIpAdd) {
        this.hostIpAddr.set((Object)hostIpAdd);
    }

    public final StringProperty hostIpAddrProperty() {
        return this.hostIpAddr;
    }

    @Override
    @Column(name="host_port_nr")
    public Integer getHostPortNr() {
        return (Integer)this.hostPortNr.get();
    }

    public void setHostPortNr(Integer hostPortNr) {
        this.hostPortNr.set((Object)hostPortNr);
    }

    public final ObjectProperty<Integer> hostPortNrProperty() {
        return this.hostPortNr;
    }

    @Override
    @Column(name="instance")
    public String getInstance() {
        return (String)this.instance.get();
    }

    public void setInstance(String instance) {
        this.instance.set((Object)instance);
    }

    public final StringProperty instanceProperty() {
        return this.instance;
    }

    public final ObjectProperty<MessageSecurityPolicy> securityPolicyProperty() {
        return this.securityPolicy;
    }

    @Override
    @Column(name="security_policy", nullable=false, columnDefinition="INTEGER DEFAULT 3")
    public MessageSecurityPolicy getSecurityPolicy() {
        return (MessageSecurityPolicy)((Object)this.securityPolicyProperty().get());
    }

    public void setSecurityPolicy(MessageSecurityPolicy securityPoliy) {
        this.securityPolicyProperty().set((Object)securityPoliy);
    }

    public final ObjectProperty<MessageSecurityMode> messageSecurityModeProperty() {
        return this.messageSecurityMode;
    }

    @Override
    @Column(name="message_security_mode", nullable=false, columnDefinition="INTEGER DEFAULT 2")
    public MessageSecurityMode getMessageSecurityMode() {
        return (MessageSecurityMode)((Object)this.messageSecurityModeProperty().get());
    }

    public void setMessageSecurityMode(MessageSecurityMode messageSecurityMode) {
        this.messageSecurityModeProperty().set((Object)messageSecurityMode);
    }

    @Override
    @Column(name="user_login")
    public String getUser() {
        return (String)this.user.get();
    }

    public void setUser(String user) {
        this.user.set((Object)user);
    }

    public StringProperty userProperty() {
        return this.user;
    }

    @Override
    @Column(name="password")
    public String getPassword() {
        return (String)this.password.get();
    }

    public void setPassword(String password) {
        this.password.set((Object)password);
    }

    public StringProperty passwordProperty() {
        return this.password;
    }

    @Override
    @Column(name="culture_info")
    public String getCultureInfo() {
        return (String)this.cultureInfo.get();
    }

    public void setCultureInfo(String cultureInfo) {
        this.cultureInfo.set((Object)cultureInfo);
    }

    public StringProperty cultureInfoProperty() {
        return this.cultureInfo;
    }

    @Column(name="plc_alias_map_text", columnDefinition="TEXT")
    public String getPlcAliasMapText() {
        return (String)this.plcAliasMapText.get();
    }

    public void setPlcAliasMapText(String plcAliasMapText) {
        this.plcAliasMapText.set((Object)plcAliasMapText);
    }

    public final StringProperty plcAliasMapTextProperty() {
        return this.plcAliasMapText;
    }

    @Override
    @Transient
    public Map<String, String> getPlcAliasMap() {
        String[] aliases;
        String plcAliasMapText = this.getPlcAliasMapText();
        if (plcAliasMapText == null || plcAliasMapText.trim().isEmpty()) {
            return null;
        }
        HashMap<String, String> aliasMap = new HashMap<String, String>();
        String[] stringArray = aliases = plcAliasMapText.split(";");
        int n = aliases.length;
        int n2 = 0;
        while (n2 < n) {
            String alias = stringArray[n2];
            String[] aliasParts = alias.split("=");
            if (aliasParts.length == 2) {
                String aliasKey = aliasParts[0].trim();
                String aliasValue = aliasParts[1].trim();
                aliasMap.put(aliasKey, aliasValue);
            }
            ++n2;
        }
        return aliasMap;
    }

    @Transient
    public String getIconUri() {
        if (this.isConnected()) {
            return DataSource.CONNECTED_ICON.toString();
        }
        return DataSource.DISCONNECTED_ICON.toString();
    }

    public final ObjectProperty<DataClientState> connectedProperty() {
        return this.connected;
    }

    @Transient
    public boolean isConnected() {
        return this.connectedProperty().get() == DataClientState.Connected;
    }

    public void setConnected(DataClientState connected) {
        this.connectedProperty().set((Object)connected);
    }

    public String toString() {
        if (this.getName() != null) {
            return this.getName();
        }
        if (this.getHostName() != null) {
            return this.getHostName();
        }
        return this.getHostIpAddr();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DataSourceAlt) {
            if (this.getId() == null) {
                return super.equals(obj);
            }
            if (this.getId().equals(((DataSourceAlt)obj).getId())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.getId() == null) {
            return super.hashCode();
        }
        return DataSourceAlt.class.hashCode() + 17 * (Integer)this.id.get();
    }
}

