/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.datasource;

import de.elpro.ewms.core.datasource.IdentifierType;
import de.elpro.ewms.core.datasource.SignalType;
import de.elpro.resources.Icons;
import de.elpro.resources.Resources;
import de.elpro.ui.model.UIModelElement;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.persistence.Transient;

public class SignalId
implements UIModelElement {
    private final StringProperty namespace = new SimpleStringProperty((Object)this, "Namespace");
    private final StringProperty identifier = new SimpleStringProperty((Object)this, "Identifier");
    private final StringProperty identifierType = new SimpleStringProperty();
    private final StringProperty displayName = new SimpleStringProperty((Object)this, "Display Name");
    private final ObjectProperty<SignalType> type = new SimpleObjectProperty((Object)this, "Type");
    private Map<String, String> genericProperites = new LinkedHashMap<String, String>();
    public static final URL FOLDER_ICON = Icons.FOLDER_ITEM_URL;
    public static final URL PROPERTY_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"ewms/opc/document-properties.png");
    public static final URL VARIABLE_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"ewms/opc/tag.png");
    public static final URL METHOD_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"ewms/opc/method.png");
    public static final URL DATA_READ_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"eclipse/read_obj.gif");
    public static final URL DATA_READWRITE_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"eclipse/readwrite_obj.gif");
    public static final URL DATA_WRITE_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"eclipse/write_obj.gif");
    public static final URL NO_ACCESS_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"eclipse/error_co.gif");
    public static final URL OTHER_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"ewms/opc/folder-information.png");
    public static final URL UNKNOWN_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"eclipse/unknown_obj.gif");

    public SignalId() {
    }

    public SignalId(String namespace, String identifier, IdentifierType identifierType) {
        this.setNamespace(namespace);
        this.setIdentifier(identifier);
        this.setIdentifierType(identifierType.name());
    }

    public String getNamespace() {
        return (String)this.namespace.get();
    }

    public void setNamespace(String namespace) {
        this.namespace.set((Object)namespace);
    }

    public String getIdentifier() {
        return (String)this.identifier.get();
    }

    public void setIdentifier(String identifier) {
        this.identifier.set((Object)identifier);
    }

    public String getIdentifierType() {
        return (String)this.identifierType.get();
    }

    public Object getIdentifierObject() {
        if (this.getIdentifier() == null || this.getIdentifier().isEmpty()) {
            return null;
        }
        switch (this.getIdentifierType()) {
            case "UUID": {
                return UUID.fromString(this.getIdentifier());
            }
            case "Numeric": {
                return Integer.parseInt(this.getIdentifier());
            }
            case "String": {
                return this.getIdentifier();
            }
            case "Opaque": {
                return this.getIdentifier().getBytes();
            }
        }
        return null;
    }

    public void setIdentifierType(String identifierType) {
        this.identifierType.set((Object)identifierType);
    }

    public String getDisplayName() {
        return (String)this.displayName.get();
    }

    public void setDisplayName(String displayName) {
        this.displayName.set((Object)displayName);
    }

    public SignalType getType() {
        return (SignalType)((Object)this.type.get());
    }

    public void setType(SignalType type) {
        this.type.set((Object)type);
    }

    public final ObjectProperty<SignalType> typeProperty() {
        return this.type;
    }

    public Map<String, String> getGenericProperties() {
        return this.genericProperites;
    }

    public void addGenericProperty(String key, String value) {
        this.genericProperites.put(key, value);
    }

    public void deleteGenericProperty(String key) {
        this.genericProperites.remove(key);
    }

    public String toString() {
        String displayName = this.getDisplayName();
        if (displayName == null) {
            return this.getIdentifier();
        }
        return displayName;
    }

    @Transient
    public String getFullId() {
        return String.format("%s/%s[%s]", this.getNamespace(), this.getIdentifier(), this.getType() != null ? this.getType().name() : SignalType.Unknown.name());
    }

    public String getIconUri() {
        SignalType signalType = this.getType();
        if (signalType == null) {
            return UNKNOWN_ICON.toString();
        }
        switch (signalType) {
            case Folder: {
                return FOLDER_ICON.toString();
            }
            case Variable: {
                return VARIABLE_ICON.toString();
            }
            case Property: {
                return PROPERTY_ICON.toString();
            }
            case Method: {
                return METHOD_ICON.toString();
            }
            case Other: {
                return OTHER_ICON.toString();
            }
        }
        return UNKNOWN_ICON.toString();
    }
}

