/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.datasource.opcua.datatypes;

import com.google.common.base.MoreObjects;
import de.elpro.ewms.core.datasource.opcua.IdentifierType;
import de.elpro.ewms.core.primitivetypes.ByteString;
import java.util.UUID;

public class NodeId {
    private int nameSpaceIndex;
    private IdentifierType identifierType;
    private Object identifier;

    public NodeId() {
        this.nameSpaceIndex = 0;
        this.identifierType = IdentifierType.Numeric;
        this.identifier = 0;
    }

    public NodeId(int nameSpaceIndex, IdentifierType identifierType, Object identifier) {
        this.nameSpaceIndex = nameSpaceIndex;
        this.identifierType = identifierType;
        this.identifier = identifier;
    }

    public NodeId(int nameSpaceIndex, Integer identifierType, Object identifier) {
        this(nameSpaceIndex, IdentifierType.from(identifierType), identifier);
    }

    public int getNameSpaceIndex() {
        return this.nameSpaceIndex;
    }

    public void setNameSpaceIndex(int nameSpaceIndex) {
        this.nameSpaceIndex = nameSpaceIndex;
    }

    public IdentifierType getIdentifierType() {
        return this.identifierType;
    }

    public void setIdentifierType(IdentifierType identifierType) {
        this.identifierType = identifierType;
    }

    public Object getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(Object identifier) {
        this.identifier = identifier;
    }

    public String toString() {
        String txt = MoreObjects.toStringHelper((Object)this).add("identifierType", (Object)this.identifierType.toString()).add("identifier", (Object)this.identifier.toString()).add("nameSpaceIndex", this.nameSpaceIndex).toString();
        return txt;
    }

    public static NodeId parse(String s) {
        String[] parts1;
        NodeId nid = new NodeId(0, IdentifierType.String, (Object)"");
        IdentifierType identifierType = IdentifierType.String;
        Object id = "";
        Integer index = 0;
        if (s != null && (parts1 = s.split("\\{")).length > 1 && parts1[0].equals("NodeId")) {
            String[] parts2 = (parts1 = parts1[1].split(","))[0].split("=");
            if (parts2.length > 1) {
                nid.identifierType = identifierType = IdentifierType.valueOf(parts2[1]);
            }
            if ((parts2 = parts1[1].split("=")).length > 1) {
                String ids = parts2[1];
                switch (identifierType) {
                    case Numeric: {
                        id = Integer.decode(ids);
                        break;
                    }
                    case String: {
                        id = ids;
                        break;
                    }
                    case Guid: {
                        id = UUID.fromString(ids);
                        break;
                    }
                    case Opaque: {
                        id = new ByteString(ids);
                    }
                }
                nid.identifier = id;
            }
            if ((parts2 = parts1[2].split("=")).length > 1) {
                index = Integer.decode(parts2[1].substring(0, parts2[1].length() - 1));
                nid.nameSpaceIndex = index;
            }
        }
        return nid;
    }
}

