/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.datasource.opcua.datatypes;

import com.google.common.base.MoreObjects;

public final class QualifiedName {
    public static final QualifiedName NULL_VALUE = new QualifiedName(0, null);
    private final Integer namespaceIndex;
    private final String name;

    public QualifiedName() {
        this.namespaceIndex = 0;
        this.name = "";
    }

    public QualifiedName(Integer namespaceIndex, String name) {
        this.namespaceIndex = namespaceIndex;
        this.name = name;
    }

    public int getNamespaceIndex() {
        return this.namespaceIndex;
    }

    public String getName() {
        return this.name;
    }

    public boolean isNull() {
        return this.name == null;
    }

    public boolean isNotNull() {
        return !this.isNull();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QualifiedName that = (QualifiedName)o;
        return (this.name != null ? this.name.equals(that.name) : that.name == null) && this.namespaceIndex.equals(that.namespaceIndex);
    }

    public int hashCode() {
        int result = this.namespaceIndex.hashCode();
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    public String toString() {
        return String.format("name = %s, namespaceindex = %s", this.name, this.namespaceIndex);
    }

    public String serialize() {
        String txt = MoreObjects.toStringHelper((Object)this).add("name", (Object)(this.name != null ? this.name : "")).add("namespaceIndex", (Object)this.namespaceIndex).toString();
        return txt;
    }

    public static QualifiedName parse(String s) {
        String name = "";
        String namePart1 = "";
        String namespace = "";
        Integer namespaceIndex = 0;
        if (s != null) {
            try {
                int index = s.indexOf(123) + 1;
                namePart1 = s.substring(index, s.length() - 1);
                String[] parts1 = namePart1.split(",");
                String[] parts2 = parts1[0].split("=");
                name = parts2.length > 1 && parts2[1] != null && !parts2[1].isEmpty() ? parts2[1] : "";
                parts2 = parts1[1].split("=");
                if (parts2.length > 1 && parts2[1] != null && !parts2[1].isEmpty()) {
                    namespace = parts2[1];
                    namespaceIndex = Integer.valueOf(namespace);
                } else {
                    namespaceIndex = 0;
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
                System.out.println(s);
            }
        }
        return new QualifiedName(namespaceIndex, name);
    }
}

