/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.datasource.opcua.nodeclasses;

import de.elpro.ewms.core.datasource.opcua.NodeClass;
import de.elpro.ewms.core.datasource.opcua.SignalDataAccess;
import de.elpro.ewms.core.datasource.opcua.SignalValueDataType;
import de.elpro.ewms.core.datasource.opcua.nodeclasses.BaseNodeAttributes;
import de.elpro.ewms.core.primitivetypes.UByte;
import de.elpro.ewms.core.primitivetypes.UInteger;
import java.time.Instant;

public class VariableNodeAttributes
extends BaseNodeAttributes {
    private Object value;
    private Instant sourceTimeStamp;
    private Instant serverTimeStamp;
    private SignalValueDataType dataType;
    private Integer valueRank;
    private UInteger[] arrayDimensions = null;
    private UByte accessLevel;
    private UByte userAccessLevel;
    private Double minimumSamplingInterval = -1.0;
    private boolean isHistorizing;

    public VariableNodeAttributes() {
        this.setNodeClass(NodeClass.Variable);
        this.value = 0;
        this.sourceTimeStamp = null;
        this.serverTimeStamp = null;
        this.dataType = SignalValueDataType.None;
        this.valueRank = -1;
        this.accessLevel = UByte.valueOf(0);
        this.userAccessLevel = UByte.valueOf(0);
        this.isHistorizing = false;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public SignalValueDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(SignalValueDataType dataType) {
        this.dataType = dataType;
    }

    public Integer getValueRank() {
        return this.valueRank;
    }

    public void setValueRank(Integer valueRank) {
        this.valueRank = valueRank;
    }

    public UInteger[] getArrayDimensions() {
        return this.arrayDimensions;
    }

    public void setArrayDimensions(UInteger[] arrayDimensions) {
        this.arrayDimensions = arrayDimensions;
    }

    public UByte getAccessLevel() {
        return this.accessLevel;
    }

    public UByte getUserAccessLevel() {
        return this.userAccessLevel;
    }

    public void setAccessLevel(UByte accessLevel) {
        this.accessLevel = accessLevel;
    }

    public void setUserAccessLevel(UByte userAccessLevel) {
        this.userAccessLevel = userAccessLevel;
    }

    public SignalDataAccess getDataAccess() {
        Byte dataAccess = (byte)(this.accessLevel.byteValue() & 3);
        SignalDataAccess sda = null;
        switch (dataAccess) {
            case 0: {
                sda = SignalDataAccess.NoDataAccess;
                break;
            }
            case 1: {
                sda = SignalDataAccess.ReadDataAccess;
                break;
            }
            case 2: {
                sda = SignalDataAccess.WriteDataAccess;
                break;
            }
            case 3: {
                sda = SignalDataAccess.ReadWriteDataAccess;
            }
        }
        return sda;
    }

    public SignalDataAccess getHistoryAccess() {
        Byte dataAccess = (byte)((byte)(this.accessLevel.byteValue() & 0xC) >> 2);
        SignalDataAccess sda = null;
        switch (dataAccess) {
            case 0: {
                sda = SignalDataAccess.NoDataAccess;
                break;
            }
            case 1: {
                sda = SignalDataAccess.ReadDataAccess;
                break;
            }
            case 2: {
                sda = SignalDataAccess.WriteDataAccess;
                break;
            }
            case 3: {
                sda = SignalDataAccess.ReadWriteDataAccess;
            }
        }
        return sda;
    }

    public SignalDataAccess getUserDataAccess() {
        Byte dataAccess = (byte)(this.userAccessLevel.byteValue() & 3);
        SignalDataAccess sda = null;
        switch (dataAccess) {
            case 0: {
                sda = SignalDataAccess.NoDataAccess;
                break;
            }
            case 1: {
                sda = SignalDataAccess.ReadDataAccess;
                break;
            }
            case 2: {
                sda = SignalDataAccess.WriteDataAccess;
                break;
            }
            case 3: {
                sda = SignalDataAccess.ReadWriteDataAccess;
            }
        }
        return sda;
    }

    public SignalDataAccess getUserHistoryAccess() {
        Byte dataAccess = (byte)((byte)(this.userAccessLevel.byteValue() & 0xC) >> 2);
        SignalDataAccess sda = null;
        switch (dataAccess) {
            case 0: {
                sda = SignalDataAccess.NoDataAccess;
                break;
            }
            case 1: {
                sda = SignalDataAccess.ReadDataAccess;
                break;
            }
            case 2: {
                sda = SignalDataAccess.WriteDataAccess;
                break;
            }
            case 3: {
                sda = SignalDataAccess.ReadWriteDataAccess;
            }
        }
        return sda;
    }

    public Double getMinimumSamplingInterval() {
        return this.minimumSamplingInterval;
    }

    public void setMinimumSamplingInterval(Double minimumSamplingInterval) {
        this.minimumSamplingInterval = minimumSamplingInterval;
    }

    public boolean isHistorizing() {
        return this.isHistorizing;
    }

    public void setIsHistorizing(boolean historizing) {
        this.isHistorizing = historizing;
    }

    public Instant getSourceTimeStamp() {
        return this.sourceTimeStamp;
    }

    public void setSourceTimeStamp(Instant sourceTimeStamp) {
        this.sourceTimeStamp = sourceTimeStamp;
    }

    public Instant getServerTimeStamp() {
        return this.serverTimeStamp;
    }

    public void setServerTimeStamp(Instant serverTimeStamp) {
        this.serverTimeStamp = serverTimeStamp;
    }

    public void setHistorizing(boolean isHistorizing) {
        this.isHistorizing = isHistorizing;
    }
}

