/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.editors.model;

import com.gluonhq.richtextarea.RichTextArea;
import com.gluonhq.richtextarea.model.NodeDecoration;
import de.elpro.ewms.core.resources.ResourceLoader;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;

public class ResourceImageDecoration
implements NodeDecoration {
    private final int width;
    private final int height;
    private final String resourcePath;
    private final String link;

    public ResourceImageDecoration(String url) {
        this(url, -1, -1, null);
    }

    public ResourceImageDecoration(String url, int width, int height) {
        this(url, width, height, null);
    }

    public ResourceImageDecoration(String url, String link) {
        this(url, -1, -1, link);
    }

    public ResourceImageDecoration(String resourcePath, int width, int height, String link) {
        this.resourcePath = resourcePath;
        this.width = width;
        this.height = height;
        this.link = link;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String getLink() {
        return this.link;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceImageDecoration that = (ResourceImageDecoration)o;
        return this.width == that.width && this.height == that.height && this.resourcePath.equals(that.resourcePath) && (this.link == null && that.link == null || this.link.equals(that.link));
    }

    public int hashCode() {
        return Objects.hash(this.width, this.height, this.resourcePath, this.link);
    }

    public String toString() {
        return "IDec{width=" + this.width + ", height=" + this.height + ", url='" + this.resourcePath + '\'' + ", link='" + this.link + '\'' + '}';
    }

    public Node createNode(RichTextArea richTextArea, double textFlowPrefWidth) {
        String cachedIconPath = ResourceLoader.getCachedIconPath(this.getResourcePath());
        Image image = new Image(cachedIconPath);
        ImageView imageView = new ImageView(image);
        if (this.getWidth() > -1 && this.getHeight() > -1) {
            imageView.setFitWidth((double)this.getWidth());
            imageView.setFitHeight((double)this.getHeight());
        } else {
            double width = Math.min(image.getWidth(), textFlowPrefWidth - 10.0);
            imageView.setFitWidth(width);
            imageView.setPreserveRatio(true);
        }
        if (this.getLink() != null) {
            imageView.setCursor(Cursor.HAND);
            imageView.addEventHandler(MouseEvent.MOUSE_CLICKED, e -> {
                Consumer consumer;
                Function linkCallbackFactory = richTextArea.getLinkCallbackFactory();
                if (linkCallbackFactory != null && (consumer = (Consumer)linkCallbackFactory.apply(imageView)) != null) {
                    consumer.accept(this.getLink());
                }
            });
        }
        return imageView;
    }
}

