/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.events;

import de.elpro.ewms.core.events.EventAction;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.resources.Resources;
import de.elpro.ui.model.IdObject;
import de.elpro.ui.model.UIModelElement;
import de.elpro.ui.text.LocaleText;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="ewms_events_event")
@Access(value=AccessType.PROPERTY)
public class Event
implements UIModelElement,
IdObject {
    public static final String DAO_NAMESPACE = "events/event";
    public static final URL DEFAULT_ICON_URL = Resources.getResourceUrl((String)"/icons/16x16/", (String)"ewms/server_event.png");
    private final ObjectProperty<Integer> id = new SimpleObjectProperty();
    private final StringProperty name = new SimpleStringProperty();
    private final StringProperty fireWhenExpression = new SimpleStringProperty();
    private List<Variable> checkVariables = new ArrayList<Variable>();
    private List<VariableInstance> checkVariableInstances = new ArrayList<VariableInstance>();
    private List<EventAction> eventActions = new ArrayList<EventAction>();

    public Event() {
    }

    public Event(int id) {
        this();
        this.setId(id);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ewms_events_event_sequence")
    @SequenceGenerator(name="ewms_events_event_sequence", sequenceName="ewms_events_event_sequence")
    public Integer getId() {
        return (Integer)this.id.get();
    }

    protected void setId(int id) {
        this.id.set((Object)id);
    }

    public final ObjectProperty<Integer> idProperty() {
        return this.id;
    }

    @Column(name="name", nullable=false, columnDefinition="TEXT")
    public String getName() {
        return (String)this.name.get();
    }

    @Transient
    public String getLocalName() {
        return LocaleText.tryParse((String)this.getName()).getTextOrDefault();
    }

    public void setName(String displayName) {
        this.name.set((Object)displayName);
    }

    public StringProperty nameProperty() {
        return this.name;
    }

    @Column
    public String getFireWhenExpression() {
        return (String)this.fireWhenExpression.get();
    }

    public void setFireWhenExpression(String fireWhenExpression) {
        this.fireWhenExpression.set((Object)fireWhenExpression);
    }

    public StringProperty fireWhenExpressionProperty() {
        return this.fireWhenExpression;
    }

    @ManyToMany
    @JoinTable(name="ewms_events_check_variables", joinColumns={@JoinColumn(name="event")}, inverseJoinColumns={@JoinColumn(name="variable")})
    public List<Variable> getCheckVariables() {
        return this.checkVariables;
    }

    protected void setCheckVariables(List<Variable> checkVariables) {
        this.checkVariables = checkVariables;
    }

    @ManyToMany
    @JoinTable(name="ewms_events_check_variable_instances", joinColumns={@JoinColumn(name="event")}, inverseJoinColumns={@JoinColumn(name="variable_instance")})
    public List<VariableInstance> getCheckVariableInstances() {
        return this.checkVariableInstances;
    }

    protected void setCheckVariableInstances(List<VariableInstance> checkVariableInstances) {
        this.checkVariableInstances = checkVariableInstances;
    }

    @OneToMany(mappedBy="event", cascade={CascadeType.REMOVE})
    public List<EventAction> getEventActions() {
        return this.eventActions;
    }

    protected void setEventActions(List<EventAction> eventActions) {
        this.eventActions = eventActions;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Event) {
            if (this.getId() == null) {
                return super.equals(obj);
            }
            if (this.getId().equals(((Event)obj).getId())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.getId() == null) {
            return super.hashCode();
        }
        return Event.class.hashCode() + 17 * this.getId();
    }

    @Transient
    public String getIconUri() {
        return DEFAULT_ICON_URL.toString();
    }

    public String toString() {
        return this.getLocalName();
    }
}

