/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.graph;

import de.elpro.ewms.core.graph.ObjectGroup;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.resources.Resources;
import de.elpro.ui.model.IdObject;
import de.elpro.ui.model.UIModelElement;
import de.elpro.ui.text.LocaleText;
import java.net.URL;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="ewms_graphs_graph")
@Access(value=AccessType.PROPERTY)
public class GraphChart
implements UIModelElement,
IdObject {
    public static final String DAO_NAMESPACE = "graphs/graph";
    public static final URL DEFAULT_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"charts/graph.png");
    private final ObjectProperty<Integer> id = new SimpleObjectProperty();
    private final ObjectProperty<StructureClass> structureClass = new SimpleObjectProperty();
    private final StringProperty name = new SimpleStringProperty();
    private final StringProperty definition = new SimpleStringProperty();

    public GraphChart() {
    }

    public GraphChart(int id) {
        this.setId(id);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ewms_graphs_graph_sequence")
    @SequenceGenerator(name="ewms_graphs_graph_sequence", sequenceName="ewms_graphs_graph_sequence")
    public Integer getId() {
        return (Integer)this.id.get();
    }

    void setId(int id) {
        this.id.set((Object)id);
    }

    public final ObjectProperty<Integer> idProperty() {
        return this.id;
    }

    @ManyToOne
    @JoinColumn(name="structure_class")
    public StructureClass getStructureClass() {
        return (StructureClass)this.structureClass.get();
    }

    public void setStructureClass(StructureClass structureClass) {
        this.structureClass.set((Object)structureClass);
    }

    public final ObjectProperty<StructureClass> structureClassProperty() {
        return this.structureClass;
    }

    @Column(name="name", nullable=false, columnDefinition="TEXT")
    public String getName() {
        return (String)this.name.get();
    }

    @Transient
    public String getLocalName() {
        return LocaleText.tryParse((String)this.getName()).getTextOrDefault();
    }

    public void setName(String name) {
        this.name.set((Object)name);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    @Column(name="definition", nullable=false, columnDefinition="TEXT")
    public String getDefinition() {
        return (String)this.definition.get();
    }

    public void setDefinition(String definition) {
        this.definition.set((Object)definition);
    }

    public final StringProperty definitionProperty() {
        return this.definition;
    }

    @Transient
    public ObjectGroup getRootObjectGroup() {
        String json = this.getDefinition();
        if (json == null || json.isBlank()) {
            return null;
        }
        try {
            ObjectGroup objectGroup = ObjectGroup.parse(json);
            return objectGroup;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String toString() {
        return this.getLocalName();
    }

    public int hashCode() {
        if (this.getId() == null) {
            return super.hashCode();
        }
        return GraphChart.class.hashCode() + 17 * (Integer)this.id.get();
    }

    public boolean equals(Object obj) {
        if (obj instanceof GraphChart) {
            if (this.getId() == null) {
                return super.equals(obj);
            }
            if (this.getId().equals(((GraphChart)obj).getId())) {
                return true;
            }
        }
        return false;
    }

    @Transient
    public String getIconUri() {
        return DEFAULT_ICON.toString();
    }
}

