/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.json;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import de.elpro.ewms.core.json.typeadapters.IdListTypeAdapter;
import de.elpro.ewms.core.json.typeadapters.IdObjTypeAdapter;
import de.elpro.ewms.core.json.typeadapters.IdSetTypeAdapter;
import de.elpro.ewms.core.json.typeadapters.IdSortedSetTypeAdapter;
import de.elpro.ewms.core.json.typeadapters.MeasuringUnitTypeAdapter;
import de.elpro.ewms.core.json.typeadapters.PhysicalUnitTypeAdapter;
import de.elpro.ewms.core.json.typeadapters.ZoneIdTypeAdapter;
import de.elpro.ewms.core.json.typeadapters.ZoneOffsetTypeAdapter;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.units.PhysicalUnit;
import de.elpro.ui.model.IdObject;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import javafx.beans.property.ObjectProperty;
import org.hildan.fxgson.adapters.properties.ObjectPropertyTypeAdapter;

public class DefaultTypeAdapterFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        Class param;
        Type[] typeParams;
        Class cls = type.getRawType();
        if (MeasuringUnit.class.isAssignableFrom(cls)) {
            return new MeasuringUnitTypeAdapter();
        }
        if (PhysicalUnit.class.isAssignableFrom(cls)) {
            return new PhysicalUnitTypeAdapter();
        }
        if (ZoneOffset.class.isAssignableFrom(cls)) {
            return new ZoneOffsetTypeAdapter();
        }
        if (ZoneId.class.isAssignableFrom(cls)) {
            return new ZoneIdTypeAdapter();
        }
        if (List.class.isAssignableFrom(cls) && (typeParams = ((ParameterizedType)type.getType()).getActualTypeArguments())[0] instanceof Class && IdObject.class.isAssignableFrom(param = (Class)typeParams[0])) {
            IdListTypeAdapter ta = new IdListTypeAdapter(param);
            return ta;
        }
        if (SortedSet.class.isAssignableFrom(cls) && (typeParams = ((ParameterizedType)type.getType()).getActualTypeArguments())[0] instanceof Class && IdObject.class.isAssignableFrom(param = (Class)typeParams[0])) {
            IdSortedSetTypeAdapter ta = new IdSortedSetTypeAdapter(param);
            return ta;
        }
        if (Set.class.isAssignableFrom(cls) && (typeParams = ((ParameterizedType)type.getType()).getActualTypeArguments())[0] instanceof Class && IdObject.class.isAssignableFrom(param = (Class)typeParams[0])) {
            IdSetTypeAdapter ta = new IdSetTypeAdapter(param);
            return ta;
        }
        if (ObjectProperty.class.isAssignableFrom(cls) && (typeParams = ((ParameterizedType)type.getType()).getActualTypeArguments())[0] instanceof Class && IdObject.class.isAssignableFrom(param = (Class)typeParams[0])) {
            IdObjTypeAdapter ta = new IdObjTypeAdapter(param);
            return new ObjectPropertyTypeAdapter(ta, false);
        }
        return null;
    }
}

