/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.json.typeadapters;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import de.elpro.ewms.core.json.typeadapters.NotNullValueTypeAdapter;
import java.io.IOException;
import java.nio.ByteBuffer;

public class DoubleArrayTypeAdapter
extends NotNullValueTypeAdapter<double[]> {
    @Override
    public void writeNotEmpty(JsonWriter out, double[] value) throws IOException {
        byte[] byteArray = new byte[value.length * 8];
        ByteBuffer buffer = ByteBuffer.wrap(byteArray);
        double[] dArray = value;
        int n = value.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            buffer.putDouble(d);
            ++n2;
        }
        DoubleArrayTypeAdapter.writeValue(out, buffer.array());
    }

    @Override
    public double[] readNotEmpty(JsonReader in) throws IOException {
        byte[] byteArray = DoubleArrayTypeAdapter.readBytes(in);
        ByteBuffer buffer = ByteBuffer.wrap(byteArray);
        double[] resultArray = new double[byteArray.length / 8];
        int i = 0;
        while (i < resultArray.length) {
            resultArray[i] = buffer.getDouble();
            ++i;
        }
        return resultArray;
    }
}

