/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.json.typeadapters;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import de.elpro.ui.model.IdObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class IdListTypeAdapter<T extends IdObject>
extends TypeAdapter<List<T>> {
    private final Class<?> clazz;

    public IdListTypeAdapter(Class<?> clazz) {
        this.clazz = clazz;
    }

    public void write(JsonWriter out, List<T> values) throws IOException {
        out.beginArray();
        for (IdObject t : values) {
            out.value((Number)t.getId());
        }
        out.endArray();
    }

    public List<T> read(JsonReader in) throws IOException {
        ArrayList<IdObject> values = new ArrayList<IdObject>();
        in.beginArray();
        try {
            while (in.hasNext()) {
                IdObject o = (IdObject)this.clazz.getConstructor(Integer.TYPE).newInstance(in.nextInt());
                values.add(o);
            }
        }
        catch (Exception ne) {
            throw new IOException(ne);
        }
        in.endArray();
        return values;
    }
}

