/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.json.typeadapters;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import de.elpro.ui.model.IdObject;
import java.io.IOException;
import java.util.SortedSet;
import java.util.TreeSet;

public class IdSortedSetTypeAdapter<T extends IdObject>
extends TypeAdapter<SortedSet<T>> {
    private final Class<?> clazz;

    public IdSortedSetTypeAdapter(Class<?> clazz) {
        this.clazz = clazz;
    }

    public void write(JsonWriter out, SortedSet<T> values) throws IOException {
        out.beginArray();
        for (IdObject t : values) {
            out.value((Number)t.getId());
        }
        out.endArray();
    }

    public SortedSet<T> read(JsonReader in) throws IOException {
        TreeSet<IdObject> values = new TreeSet<IdObject>();
        in.beginArray();
        try {
            while (in.hasNext()) {
                IdObject o = (IdObject)this.clazz.getConstructor(Integer.TYPE).newInstance(in.nextInt());
                values.add(o);
            }
        }
        catch (Exception ne) {
            throw new IOException(ne);
        }
        in.endArray();
        return values;
    }
}

