/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.json.typeadapters;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Base64;
import javafx.scene.paint.Color;

public abstract class NotNullValueTypeAdapter<T>
extends TypeAdapter<T> {
    public static final String NaN = "NaN";
    public static final String PositiveInfinity = "+Inf";
    public static final String NegativeInfinity = "-Inf";

    public final void write(JsonWriter out, T value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        this.writeNotEmpty(out, value);
    }

    protected abstract void writeNotEmpty(JsonWriter var1, T var2) throws IOException;

    public final T read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        return this.readNotEmpty(in);
    }

    protected abstract T readNotEmpty(JsonReader var1) throws IOException;

    public static void readName(String expectedName, JsonReader reader) throws IOException {
        String name = reader.nextName();
        if (expectedName != null && !expectedName.equals(name)) {
            throw new IOException(String.format("%s does not match expected token %s", name, expectedName));
        }
    }

    public static Integer readInteger(String expectedName, JsonReader reader) throws IOException {
        NotNullValueTypeAdapter.readName(expectedName, reader);
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        return reader.nextInt();
    }

    public static int readInt(String expectedName, JsonReader reader) throws IOException {
        NotNullValueTypeAdapter.readName(expectedName, reader);
        return reader.nextInt();
    }

    public static long readLong(String expectedName, JsonReader reader) throws IOException {
        NotNullValueTypeAdapter.readName(expectedName, reader);
        return reader.nextLong();
    }

    public static Long readLongObj(String expectedName, JsonReader reader) throws IOException {
        NotNullValueTypeAdapter.readName(expectedName, reader);
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        return reader.nextLong();
    }

    public static Double readDoubleObj(JsonReader reader) throws IOException {
        JsonToken jt = reader.peek();
        switch (jt) {
            case STRING: {
                String fs;
                switch (fs = reader.nextString()) {
                    case "NaN": {
                        return Double.NaN;
                    }
                    case "+Inf": {
                        return Double.POSITIVE_INFINITY;
                    }
                    case "-Inf": {
                        return Double.NEGATIVE_INFINITY;
                    }
                }
                reader.nextNull();
                return null;
            }
            case NUMBER: {
                return reader.nextDouble();
            }
        }
        reader.nextNull();
        return null;
    }

    public static double readDouble(String expectedName, JsonReader reader) throws IOException {
        Double d = NotNullValueTypeAdapter.readDoubleObj(expectedName, reader);
        if (d == null) {
            return Double.NaN;
        }
        return d;
    }

    public static Double readDoubleObj(String expectedName, JsonReader reader) throws IOException {
        NotNullValueTypeAdapter.readName(expectedName, reader);
        return NotNullValueTypeAdapter.readDoubleObj(reader);
    }

    public static float readFloat(String expectedName, JsonReader reader) throws IOException {
        Float f = NotNullValueTypeAdapter.readFloatObj(expectedName, reader);
        if (f == null) {
            return Float.NaN;
        }
        return f.floatValue();
    }

    public static Float readFloatObj(String expectedName, JsonReader reader) throws IOException {
        NotNullValueTypeAdapter.readName(expectedName, reader);
        JsonToken jt = reader.peek();
        switch (jt) {
            case STRING: {
                String fs;
                switch (fs = reader.nextString()) {
                    case "NaN": {
                        return Float.valueOf(Float.NaN);
                    }
                    case "+Inf": {
                        return Float.valueOf(Float.POSITIVE_INFINITY);
                    }
                    case "-Inf": {
                        return Float.valueOf(Float.NEGATIVE_INFINITY);
                    }
                }
                reader.nextNull();
                return null;
            }
            case NUMBER: {
                return Float.valueOf(((Number)reader.nextDouble()).floatValue());
            }
        }
        reader.nextNull();
        return null;
    }

    public static String readString(String expectedName, JsonReader reader) throws IOException {
        NotNullValueTypeAdapter.readName(expectedName, reader);
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        return reader.nextString();
    }

    public static <T extends Enum<T>> T readEnum(JsonReader reader, Class<T> clazz) throws IOException {
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        return Enum.valueOf(clazz, reader.nextString());
    }

    public static <T extends Enum<T>> T readEnum(String expectedName, JsonReader reader, Class<T> clazz) throws IOException {
        NotNullValueTypeAdapter.readName(expectedName, reader);
        return NotNullValueTypeAdapter.readEnum(reader, clazz);
    }

    public static boolean readBool(String expectedName, JsonReader reader) throws IOException {
        NotNullValueTypeAdapter.readName(expectedName, reader);
        return reader.nextBoolean();
    }

    public static Boolean readBoolean(String expectedName, JsonReader reader) throws IOException {
        NotNullValueTypeAdapter.readName(expectedName, reader);
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        return reader.nextBoolean();
    }

    public static Byte readByte(JsonReader reader) throws IOException {
        reader.nextName();
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        return Integer.valueOf(reader.nextInt()).byteValue();
    }

    public static byte[] readBytes(JsonReader reader) throws IOException {
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        return Base64.getDecoder().decode(reader.nextString());
    }

    public static byte[] readBytes(String expectedName, JsonReader reader) throws IOException {
        NotNullValueTypeAdapter.readName(expectedName, reader);
        return NotNullValueTypeAdapter.readBytes(reader);
    }

    public static void writeValue(JsonWriter writer, String name, Integer value) throws IOException {
        writer.name(name);
        if (value != null) {
            writer.value((Number)value);
        } else {
            writer.nullValue();
        }
    }

    public static void writeValue(JsonWriter writer, String name, Long value) throws IOException {
        writer.name(name);
        if (value != null) {
            writer.value((Number)value);
        } else {
            writer.nullValue();
        }
    }

    public static void writeValue(JsonWriter writer, Double value) throws IOException {
        if (value != null) {
            if (value.isNaN()) {
                writer.value(NaN);
            } else if (value == Double.POSITIVE_INFINITY) {
                writer.value(PositiveInfinity);
            } else if (value == Double.NEGATIVE_INFINITY) {
                writer.value(NegativeInfinity);
            } else {
                writer.value((Number)value);
            }
        } else {
            writer.nullValue();
        }
    }

    public static void writeValue(JsonWriter writer, String name, Double value) throws IOException {
        writer.name(name);
        NotNullValueTypeAdapter.writeValue(writer, value);
    }

    public static void writeValue(JsonWriter writer, String name, Float value) throws IOException {
        writer.name(name);
        if (value != null) {
            if (value.isNaN()) {
                writer.value(NaN);
            } else if (value.floatValue() == Float.POSITIVE_INFINITY) {
                writer.value(PositiveInfinity);
            } else if (value.floatValue() == Float.NEGATIVE_INFINITY) {
                writer.value(NegativeInfinity);
            } else {
                writer.value((Number)value);
            }
        } else {
            writer.nullValue();
        }
    }

    public static <T extends Enum<T>> void writeValue(JsonWriter writer, String name, Enum<T> value) throws IOException {
        writer.name(name);
        if (value != null) {
            writer.value(value.name());
        } else {
            writer.nullValue();
        }
    }

    public static void writeValue(JsonWriter writer, String name, String value) throws IOException {
        writer.name(name);
        if (value != null) {
            writer.value(value);
        } else {
            writer.nullValue();
        }
    }

    public static void writeValue(JsonWriter writer, String name, Boolean value) throws IOException {
        writer.name(name);
        if (value != null) {
            writer.value(value);
        } else {
            writer.nullValue();
        }
    }

    public static void writeValue(JsonWriter writer, String name, Color color) throws IOException {
        NotNullValueTypeAdapter.writeValue(writer, name, color != null ? color.toString() : null);
    }

    public static void writeValue(JsonWriter writer, String name, Byte value) throws IOException {
        writer.name(name);
        if (value != null) {
            writer.value((long)((Number)value).intValue());
        } else {
            writer.nullValue();
        }
    }

    public static void writeValue(JsonWriter writer, byte[] value) throws IOException {
        if (value != null) {
            writer.value(Base64.getEncoder().encodeToString(value));
        } else {
            writer.nullValue();
        }
    }

    public static void writeValue(JsonWriter writer, String name, byte[] value) throws IOException {
        writer.name(name);
        NotNullValueTypeAdapter.writeValue(writer, value);
    }

    public static void writeNullValue(JsonWriter writer, String name) throws IOException {
        writer.name(name);
        writer.nullValue();
    }

    public static byte[] toByteArray(int[] value) {
        if (value == null) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.allocate(value.length * 4);
        int[] nArray = value;
        int n = value.length;
        int n2 = 0;
        while (n2 < n) {
            int v = nArray[n2];
            buffer.putInt(v);
            ++n2;
        }
        return buffer.array();
    }

    public static byte[] toByteArray(long[] value) {
        if (value == null) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.allocate(value.length * 8);
        long[] lArray = value;
        int n = value.length;
        int n2 = 0;
        while (n2 < n) {
            long v = lArray[n2];
            buffer.putLong(v);
            ++n2;
        }
        return buffer.array();
    }

    public static int[] toIntArray(byte[] value) {
        if (value == null) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.wrap(value);
        int[] resultArray = new int[value.length / 4];
        int i = 0;
        while (i < resultArray.length) {
            resultArray[i] = buffer.getInt();
            ++i;
        }
        return resultArray;
    }

    public static long[] toLongArray(byte[] value) {
        if (value == null) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.wrap(value);
        long[] resultArray = new long[value.length / 8];
        int i = 0;
        while (i < resultArray.length) {
            resultArray[i] = buffer.getLong();
            ++i;
        }
        return resultArray;
    }
}

