/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.json.typeadapters;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import de.elpro.ewms.core.json.typeadapters.NotNullValueTypeAdapter;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.value.MeasuredValue;
import de.elpro.ewms.core.variable.value.VarInstanceMeasuredValuesMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

public class VarInstanceMeasuredValuesMapTypeAdapter
extends NotNullValueTypeAdapter<VarInstanceMeasuredValuesMap> {
    @Override
    protected VarInstanceMeasuredValuesMap readNotEmpty(JsonReader reader) throws IOException {
        VarInstanceMeasuredValuesMap request = new VarInstanceMeasuredValuesMap();
        reader.beginArray();
        while (reader.hasNext()) {
            reader.beginObject();
            VariableInstance instance = new VariableInstance(VarInstanceMeasuredValuesMapTypeAdapter.readInt("instance_id", reader));
            VarInstanceMeasuredValuesMapTypeAdapter.readName("values", reader);
            ArrayList<MeasuredValue> values = new ArrayList<MeasuredValue>();
            reader.beginArray();
            while (reader.hasNext()) {
                reader.beginObject();
                long startTimestamp = VarInstanceMeasuredValuesMapTypeAdapter.readLong("start_timestamp", reader);
                long endTimestamp = VarInstanceMeasuredValuesMapTypeAdapter.readLong("end_timestamp", reader);
                double value = VarInstanceMeasuredValuesMapTypeAdapter.readDouble("value", reader);
                double quality = VarInstanceMeasuredValuesMapTypeAdapter.readDouble("quality", reader);
                reader.endObject();
                MeasuredValue mv = new MeasuredValue(startTimestamp, endTimestamp, value, quality);
                values.add(mv);
            }
            reader.endArray();
            reader.endObject();
            request.put(instance, (MeasuredValue[])values.stream().toArray(MeasuredValue[]::new));
        }
        reader.endArray();
        return request;
    }

    @Override
    protected void writeNotEmpty(JsonWriter writer, VarInstanceMeasuredValuesMap t) throws IOException {
        writer.beginArray();
        for (Map.Entry<VariableInstance, MeasuredValue[]> entry : t.getBackingMap().entrySet()) {
            writer.beginObject();
            VarInstanceMeasuredValuesMapTypeAdapter.writeValue(writer, "instance_id", entry.getKey().getId());
            writer.name("values");
            writer.beginArray();
            MeasuredValue[] measuredValueArray = entry.getValue();
            int n = measuredValueArray.length;
            int n2 = 0;
            while (n2 < n) {
                MeasuredValue mv = measuredValueArray[n2];
                writer.beginObject();
                VarInstanceMeasuredValuesMapTypeAdapter.writeValue(writer, "start_timestamp", mv.getStartTimestamp());
                VarInstanceMeasuredValuesMapTypeAdapter.writeValue(writer, "end_timestamp", mv.getEndTimestamp());
                VarInstanceMeasuredValuesMapTypeAdapter.writeValue(writer, "value", mv.getValue());
                VarInstanceMeasuredValuesMapTypeAdapter.writeValue(writer, "quality", mv.getQuality());
                writer.endObject();
                ++n2;
            }
            writer.endArray();
            writer.endObject();
        }
        writer.endArray();
    }
}

