/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.locale;

import de.elpro.resources.Resources;
import de.elpro.ui.model.IdObject;
import de.elpro.ui.model.UIModelElement;
import de.elpro.ui.text.LocaleDescriptor;
import java.util.Locale;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="ewms_locale_localedefinition", uniqueConstraints={@UniqueConstraint(columnNames={"locale_key"})})
@Access(value=AccessType.PROPERTY)
public class LocaleDefinition
implements UIModelElement,
IdObject {
    public static final String DAO_NAMESPACE = "locale/localedefinition";
    private final ObjectProperty<Integer> id = new SimpleObjectProperty();
    private final StringProperty localeKey = new SimpleStringProperty();
    private final StringProperty logoKey = new SimpleStringProperty();
    private final StringProperty name = new SimpleStringProperty();
    private final BooleanProperty engineeringLocale = new SimpleBooleanProperty(false);
    private final BooleanProperty fallbackLocale = new SimpleBooleanProperty(false);

    public LocaleDefinition() {
    }

    public LocaleDefinition(int id) {
        this.setId(id);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ewms_locale_localedefinition_sequence")
    @SequenceGenerator(name="ewms_locale_localedefinition_sequence", sequenceName="ewms_locale_localedefinition_sequence")
    public Integer getId() {
        return (Integer)this.id.get();
    }

    void setId(int id) {
        this.id.set((Object)id);
    }

    public final ObjectProperty<Integer> idProperty() {
        return this.id;
    }

    @Column(name="locale_key", nullable=false)
    public String getLocaleKey() {
        return (String)this.localeKey.get();
    }

    public void setLocaleKey(String localeKey) {
        this.localeKey.set((Object)localeKey);
    }

    public final StringProperty localeKeyProperty() {
        return this.localeKey;
    }

    public static Locale tryGetLocale(String localeKey) {
        try {
            String[] parts = localeKey.split("_");
            if (parts.length == 1) {
                return new Locale(parts[0]);
            }
            if (parts.length == 2) {
                return new Locale(parts[0], parts[1]);
            }
            if (parts.length == 3) {
                return new Locale(parts[0], parts[1], parts[2]);
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Column(name="logo_key", nullable=false)
    public String getLogoKey() {
        return (String)this.logoKey.get();
    }

    public void setLogoKey(String logoKey) {
        this.logoKey.set((Object)logoKey);
    }

    public final StringProperty logoKeyProperty() {
        return this.logoKey;
    }

    @Column(name="name", nullable=false)
    public String getName() {
        return (String)this.name.get();
    }

    public void setName(String name) {
        this.name.set((Object)name);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    @Column(name="engineering_locale", nullable=false, columnDefinition="boolean default false")
    public boolean isEngineeringLocale() {
        return this.engineeringLocale.get();
    }

    public void setEngineeringLocale(boolean engineeringLocale) {
        this.engineeringLocale.set(engineeringLocale);
    }

    public final BooleanProperty engineeringLocaleProperty() {
        return this.engineeringLocale;
    }

    @Column(name="fallback_locale", nullable=false, columnDefinition="boolean default false")
    public boolean isFallbackLocale() {
        return this.fallbackLocale.get();
    }

    public void setFallbackLocale(boolean fallbackLocale) {
        this.fallbackLocale.set(fallbackLocale);
    }

    public final BooleanProperty fallbackLocaleProperty() {
        return this.fallbackLocale;
    }

    public String toString() {
        return this.getName();
    }

    public LocaleDescriptor toDescriptor() {
        Locale locale = LocaleDefinition.tryGetLocale(this.getLocaleKey());
        if (locale == null) {
            return null;
        }
        String flagURL = Resources.getResourceUrl((String)"/icons/16x16/flags/", (String)this.getLogoKey()).toString();
        if (flagURL == null) {
            return null;
        }
        LocaleDescriptor ld = new LocaleDescriptor(locale, flagURL, this.getName());
        return ld;
    }

    @Transient
    public String getIconUri() {
        return Resources.getResourceUrl((String)"/icons/16x16/flags/", (String)this.getLogoKey()).toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LocaleDefinition) {
            if (this.getId() == null) {
                return super.equals(obj);
            }
            if (this.getId().equals(((LocaleDefinition)obj).getId())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.getId() == null) {
            return super.hashCode();
        }
        return LocaleDefinition.class.hashCode() + 17 * (Integer)this.id.get();
    }
}

