/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.rawvalues;

import de.elpro.ewms.core.rawvalues.RawValuesViewType;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ui.formats.TimeFormatType;
import de.elpro.ui.model.IdObject;
import de.elpro.ui.model.UIModelElement;
import de.elpro.ui.text.LocaleText;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAccessor;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class RawValuesViewDescriptor
implements UIModelElement,
IdObject {
    public static final String DAO_NAMESPACE = "rawvalues/view";
    private ObjectProperty<Integer> id = new SimpleObjectProperty();
    private ObjectProperty<RawValuesViewType> type = new SimpleObjectProperty();
    private StringProperty name = new SimpleStringProperty();
    private ObjectProperty<Raster> raster = new SimpleObjectProperty();
    private LongProperty ramSize = new SimpleLongProperty();
    private LongProperty hddSize = new SimpleLongProperty();
    private ObjectProperty<Instant> timeRangeBegin = new SimpleObjectProperty();
    private ObjectProperty<Instant> timeRangeEnd = new SimpleObjectProperty();

    public final ObjectProperty<Integer> idProperty() {
        return this.id;
    }

    public final Integer getId() {
        return (Integer)this.idProperty().get();
    }

    public final void setId(Integer index) {
        this.idProperty().set((Object)index);
    }

    public final ObjectProperty<RawValuesViewType> typeProperty() {
        return this.type;
    }

    public final RawValuesViewType getType() {
        return (RawValuesViewType)((Object)this.typeProperty().get());
    }

    public final void setType(RawValuesViewType type) {
        this.typeProperty().set((Object)type);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    public final String getName() {
        return (String)this.nameProperty().get();
    }

    public final String getLocalName() {
        return LocaleText.tryParse((String)this.getName()).getTextOrDefault();
    }

    public final void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public final ObjectProperty<Raster> rasterProperty() {
        return this.raster;
    }

    public final Raster getRaster() {
        return (Raster)((Object)this.rasterProperty().get());
    }

    public final void setRaster(Raster raster) {
        this.rasterProperty().set((Object)raster);
    }

    public final ObjectProperty<Instant> timeRangeBeginProperty() {
        return this.timeRangeBegin;
    }

    public final Instant getTimeRangeBegin() {
        return (Instant)this.timeRangeBeginProperty().get();
    }

    public final void setTimeRangeBegin(Instant timeRangeBegin) {
        this.timeRangeBeginProperty().set((Object)timeRangeBegin);
    }

    public final ObjectProperty<Instant> timeRangeEndProperty() {
        return this.timeRangeEnd;
    }

    public final Instant getTimeRangeEnd() {
        return (Instant)this.timeRangeEndProperty().get();
    }

    public final void setTimeRangeEnd(Instant timeRangeEnd) {
        this.timeRangeEndProperty().set((Object)timeRangeEnd);
    }

    public LongProperty ramSizeProperty() {
        return this.ramSize;
    }

    public long getRamSize() {
        return this.ramSizeProperty().get();
    }

    public void setRamSize(long ramSize) {
        this.ramSizeProperty().set(ramSize);
    }

    public LongProperty hddSizeProperty() {
        return this.hddSize;
    }

    public long getHddSize() {
        return this.hddSizeProperty().get();
    }

    public void setHddSize(long hddSize) {
        this.hddSizeProperty().set(hddSize);
    }

    public String toString() {
        LocalDateTime from = LocalDateTime.ofInstant(this.getTimeRangeBegin(), ZoneOffset.systemDefault());
        LocalDateTime to = LocalDateTime.ofInstant(this.getTimeRangeEnd(), ZoneOffset.systemDefault());
        LocalDate fromDate = from.toLocalDate();
        LocalDate toDate = to.toLocalDate();
        String text = "";
        String localName = this.getLocalName();
        if (localName != null && !localName.isEmpty()) {
            text = String.valueOf(text) + localName + " - ";
        }
        text = fromDate.equals(toDate) ? String.valueOf(text) + String.format("%s (%s <-> %s) [%s]", TimeFormatType.Date.format((TemporalAccessor)fromDate), TimeFormatType.TimeHM.format((TemporalAccessor)from), TimeFormatType.TimeHM.format((TemporalAccessor)to), this.getRaster().toString()) : String.valueOf(text) + String.format("%s <-> %s [%s]", TimeFormatType.Date.format((TemporalAccessor)fromDate), TimeFormatType.Date.format((TemporalAccessor)toDate), this.getRaster().toString());
        return text;
    }
}

