/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.report;

import de.elpro.ewms.core.report.ReportItemGroupType;
import de.elpro.ewms.core.report.ReportTemplate;
import de.elpro.ewms.core.report.TableReport;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.resources.Resources;
import de.elpro.ui.model.IdObject;
import de.elpro.ui.model.UIModelElement;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="ewms_report_profile", uniqueConstraints={@UniqueConstraint(columnNames={"name"})})
@Access(value=AccessType.PROPERTY)
public class ReportProfile
implements UIModelElement,
IdObject {
    public static final String DAO_NAMESPACE = "report/profile";
    public static final URL DEFAULT_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"eclipse/template_obj.gif");
    private final ObjectProperty<Integer> id = new SimpleObjectProperty();
    private final StringProperty name = new SimpleStringProperty();
    private final ObjectProperty<ReportTemplate> template = new SimpleObjectProperty();
    private final ObjectProperty<StructureClass> structureClass = new SimpleObjectProperty();
    private final ObjectProperty<StructureObject> structureObject = new SimpleObjectProperty();
    private final ObjectProperty<ReportItemGroupType> groupBy = new SimpleObjectProperty((Object)ReportItemGroupType.Object);
    private final StringProperty description = new SimpleStringProperty();
    private List<TableReport> tableReports = new ArrayList<TableReport>();

    public ReportProfile() {
    }

    public ReportProfile(int id) {
        this.setId(id);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ewms_report_profile_sequence")
    @SequenceGenerator(name="ewms_report_profile_sequence", sequenceName="ewms_report_profile_sequence")
    public Integer getId() {
        return (Integer)this.id.get();
    }

    void setId(int id) {
        this.id.set((Object)id);
    }

    public final ObjectProperty<Integer> idProperty() {
        return this.id;
    }

    @Column(name="name", nullable=false)
    public String getName() {
        return (String)this.name.get();
    }

    public void setName(String name) {
        this.name.set((Object)name);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    @ManyToOne
    @JoinColumn(name="template", nullable=false)
    public ReportTemplate getTemplate() {
        return (ReportTemplate)this.template.get();
    }

    public void setTemplate(ReportTemplate template) {
        this.template.set((Object)template);
    }

    public final ObjectProperty<ReportTemplate> templateProperty() {
        return this.template;
    }

    @ManyToOne
    @JoinColumn(name="structure_class", nullable=false)
    public StructureClass getStructureClass() {
        return (StructureClass)this.structureClass.get();
    }

    public void setStructureClass(StructureClass structureClass) {
        this.structureClass.set((Object)structureClass);
    }

    public final ObjectProperty<StructureClass> structureClassProperty() {
        return this.structureClass;
    }

    @ManyToOne
    @JoinColumn(name="structure_object", nullable=true)
    public StructureObject getStructureObject() {
        return (StructureObject)this.structureObject.get();
    }

    public void setStructureObject(StructureObject structureObject) {
        this.structureObject.set((Object)structureObject);
    }

    public final ObjectProperty<StructureObject> structureObjectProperty() {
        return this.structureObject;
    }

    @Column(name="group_by", nullable=false)
    public ReportItemGroupType getGroupBy() {
        return (ReportItemGroupType)((Object)this.groupBy.get());
    }

    public void setGroupBy(ReportItemGroupType groupBy) {
        this.groupBy.set((Object)groupBy);
    }

    public final ObjectProperty<ReportItemGroupType> groupByProperty() {
        return this.groupBy;
    }

    @Column(name="description")
    public String getDescription() {
        return (String)this.description.get();
    }

    public void setDescription(String description) {
        this.description.set((Object)description);
    }

    public final StringProperty descriptionProperty() {
        return this.description;
    }

    @OneToMany(mappedBy="profile", cascade={CascadeType.REMOVE})
    public List<TableReport> getTableReports() {
        return this.tableReports;
    }

    void setTableReports(List<TableReport> tableReports) {
        this.tableReports = tableReports;
    }

    @Transient
    public String getIconUri() {
        return DEFAULT_ICON.toString();
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        if (this.getId() == null) {
            return super.hashCode();
        }
        return ReportProfile.class.hashCode() + 17 * (Integer)this.id.get();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ReportProfile) {
            if (this.getId() == null) {
                return super.equals(obj);
            }
            if (this.getId().equals(((ReportProfile)obj).getId())) {
                return true;
            }
        }
        return false;
    }
}

