/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.structure;

import de.elpro.ewms.core.structure.PropertyGroup;
import de.elpro.ewms.core.structure.PropertyValue;
import de.elpro.resources.Resources;
import de.elpro.ui.model.IdObject;
import de.elpro.ui.model.UIModelElement;
import de.elpro.ui.text.LocaleText;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="ewms_structure_property", uniqueConstraints={@UniqueConstraint(columnNames={"property_group", "key"})})
@Access(value=AccessType.PROPERTY)
public class Property
implements UIModelElement,
IdObject {
    public static final String DAO_NAMESPACE = "structure/property";
    public static final URL DEFAULT_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"eclipse/brkp_obj.gif");
    private final ObjectProperty<Integer> id = new SimpleObjectProperty();
    private final ObjectProperty<PropertyGroup> group = new SimpleObjectProperty();
    private final StringProperty key = new SimpleStringProperty();
    private final StringProperty name = new SimpleStringProperty();
    private final StringProperty typeId = new SimpleStringProperty();
    private final StringProperty parameter = new SimpleStringProperty();
    private final BooleanProperty userVisible = new SimpleBooleanProperty(true);
    private final BooleanProperty userEditable = new SimpleBooleanProperty(false);
    private final ObjectProperty<Integer> visualOrderPosition = new SimpleObjectProperty();
    private List<PropertyValue> values = new LinkedList<PropertyValue>();

    public Property() {
    }

    public Property(int id) {
        this.setId(id);
    }

    public Property(PropertyGroup group, String key, String displayName) {
        this.setGroup(group);
        this.setKey(key);
        this.setName(displayName);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ewms_structure_property_sequence")
    @SequenceGenerator(name="ewms_structure_property_sequence", sequenceName="ewms_structure_property_sequence")
    public Integer getId() {
        return (Integer)this.id.get();
    }

    protected void setId(int id) {
        this.id.set((Object)id);
    }

    public final ObjectProperty<Integer> idProperty() {
        return this.id;
    }

    @ManyToOne
    @JoinColumn(name="property_group")
    public PropertyGroup getGroup() {
        return (PropertyGroup)this.group.get();
    }

    public void setGroup(PropertyGroup group) {
        this.group.set((Object)group);
    }

    public final ObjectProperty<PropertyGroup> groupProperty() {
        return this.group;
    }

    @Column(name="key", nullable=false)
    public String getKey() {
        return (String)this.key.get();
    }

    public void setKey(String key) {
        this.key.set((Object)key);
    }

    public final StringProperty keyProperty() {
        return this.key;
    }

    @Column(name="name", nullable=false, columnDefinition="TEXT")
    public String getName() {
        return (String)this.name.get();
    }

    @Transient
    public String getLocalName() {
        return LocaleText.tryParse((String)this.getName()).getTextOrDefault();
    }

    public void setName(String displayName) {
        this.name.set((Object)displayName);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    @Column(name="type_id", nullable=false)
    public String getTypeId() {
        return (String)this.typeId.get();
    }

    public void setTypeId(String type) {
        this.typeId.set((Object)type);
    }

    public final StringProperty typeIdProperty() {
        return this.typeId;
    }

    @Column(name="parameter")
    public String getParameter() {
        return (String)this.parameter.get();
    }

    public void setParameter(String parameter) {
        this.parameter.set((Object)parameter);
    }

    public final StringProperty parameterProperty() {
        return this.parameter;
    }

    @Column(name="user_visible", columnDefinition="BOOLEAN DEFAULT TRUE")
    public boolean isUserVisible() {
        return this.userVisible.get();
    }

    public void setUserVisible(boolean userVisible) {
        this.userVisible.set(userVisible);
    }

    public final BooleanProperty userVisibleProperty() {
        return this.userVisible;
    }

    @Column(name="user_editable", columnDefinition="BOOLEAN DEFAULT FALSE")
    public boolean isUserEditable() {
        return this.userEditable.get();
    }

    public void setUserEditable(boolean userEditable) {
        this.userEditable.set(userEditable);
        if (userEditable) {
            this.setUserVisible(true);
        }
    }

    public final BooleanProperty userEditableProperty() {
        return this.userEditable;
    }

    @Column(name="visual_order_position")
    public Integer getVisualOrderPosition() {
        return (Integer)this.visualOrderPosition.get();
    }

    public void setVisualOrderPosition(Integer orderNr) {
        this.visualOrderPosition.set((Object)orderNr);
    }

    public final ObjectProperty<Integer> visualOrderPositionProperty() {
        return this.visualOrderPosition;
    }

    @OneToMany(mappedBy="property", cascade={CascadeType.REMOVE})
    public List<PropertyValue> getValues() {
        return this.values;
    }

    protected void setValues(List<PropertyValue> values) {
        this.values = values;
    }

    public String toString() {
        return this.getLocalName();
    }

    @Transient
    public String getIconUri() {
        return DEFAULT_ICON.toString();
    }

    public int hashCode() {
        if (this.getId() != null) {
            return Property.class.hashCode() + 17 * this.getId();
        }
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Property)) {
            return false;
        }
        Property prop = (Property)obj;
        if (this.getId() != null && prop.getId() != null) {
            return this.getId().equals(prop.getId());
        }
        return this == prop;
    }
}

