/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.structure;

import de.elpro.ewms.core.structure.PropertyGroupDescriptor;

public class PropertyDescriptor {
    private final PropertyGroupDescriptor propertyGroupDescriptor;
    private final String key;
    private final String propertyName;

    public PropertyDescriptor(PropertyGroupDescriptor propertyGroupDescriptor, String key) {
        this(propertyGroupDescriptor, key, null);
    }

    public PropertyDescriptor(PropertyGroupDescriptor propertyGroupDescriptor, String key, String propertyName) {
        if (propertyGroupDescriptor == null) {
            throw new IllegalArgumentException("property group descriptor cannot be null");
        }
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("key cannot be null or empty");
        }
        this.propertyGroupDescriptor = propertyGroupDescriptor;
        this.key = key;
        this.propertyName = propertyName;
    }

    public PropertyGroupDescriptor getPropertyGroupDescriptor() {
        return this.propertyGroupDescriptor;
    }

    public String getKey() {
        return this.key;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String toString() {
        return String.valueOf(this.getPropertyGroupDescriptor().toString()) + "//" + (this.getPropertyName() != null && this.getPropertyName().isEmpty() ? this.getPropertyName() : this.getKey());
    }
}

