/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.structure;

import de.elpro.ewms.core.structure.Property;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.resources.Resources;
import de.elpro.ui.model.UIModelElement;
import de.elpro.ui.text.LocaleText;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="ewms_structure_property_group")
@Access(value=AccessType.PROPERTY)
public class PropertyGroup
implements UIModelElement {
    public static final String DAO_NAMESPACE = "structure/propertygroup";
    public static final URL DEFAULT_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"properties/object_properties.png");
    private final StringProperty key = new SimpleStringProperty();
    private final ObjectProperty<StructureClass> structureClass = new SimpleObjectProperty();
    private final StringProperty name = new SimpleStringProperty();
    private final ObjectProperty<Integer> visualOrderPosition = new SimpleObjectProperty();
    private List<Property> properties = new ArrayList<Property>();
    private boolean enabled = true;

    protected PropertyGroup() {
    }

    public PropertyGroup(StructureClass structureClass, String key) {
        this(structureClass, key, null);
    }

    public PropertyGroup(StructureClass structureClass, String key, String displayName) {
        this();
        this.setStructureClass(structureClass);
        this.setKey(key);
        this.setName(displayName);
    }

    @Id
    @Column(name="key")
    public String getKey() {
        return (String)this.key.get();
    }

    protected void setKey(String key) {
        this.key.set((Object)key);
    }

    public final StringProperty keyProperty() {
        return this.key;
    }

    @ManyToOne
    @JoinColumn(name="structure_class", nullable=false)
    public StructureClass getStructureClass() {
        return (StructureClass)this.structureClass.get();
    }

    public void setStructureClass(StructureClass structureClass) {
        this.structureClass.set((Object)structureClass);
    }

    public final ObjectProperty<StructureClass> structureClassProperty() {
        return this.structureClass;
    }

    @Column(name="name", nullable=false, columnDefinition="TEXT")
    public String getName() {
        return (String)this.name.get();
    }

    @Transient
    public String getLocalName() {
        return LocaleText.tryParse((String)this.getName()).getTextOrDefault();
    }

    public void setName(String displayName) {
        this.name.set((Object)displayName);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    @Column(name="visual_order_position")
    public Integer getVisualOrderPosition() {
        return (Integer)this.visualOrderPosition.get();
    }

    public void setVisualOrderPosition(Integer orderNr) {
        this.visualOrderPosition.set((Object)orderNr);
    }

    public final ObjectProperty<Integer> visualOrderPositionProperty() {
        return this.visualOrderPosition;
    }

    @OneToMany(mappedBy="group", cascade={CascadeType.REMOVE})
    public List<Property> getProperties() {
        return this.properties;
    }

    protected void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    @Transient
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        Integer myOrderPos = this.getVisualOrderPosition();
        Integer oOrderPos = null;
        if (o instanceof UIModelElement) {
            oOrderPos = ((UIModelElement)o).getVisualOrderPosition();
        }
        if (myOrderPos != null && oOrderPos == null) {
            return -1;
        }
        if (oOrderPos != null && myOrderPos == null) {
            return 1;
        }
        if (myOrderPos != null && oOrderPos != null && !myOrderPos.equals(oOrderPos)) {
            return myOrderPos.compareTo(oOrderPos);
        }
        if (o.toString() == null) {
            return 1;
        }
        if (this.toString() == null) {
            return -1;
        }
        if (o instanceof PropertyGroup) {
            return this.getKey().compareTo(((PropertyGroup)o).getKey());
        }
        return this.toString().compareTo(o.toString());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PropertyGroup)) {
            return false;
        }
        PropertyGroup pg = (PropertyGroup)obj;
        return this.getKey() != null && this.getKey().equals(pg.getKey());
    }

    public int hashCode() {
        return PropertyGroup.class.hashCode() + 17 * this.getKey().hashCode();
    }

    public String toString() {
        return this.getLocalName();
    }

    @Transient
    public String getIconUri() {
        return DEFAULT_ICON.toString();
    }
}

