/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.structure;

import de.elpro.ewms.core.characteristic.Characteristic2D;
import de.elpro.ewms.core.resources.ResourceLoader;
import de.elpro.ewms.core.structure.Property;
import de.elpro.ewms.core.structure.PropertyGroup;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.resources.Resources;
import de.elpro.ui.model.IdObject;
import de.elpro.ui.model.UIModelElement;
import de.elpro.ui.text.LocaleText;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="ewms_structure_class")
@Access(value=AccessType.PROPERTY)
public class StructureClass
implements UIModelElement,
IdObject {
    public static final String DAO_NAMESPACE = "structure/class";
    public static final URL DEFAULT_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"ewms/structure_class.png");
    public static final String ICONS_FOLDER = "ewms/icons/structure/class";
    private final ObjectProperty<Integer> id = new SimpleObjectProperty();
    private final StringProperty token = new SimpleStringProperty();
    private final StringProperty name = new SimpleStringProperty();
    private final StringProperty description = new SimpleStringProperty();
    private final ObjectProperty<Integer> visualOrderPosition = new SimpleObjectProperty();
    private final StringProperty iconKey = new SimpleStringProperty();
    private Set<StructureClass> extendClasses = new HashSet<StructureClass>();
    private Set<StructureClass> parentClasses = new HashSet<StructureClass>();
    private Set<StructureClass> connectedClasses = new HashSet<StructureClass>();
    private Set<StructureObject> objects = new HashSet<StructureObject>();
    private Set<Variable> variables = new HashSet<Variable>();
    private Set<Characteristic2D> characteristics2D = new HashSet<Characteristic2D>();
    private List<PropertyGroup> propertieGroups = new LinkedList<PropertyGroup>();
    private Set<String> roleIds = new HashSet<String>();
    private boolean enabled = true;
    private String resultIconKey;

    public StructureClass() {
    }

    public StructureClass(int id) {
        this.setId(id);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ewms_structure_structureclass_sequence")
    @SequenceGenerator(name="ewms_structure_structureclass_sequence", sequenceName="ewms_structure_structureclass_sequence")
    public Integer getId() {
        return (Integer)this.id.get();
    }

    protected void setId(int id) {
        this.id.set((Object)id);
    }

    public final ObjectProperty<Integer> idProperty() {
        return this.id;
    }

    @Column(name="name", nullable=false, columnDefinition="TEXT")
    public String getName() {
        return (String)this.name.get();
    }

    @Transient
    public String getLocalName() {
        return LocaleText.tryParse((String)this.getName()).getTextOrDefault();
    }

    public void setName(String displayName) {
        this.name.set((Object)displayName);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    @Column(name="token")
    public String getToken() {
        return (String)this.token.get();
    }

    public void setToken(String token) {
        this.token.set((Object)token);
    }

    public final StringProperty tokenProperty() {
        return this.token;
    }

    @Transient
    public String getResultToken() {
        LinkedList<StructureClass> structureClasses = new LinkedList<StructureClass>();
        structureClasses.add(this);
        while (!structureClasses.isEmpty()) {
            StructureClass structureClass = (StructureClass)structureClasses.removeFirst();
            if (structureClass.getToken() != null) {
                return structureClass.getToken();
            }
            structureClasses.addAll(structureClass.getParentClasses());
        }
        return null;
    }

    @Column(name="description", columnDefinition="TEXT")
    public String getDescription() {
        return (String)this.description.get();
    }

    public void setDescription(String description) {
        this.description.set((Object)description);
    }

    public final StringProperty descriptionProperty() {
        return this.description;
    }

    @Column(name="visual_order_position")
    public Integer getVisualOrderPosition() {
        return (Integer)this.visualOrderPosition.get();
    }

    public void setVisualOrderPosition(Integer visualOrderPosition) {
        this.visualOrderPosition.set((Object)visualOrderPosition);
    }

    public final ObjectProperty<Integer> visualOrderPositionProperty() {
        return this.visualOrderPosition;
    }

    @Column(name="icon_key")
    public String getIconKey() {
        return (String)this.iconKey.get();
    }

    public void setIconKey(String iconKey) {
        this.iconKey.set((Object)iconKey);
    }

    public final StringProperty iconKeyProperty() {
        return this.iconKey;
    }

    @ManyToMany(mappedBy="parentClasses")
    public Set<StructureClass> getExtendClasses() {
        return this.extendClasses;
    }

    protected void setExtendClasses(Set<StructureClass> extendClasses) {
        this.extendClasses = extendClasses;
    }

    @ManyToMany
    @JoinTable(name="ewms_structure_class_extenders", joinColumns={@JoinColumn(name="extendclass")}, inverseJoinColumns={@JoinColumn(name="parentclass")})
    public Set<StructureClass> getParentClasses() {
        return this.parentClasses;
    }

    protected void setParentClasses(Set<StructureClass> parentClasses) {
        this.parentClasses = parentClasses;
    }

    @Transient
    public Set<StructureClass> getAllParentClasses() {
        HashSet<StructureClass> allParents = new HashSet<StructureClass>();
        allParents.add(this);
        for (StructureClass parent : this.parentClasses) {
            for (StructureClass pparent : parent.getAllParentClasses()) {
                if (allParents.contains(pparent)) continue;
                allParents.add(pparent);
            }
            if (allParents.contains(parent)) continue;
            allParents.add(parent);
        }
        return allParents;
    }

    @Transient
    public Set<StructureClass> getAllExtendClasses() {
        HashSet<StructureClass> allExtenders = new HashSet<StructureClass>();
        allExtenders.add(this);
        for (StructureClass extend : this.extendClasses) {
            for (StructureClass eextend : extend.getAllExtendClasses()) {
                if (allExtenders.contains(eextend)) continue;
                allExtenders.add(eextend);
            }
            if (allExtenders.contains(extend)) continue;
            allExtenders.add(extend);
        }
        return allExtenders;
    }

    @ManyToMany
    @JoinTable(name="ewms_structure_class_connectors", joinColumns={@JoinColumn(name="ewms_structure_class_id")}, inverseJoinColumns={@JoinColumn(name="connectedclasses_id")})
    public Set<StructureClass> getConnectedClasses() {
        return this.connectedClasses;
    }

    protected void setConnectedClasses(Set<StructureClass> connectedClasses) {
        this.connectedClasses = connectedClasses;
    }

    @OneToMany(mappedBy="structureClass")
    public Set<Variable> getVariables() {
        return this.variables;
    }

    protected void setVariables(Set<Variable> variables) {
        this.variables = variables;
    }

    @Transient
    public Set<Variable> getAllVariables() {
        Set<StructureClass> allParents = this.getAllParentClasses();
        HashSet<Variable> allVariables = new HashSet<Variable>();
        for (StructureClass parent : allParents) {
            allVariables.addAll(parent.getVariables());
        }
        return allVariables;
    }

    @Transient
    public Set<Variable> getTokenizedVariables() {
        if (this.getToken() == null) {
            return Collections.emptySet();
        }
        HashSet<Variable> sameTokenVariables = new HashSet<Variable>();
        LinkedList<StructureClass> classPool = new LinkedList<StructureClass>();
        classPool.add(this);
        while (!classPool.isEmpty()) {
            StructureClass sc = (StructureClass)classPool.removeFirst();
            sameTokenVariables.addAll(sc.getVariables());
            for (StructureClass extendClass : sc.getExtendClasses()) {
                if (extendClass.getToken() != null) continue;
                classPool.add(extendClass);
            }
        }
        return sameTokenVariables;
    }

    @OneToMany(mappedBy="structureClass")
    public Set<Characteristic2D> getCharacteristics2D() {
        return this.characteristics2D;
    }

    protected void setCharacteristics2D(Set<Characteristic2D> c2ds) {
        this.characteristics2D = c2ds;
    }

    @Transient
    public Set<Characteristic2D> getAllCharacteristics2D() {
        Set<StructureClass> allParents = this.getAllParentClasses();
        HashSet<Characteristic2D> allCharacteristics = new HashSet<Characteristic2D>();
        for (StructureClass parent : allParents) {
            allCharacteristics.addAll(parent.getCharacteristics2D());
        }
        return allCharacteristics;
    }

    @Transient
    public Set<Characteristic2D> getTokenizedCharacteristic2D() {
        if (this.getToken() == null) {
            return Collections.emptySet();
        }
        HashSet<Characteristic2D> sameTokenCharacteristics = new HashSet<Characteristic2D>();
        LinkedList<StructureClass> classPool = new LinkedList<StructureClass>();
        classPool.add(this);
        while (!classPool.isEmpty()) {
            StructureClass sc = (StructureClass)classPool.removeFirst();
            sameTokenCharacteristics.addAll(sc.getCharacteristics2D());
            for (StructureClass extendClass : sc.getExtendClasses()) {
                if (extendClass.getToken() != null) continue;
                classPool.add(extendClass);
            }
        }
        return sameTokenCharacteristics;
    }

    @Transient
    public Set<StructureClass> getAllConnectedClasses() {
        HashSet<StructureClass> allConnectedClasses = new HashSet<StructureClass>();
        for (StructureClass parent : this.getAllParentClasses()) {
            allConnectedClasses.addAll(parent.getConnectedClasses());
        }
        return allConnectedClasses;
    }

    @OneToMany(mappedBy="structureClass")
    public Set<StructureObject> getObjects() {
        return this.objects;
    }

    protected void setObjects(Set<StructureObject> objects) {
        this.objects = objects;
    }

    @Transient
    public Set<StructureObject> getAllObjects() {
        Set<StructureClass> allExtenders = this.getAllExtendClasses();
        HashSet<StructureObject> allObjects = new HashSet<StructureObject>();
        for (StructureClass parent : allExtenders) {
            allObjects.addAll(parent.getObjects());
        }
        return allObjects;
    }

    @OneToMany(mappedBy="structureClass", cascade={CascadeType.REMOVE})
    public List<PropertyGroup> getPropertyGroups() {
        return this.propertieGroups;
    }

    protected void setPropertyGroups(List<PropertyGroup> propertyGroups) {
        this.propertieGroups = propertyGroups;
    }

    @ElementCollection
    @CollectionTable(name="ewms_structure_class_roles", joinColumns={@JoinColumn(name="class_id")})
    @Column(name="role_id")
    public Set<String> getRoleIds() {
        return this.roleIds;
    }

    protected void setRoleIds(Set<String> roleIds) {
        this.roleIds = roleIds;
    }

    @Transient
    public Set<PropertyGroup> getAllPropertyGroups() {
        Set<StructureClass> allClasses = this.getAllParentClasses();
        allClasses.add(this);
        TreeSet<PropertyGroup> allParentGroups = new TreeSet<PropertyGroup>();
        for (StructureClass clazz : allClasses) {
            allParentGroups.addAll(clazz.getPropertyGroups());
        }
        return allParentGroups;
    }

    @Transient
    public Set<Property> getAllProperties() {
        HashSet<Property> properties = new HashSet<Property>();
        for (PropertyGroup pg : this.getAllPropertyGroups()) {
            properties.addAll(pg.getProperties());
        }
        return properties;
    }

    @Transient
    public Property getProperty(String groupKey, String propertyKey) {
        for (PropertyGroup group : this.getAllPropertyGroups()) {
            if (!group.getKey().equals(groupKey)) continue;
            for (Property property : group.getProperties()) {
                if (!property.getKey().equals(propertyKey)) continue;
                return property;
            }
        }
        return null;
    }

    public boolean isSubclass(StructureClass superClass) {
        if (this.equals(superClass)) {
            return true;
        }
        for (StructureClass parentClass : this.getParentClasses()) {
            if (!parentClass.isSubclass(superClass)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getLocalName();
    }

    public boolean equals(Object obj) {
        if (obj instanceof StructureClass) {
            if (this.getId() == null) {
                return super.equals(obj);
            }
            if (this.getId().equals(((StructureClass)obj).getId())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.getId() == null) {
            return super.hashCode();
        }
        return StructureClass.class.hashCode() + 17 * (Integer)this.id.get();
    }

    @Transient
    public String getIconUri() {
        if (this.getIconKey() == null || this.getIconKey().isEmpty()) {
            return DEFAULT_ICON.toString();
        }
        return ResourceLoader.getCachedIconPath(this.getIconKey());
    }

    @Transient
    public Node getResultGraphic() {
        return new ImageView(ResourceLoader.getCachedIconPath(this.getResultIconKey()));
    }

    public void loadResultIconKey() {
        LinkedList<StructureClass> structureClasses = new LinkedList<StructureClass>();
        structureClasses.add(this);
        while (!structureClasses.isEmpty()) {
            StructureClass structureClass = (StructureClass)structureClasses.removeFirst();
            if (structureClass.getIconKey() != null) {
                this.resultIconKey = structureClass.getIconKey();
                return;
            }
            structureClasses.addAll(structureClass.getParentClasses());
        }
    }

    @Transient
    public String getResultIconKey() {
        return this.resultIconKey;
    }

    public void setResultIconKey(String resultIconKey) {
        this.resultIconKey = resultIconKey;
    }

    @Transient
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

