/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.structure.propertytypes;

import de.elpro.ewms.core.structure.IPropertyType;
import de.elpro.ewms.core.variable.calculated.FormulaInterpreter;
import de.elpro.ewms.core.variable.calculated.FormulaNode;
import de.elpro.ui.fx.validator.Validators;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.TextArea;
import javafx.util.StringConverter;
import jidefx.scene.control.validation.Validator;
import org.osgi.service.component.annotations.Component;

@Component(service={IPropertyType.class})
public class FormulaPropertyType
implements IPropertyType<String, Void> {
    public static final String ID = "de.elpro.ewms.core.structure.propertytypes.formula";
    public static final StringConverter<String> CONVERTER = new StringConverter<String>(){

        public String toString(String object) {
            return object;
        }

        public String fromString(String string) {
            return string;
        }
    };

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getName() {
        return "Formula";
    }

    @Override
    public StringConverter<String> getValueConverter() {
        return CONVERTER;
    }

    @Override
    public StringConverter<Void> getParameterConverter() {
        return null;
    }

    @Override
    public Node createValueEditor(Property<String> valueProperty, Void parameter, ObservableBooleanValue editableProperty) {
        TextArea textArea = new TextArea();
        textArea.setEditable(true);
        textArea.editableProperty().bind((ObservableValue)editableProperty);
        textArea.setText((String)valueProperty.getValue());
        textArea.textProperty().addListener((o, ov, nv) -> valueProperty.setValue(nv));
        return textArea;
    }

    @Override
    public Node createParameterEditor(Property<Void> parameterProperty) {
        return null;
    }

    @Override
    public Validator getValueValidator() {
        return Validators.createValidator((o, ov, nv) -> {
            if (nv == null || nv.toString().trim().isEmpty()) {
                return true;
            }
            FormulaNode formula = FormulaInterpreter.getOperationTreeDeprecated(nv.toString());
            return formula != null;
        }, (String)"Cannot parse formula");
    }

    @Override
    public Validator getParameterValidator() {
        return null;
    }

    public String toString() {
        return this.getName();
    }
}

