/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.structure.propertytypes;

import de.elpro.ewms.core.structure.IPropertyType;
import de.elpro.ewms.core.structure.propertytypes.TextPropertyType;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.TextArea;
import javafx.util.StringConverter;
import jidefx.scene.control.validation.Validator;
import org.osgi.service.component.annotations.Component;

@Component(service={IPropertyType.class})
public class LongTextPropertyType
implements IPropertyType<String, Void> {
    public static final String ID = "de.elpro.ewms.core.structure.propertytypes.longtext";

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getName() {
        return "Long Text";
    }

    @Override
    public StringConverter<String> getValueConverter() {
        return TextPropertyType.CONVERTER;
    }

    @Override
    public StringConverter<Void> getParameterConverter() {
        return null;
    }

    @Override
    public Node createValueEditor(Property<String> valueProperty, Void parameter, ObservableBooleanValue editableProperty) {
        TextArea textArea = new TextArea();
        textArea.setEditable(true);
        textArea.editableProperty().bind((ObservableValue)editableProperty);
        textArea.setText((String)valueProperty.getValue());
        textArea.textProperty().addListener((o, ov, nv) -> valueProperty.setValue(nv));
        return textArea;
    }

    @Override
    public Node createParameterEditor(Property<Void> parameterProperty) {
        return null;
    }

    @Override
    public Validator getValueValidator() {
        return null;
    }

    @Override
    public Validator getParameterValidator() {
        return null;
    }

    public String toString() {
        return this.getName();
    }
}

