/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.structure.propertytypes;

import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.units.MeasuringUnitFormat;
import de.elpro.ewms.core.units.MeasuringUnitFormats;

class MeasuringUnitValueParameter {
    private final MeasuringUnit measuringUnit;
    private final MeasuringUnitFormat valueFormat;

    public MeasuringUnitValueParameter(MeasuringUnit measuringUnit, MeasuringUnitFormat format) {
        this.measuringUnit = measuringUnit;
        this.valueFormat = format != null ? format : MeasuringUnitFormats.SIMPLE;
    }

    public MeasuringUnit getMeasuringUnit() {
        return this.measuringUnit;
    }

    public MeasuringUnitFormat getValueFormat() {
        return this.valueFormat;
    }

    public String toString() {
        return String.format("{muvp:%s:%s}", this.measuringUnit.getId(), this.valueFormat != null ? this.valueFormat.getId() : "");
    }

    public static MeasuringUnitValueParameter parse(String s) {
        try {
            String[] parts = s.split(":");
            if (parts.length != 3) {
                throw new IllegalArgumentException();
            }
            if (!"{muvp".equals(parts[0]) || !parts[2].endsWith("}")) {
                throw new IllegalArgumentException();
            }
            MeasuringUnit unit = MeasuringUnit.getMeasuringUnit(parts[1]);
            String valueFormatId = parts[2].substring(0, parts[2].length() - 1);
            MeasuringUnitFormat format = !valueFormatId.isEmpty() ? MeasuringUnitFormat.getMeasuringUnitFormat(valueFormatId) : null;
            return new MeasuringUnitValueParameter(unit, format);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

