/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.structure.propertytypes;

import de.elpro.ewms.core.structure.IPropertyType;
import de.elpro.ewms.core.structure.propertytypes.MeasuringUnitValueParameter;
import de.elpro.ewms.core.units.DisplayUnitFormat;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.units.MeasuringUnitFormat;
import de.elpro.ewms.core.units.MeasuringUnitFormats;
import de.elpro.ewms.core.units.MeasuringUnitValue;
import de.elpro.ewms.core.units.PhysicalUnitRegistry;
import de.elpro.ui.fx.controls.NumericField;
import de.elpro.ui.fx.validator.Validators;
import java.text.DecimalFormat;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.layout.VBox;
import javafx.util.StringConverter;
import jidefx.scene.control.validation.Validator;
import org.osgi.service.component.annotations.Component;

@Component(service={IPropertyType.class})
public class MeasuringUnitValuePropertyType
implements IPropertyType<MeasuringUnitValue, MeasuringUnitValueParameter> {
    public static final String ID = "de.elpro.ewms.core.structure.propertytypes.measuringunitvalue";
    public static final StringConverter<MeasuringUnitValue> VALUE_CONVERTER = new StringConverter<MeasuringUnitValue>(){

        public String toString(MeasuringUnitValue object) {
            if (object == null) {
                return null;
            }
            return object.toString();
        }

        public MeasuringUnitValue fromString(String string) {
            if (string == null || string.isEmpty()) {
                return null;
            }
            return MeasuringUnitValue.parse(string);
        }
    };
    private static final StringConverter<MeasuringUnitValueParameter> PROPERTY_CONVERTER = new StringConverter<MeasuringUnitValueParameter>(){

        public String toString(MeasuringUnitValueParameter object) {
            if (object == null) {
                return null;
            }
            return object.toString();
        }

        public MeasuringUnitValueParameter fromString(String string) {
            if (string == null || string.isEmpty()) {
                return null;
            }
            return MeasuringUnitValueParameter.parse(string);
        }
    };

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getName() {
        return "Measuring Unit Value";
    }

    @Override
    public StringConverter<MeasuringUnitValue> getValueConverter() {
        return VALUE_CONVERTER;
    }

    @Override
    public StringConverter<MeasuringUnitValueParameter> getParameterConverter() {
        return PROPERTY_CONVERTER;
    }

    @Override
    public Node createValueEditor(Property<MeasuringUnitValue> valueProperty, MeasuringUnitValueParameter parameter, ObservableBooleanValue editableProperty) {
        MeasuringUnit measuringUnit = parameter.getMeasuringUnit();
        DecimalFormat df = (DecimalFormat)measuringUnit.getValueFormat(parameter.getValueFormat()).clone();
        String suffix = measuringUnit.getDisplayUnitText(DisplayUnitFormat.SIMPLE);
        NumericField numericField = new NumericField(Double.class, df);
        numericField.setSuffixText(suffix);
        numericField.focusedProperty().addListener((o, ov, nv) -> numericField.setShowAllFractionDigits(nv.booleanValue()));
        numericField.editableProperty().bind((ObservableValue)editableProperty);
        if (valueProperty.getValue() != null) {
            numericField.setValue((Number)((MeasuringUnitValue)valueProperty.getValue()).getValue());
        }
        numericField.valueProperty().addListener((o, ov, nv) -> {
            if (nv == null) {
                valueProperty.setValue(null);
            } else {
                valueProperty.setValue((Object)new MeasuringUnitValue(measuringUnit, nv.doubleValue()));
            }
        });
        return numericField;
    }

    @Override
    public Node createParameterEditor(Property<MeasuringUnitValueParameter> parameterProperty) {
        ComboBox units = new ComboBox(FXCollections.observableArrayList(PhysicalUnitRegistry.getPhysicalUnits()));
        ComboBox measuringUnits = new ComboBox();
        ComboBox measuringUnitFormats = new ComboBox(FXCollections.observableArrayList(MeasuringUnitFormats.getFormats()));
        if (parameterProperty.getValue() != null) {
            MeasuringUnit mu = ((MeasuringUnitValueParameter)parameterProperty.getValue()).getMeasuringUnit();
            units.setValue((Object)mu.getPhysicalUnit());
            measuringUnits.setItems(FXCollections.observableArrayList(mu.getPhysicalUnit().getMeasuringUnits()));
            measuringUnits.setValue((Object)mu);
            measuringUnitFormats.setValue((Object)((MeasuringUnitValueParameter)parameterProperty.getValue()).getValueFormat());
        }
        Runnable updatePropertyValue = () -> {
            MeasuringUnit mu = (MeasuringUnit)measuringUnits.getValue();
            MeasuringUnitFormat format = (MeasuringUnitFormat)measuringUnitFormats.getValue();
            if (mu != null) {
                parameterProperty.setValue((Object)new MeasuringUnitValueParameter(mu, format));
            } else {
                parameterProperty.setValue(null);
            }
        };
        units.valueProperty().addListener((o, ov, nv) -> measuringUnits.setItems(FXCollections.observableArrayList(nv.getMeasuringUnits())));
        measuringUnits.valueProperty().addListener((o, ov, nv) -> updatePropertyValue.run());
        measuringUnitFormats.valueProperty().addListener((o, ov, nv) -> updatePropertyValue.run());
        VBox box = new VBox(3.0, new Node[]{units, measuringUnits, measuringUnitFormats});
        return box;
    }

    @Override
    public Validator getValueValidator() {
        return null;
    }

    @Override
    public Validator getParameterValidator() {
        return Validators.createNotEmptyValidator((String)"Measuring Unit must be not empty");
    }

    public String toString() {
        return this.getName();
    }
}

