/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.tables;

import de.elpro.ewms.core.structure.SearchPolicy;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.tables.Column;
import de.elpro.ewms.core.tables.Table;
import de.elpro.resources.Resources;
import de.elpro.ui.model.IdObject;
import de.elpro.ui.model.UIModelElement;
import de.elpro.ui.text.LocaleText;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Transient;

@Entity
@javax.persistence.Table(name="ewms_tables_columngroup")
@Access(value=AccessType.PROPERTY)
public class ColumnGroup
implements UIModelElement,
IdObject {
    public static final String DAO_NAMESPACE = "tables/columngroup";
    public static final URL DEFAULT_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"tables/column_group.png");
    private final ObjectProperty<Integer> id = new SimpleObjectProperty();
    private final ObjectProperty<Table> table = new SimpleObjectProperty();
    private final ObjectProperty<ColumnGroup> parentGroup = new SimpleObjectProperty();
    private final ObjectProperty<StructureClass> objectClass = new SimpleObjectProperty();
    private final ObjectProperty<SearchPolicy> objectSearchPolicy = new SimpleObjectProperty((Object)SearchPolicy.DirectChildren);
    private final StringProperty name = new SimpleStringProperty();
    private final ObjectProperty<Integer> visualOrderPosition = new SimpleObjectProperty();
    private final ObjectProperty<Integer> prefWidth = new SimpleObjectProperty();
    private final StringProperty columnStyleClass = new SimpleStringProperty();
    private List<Column> columns = new LinkedList<Column>();
    private List<ColumnGroup> columnGroups = new LinkedList<ColumnGroup>();

    public ColumnGroup() {
    }

    public ColumnGroup(int id) {
        this.setId(id);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ewms_tables_columngroup_sequence")
    @SequenceGenerator(name="ewms_tables_columngroup_sequence", sequenceName="ewms_tables_columngroup_sequence")
    public Integer getId() {
        return (Integer)this.id.get();
    }

    protected void setId(int id) {
        this.id.set((Object)id);
    }

    public final ObjectProperty<Integer> idProperty() {
        return this.id;
    }

    @ManyToOne
    @JoinColumn(name="var_table", nullable=false)
    public Table getTable() {
        return (Table)this.table.get();
    }

    public void setTable(Table table) {
        this.table.set((Object)table);
    }

    public final ObjectProperty<Table> tableProperty() {
        return this.table;
    }

    @ManyToOne
    @JoinColumn(name="parent_group", nullable=true)
    public ColumnGroup getParentGroup() {
        return (ColumnGroup)this.parentGroup.get();
    }

    public void setParentGroup(ColumnGroup parentGroup) {
        this.parentGroup.set((Object)parentGroup);
    }

    public final ObjectProperty<ColumnGroup> parentGroupProperty() {
        return this.parentGroup;
    }

    @ManyToOne
    @JoinColumn(name="object_class", nullable=true)
    public StructureClass getObjectClass() {
        return (StructureClass)this.objectClass.get();
    }

    public void setObjectClass(StructureClass objectClass) {
        this.objectClass.set((Object)objectClass);
    }

    public final ObjectProperty<StructureClass> objectClassProperty() {
        return this.objectClass;
    }

    @javax.persistence.Column(name="object_search_policy", columnDefinition="INTEGER DEFAULT 6")
    public SearchPolicy getObjectSearchPolicy() {
        return (SearchPolicy)((Object)this.objectSearchPolicy.get());
    }

    public void setObjectSearchPolicy(SearchPolicy searchPolicy) {
        this.objectSearchPolicy.set((Object)searchPolicy);
    }

    public ObjectProperty<SearchPolicy> objectSearchPolicyProperty() {
        return this.objectSearchPolicy;
    }

    @javax.persistence.Column(name="name", nullable=false, columnDefinition="TEXT")
    public String getName() {
        return (String)this.name.get();
    }

    @Transient
    public String getLocalName() {
        return LocaleText.tryParse((String)this.getName()).getTextOrDefault();
    }

    public void setName(String name) {
        this.name.set((Object)name);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    @javax.persistence.Column(name="visual_order_position")
    public Integer getVisualOrderPosition() {
        return (Integer)this.visualOrderPosition.get();
    }

    public void setVisualOrderPosition(Integer visualOrderPosition) {
        this.visualOrderPosition.set((Object)visualOrderPosition);
    }

    public final ObjectProperty<Integer> visualOrderPositionProperty() {
        return this.visualOrderPosition;
    }

    public Integer getPrefWidth() {
        return (Integer)this.prefWidth.get();
    }

    public void setPrefWidth(Integer prefWidth) {
        this.prefWidth.set((Object)prefWidth);
    }

    public final ObjectProperty<Integer> prefWidthProperty() {
        return this.prefWidth;
    }

    @javax.persistence.Column(name="column_style_class", columnDefinition="TEXT")
    public String getColumnStyleClass() {
        return (String)this.columnStyleClass.get();
    }

    public void setColumnStyleClass(String columnStyleClass) {
        this.columnStyleClass.set((Object)columnStyleClass);
    }

    public final StringProperty columnStyleClassProperty() {
        return this.columnStyleClass;
    }

    @OneToMany(mappedBy="columnGroup", cascade={CascadeType.REMOVE})
    public List<Column> getColumns() {
        return this.columns;
    }

    void setColumns(List<Column> columns) {
        this.columns = columns;
    }

    @OneToMany(mappedBy="parentGroup", cascade={CascadeType.REMOVE})
    public List<ColumnGroup> getColumnGroups() {
        return this.columnGroups;
    }

    void setColumnGroups(List<ColumnGroup> columnGroups) {
        this.columnGroups = columnGroups;
    }

    @Transient
    public List<UIModelElement> getChildrenNormalized() {
        LinkedList<UIModelElement> children = new LinkedList<UIModelElement>();
        for (Column column : this.getColumns()) {
            children.add(column);
        }
        for (ColumnGroup columnGroup : this.getColumnGroups()) {
            children.add(columnGroup);
        }
        Collections.sort(children);
        return children;
    }

    public String toString() {
        return this.getLocalName();
    }

    public int hashCode() {
        if (this.getId() == null) {
            return super.hashCode();
        }
        return ColumnGroup.class.hashCode() + 17 * this.getId();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ColumnGroup)) {
            return false;
        }
        return this.hashCode() == obj.hashCode();
    }

    @Transient
    public String getIconUri() {
        return DEFAULT_ICON.toString();
    }
}

