/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.tables;

import de.elpro.ewms.core.tables.ColumnStyleScope;
import de.elpro.ui.fx.utils.FXUtils;
import de.elpro.ui.model.UIModelElement;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.paint.Color;

public class ColumnStyle
implements UIModelElement {
    private final ObjectProperty<ColumnStyleScope> scope = new SimpleObjectProperty();
    private final StringProperty styleClassName = new SimpleStringProperty();
    private final ObjectProperty<Color> baseBackgroundColor = new SimpleObjectProperty();
    private final BooleanProperty gradientBackground = new SimpleBooleanProperty();
    private final ObjectProperty<Color> textColor = new SimpleObjectProperty();
    private final BooleanProperty textBold = new SimpleBooleanProperty();
    private final BooleanProperty textItalic = new SimpleBooleanProperty();
    private static String CELL_SELECTION_STYLE_PATTERN = "/* ------ Background on selection ------- */\n.var-table TableRow:selected .cell.var-value.%1$s,\n.var-table TableRow:selected .cell.var-value.%1$s:odd\n{\n\t-fx-background-color: -fx-control-outer-background, -fx-table-cell-border-color, -fx-control-inner-background;\n\t-fx-background-insets: 0.0, 1.0 0.0 1.0 0.0, 2.0 2.0 2.0 1.0;\n}\n";
    private static String GRADIENT_COLOR_PATTERN = "linear-gradient(%1$s, %2$s)";
    private static String HEADER_BACKGROUND_STYLE_PATTERN = "/* ------ header background -------- */\n.var-table .column-header.%1$s {\n\t-fx-background-color: %2$s, %3$s;\n\t-fx-background-insets: 0, 0.0 1.0 1.0 0.0;\n}\n";
    private static String HEADER_TEXT_STYLE_PATTERN = "/* ------ cell text color -------- */\n.var-table .table-column.column-header.%1$s .label {%2$s }\n";
    private static String CELL_BACKGROUND_STYLE_PATTERN = "/* ------ cell background ------- */\n.var-table .cell.%1$s { -fx-background-color: %2$s; }\n.var-table .cell.%1$s:odd { -fx-background-color: %3$s; }\n";
    private static String CELL_SUMMARY_BACKGROUND_STYLE_PATTERN = "/* ------ cell background ------- */\n.var-table .cell.summary.%1$s { -fx-background-color: %2$s; }\n.var-table .cell.summary.%1$s:odd { -fx-background-color: %3$s; }\n";
    private static String CELL_TEXT_STYLE_PATTERN = "/* ------ cell text color -------- */\n.var-table .cell.%1$s {%2$s }\n";
    private static String CELL_TEXT_COLOR_PATTERN = " -fx-text-fill: %s;";
    private static String CELL_TEXT_BOLD = " -fx-font-weight: bold;";
    private static String CELL_TEXT_ITALIC = " -fx-font-style: italic;";

    public ObjectProperty<ColumnStyleScope> scopeProperty() {
        return this.scope;
    }

    public ColumnStyleScope getScope() {
        return (ColumnStyleScope)((Object)this.scopeProperty().get());
    }

    public void setScope(ColumnStyleScope scope) {
        this.scopeProperty().set((Object)scope);
    }

    public StringProperty styleClassNameProperty() {
        return this.styleClassName;
    }

    public String getStyleClassName() {
        return (String)this.styleClassNameProperty().get();
    }

    public void setStyleClassName(String styleClassName) {
        this.styleClassNameProperty().set((Object)styleClassName);
    }

    public ObjectProperty<Color> baseBackgroundColorProperty() {
        return this.baseBackgroundColor;
    }

    public Color getBaseBackgroundColor() {
        return (Color)this.baseBackgroundColorProperty().get();
    }

    public void setBaseBackgroundColor(Color baseColor) {
        this.baseBackgroundColorProperty().set((Object)baseColor);
    }

    public BooleanProperty gradientBackgroundProperty() {
        return this.gradientBackground;
    }

    public boolean isGradientBackground() {
        return this.gradientBackgroundProperty().get();
    }

    public void setGradientBackground(boolean gradientBackground) {
        this.gradientBackgroundProperty().set(gradientBackground);
    }

    public ObjectProperty<Color> textColorProperty() {
        return this.textColor;
    }

    public Color getTextColor() {
        return (Color)this.textColorProperty().get();
    }

    public void setTextColor(Color textColor) {
        this.textColorProperty().set((Object)textColor);
    }

    public BooleanProperty textBoldProperty() {
        return this.textBold;
    }

    public boolean isTextBold() {
        return this.textBoldProperty().get();
    }

    public void setTextBold(boolean textBold) {
        this.textBoldProperty().set(textBold);
    }

    public BooleanProperty textItalicProperty() {
        return this.textItalic;
    }

    public boolean isTextItalic() {
        return this.textItalicProperty().get();
    }

    public void setTextItalic(boolean textItalic) {
        this.textItalicProperty().set(textItalic);
    }

    public ObservableValue<String> textProperty() {
        return this.styleClassNameProperty();
    }

    public String toStylesheet() {
        String styleClassName = this.getStyleClassName();
        StringBuilder stylesheet = new StringBuilder(String.format(CELL_SELECTION_STYLE_PATTERN, styleClassName));
        Color baseColor = this.getBaseBackgroundColor();
        if (baseColor != null) {
            String backgroundColor = ColumnStyle.getBackgroundColor(baseColor, this.isGradientBackground());
            String backgroundStyle = switch (this.getScope()) {
                case ColumnStyleScope.ColumnHeader -> String.format(HEADER_BACKGROUND_STYLE_PATTERN, styleClassName, FXUtils.toHexColor((Color)ColumnStyle.getOddCellColor(baseColor)), backgroundColor);
                case ColumnStyleScope.ColumnCell -> {
                    String oddBackgroundColor = ColumnStyle.getBackgroundColor(ColumnStyle.getOddCellColor(baseColor), this.isGradientBackground());
                    yield String.format(CELL_BACKGROUND_STYLE_PATTERN, styleClassName, backgroundColor, oddBackgroundColor);
                }
                case ColumnStyleScope.ColumnSummaryCell -> {
                    String oddBackgroundColor = ColumnStyle.getBackgroundColor(ColumnStyle.getOddCellColor(baseColor), this.isGradientBackground());
                    yield String.format(CELL_SUMMARY_BACKGROUND_STYLE_PATTERN, styleClassName, backgroundColor, oddBackgroundColor);
                }
                default -> throw new IllegalArgumentException("Unexpected value: " + (Object)((Object)this.getScope()));
            };
            stylesheet.append(backgroundStyle);
        }
        StringBuilder textStyle = new StringBuilder();
        Color textColor = this.getTextColor();
        if (textColor != null) {
            textStyle.append(String.format(CELL_TEXT_COLOR_PATTERN, FXUtils.toHexColor((Color)textColor)));
        }
        if (this.isTextBold()) {
            textStyle.append(CELL_TEXT_BOLD);
        }
        if (this.isTextItalic()) {
            textStyle.append(CELL_TEXT_ITALIC);
        }
        if (!textStyle.isEmpty()) {
            switch (this.getScope()) {
                case ColumnHeader: {
                    stylesheet.append(String.format(HEADER_TEXT_STYLE_PATTERN, styleClassName, textStyle.toString()));
                    break;
                }
                case ColumnCell: 
                case ColumnSummaryCell: {
                    stylesheet.append(String.format(CELL_TEXT_STYLE_PATTERN, styleClassName, textStyle.toString()));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected value: " + (Object)((Object)this.getScope()));
                }
            }
        }
        return stylesheet.toString();
    }

    private static String getBackgroundColor(Color baseColor, boolean isGradient) {
        if (isGradient) {
            Color gradColor = baseColor.deriveColor(1.0, 1.0, 0.8, 1.0);
            return String.format(GRADIENT_COLOR_PATTERN, FXUtils.toHexColor((Color)baseColor), FXUtils.toHexColor((Color)gradColor));
        }
        return FXUtils.toHexColor((Color)baseColor);
    }

    private static Color getOddCellColor(Color baseColor) {
        double colorFactor = 0.95;
        double[] rgb = new double[]{baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue()};
        int i = 0;
        while (i < rgb.length) {
            double c1 = rgb[i] + (colorFactor - 1.0);
            double c2 = rgb[i] * colorFactor;
            rgb[i] = Math.max(Math.min((c1 + c2) / 2.0, 1.0), 0.0);
            ++i;
        }
        return new Color(rgb[0], rgb[1], rgb[2], baseColor.getOpacity());
    }

    public static void main(String[] args) {
        ColumnStyle style = new ColumnStyle();
        style.setScope(ColumnStyleScope.ColumnCell);
        style.setStyleClassName("my-test-style");
        style.setBaseBackgroundColor(new Color(0.6, 0.1, 0.3, 0.8));
        style.setGradientBackground(true);
        style.setTextColor(Color.BLACK);
        System.out.println(style.toStylesheet());
    }

    public String toString() {
        return this.getStyleClassName();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ColumnStyle)) {
            return false;
        }
        return this.getStyleClassName().equals(((ColumnStyle)obj).getStyleClassName());
    }
}

