/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.tables;

import de.elpro.ewms.core.structure.SearchPolicy;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.tables.Column;
import de.elpro.ewms.core.tables.ColumnGroup;
import de.elpro.ewms.core.tables.TableStyle;
import de.elpro.ewms.core.tables.TableType;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.virtualtime.VirtualRaster;
import de.elpro.resources.Icons;
import de.elpro.ui.model.IdObject;
import de.elpro.ui.model.UIModelElement;
import de.elpro.ui.text.LocaleText;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;

@Entity
@javax.persistence.Table(name="ewms_tables_table", uniqueConstraints={@UniqueConstraint(columnNames={"structure_class", "name"})})
@Access(value=AccessType.PROPERTY)
public class Table
implements UIModelElement,
IdObject {
    public static final String DAO_NAMESPACE = "tables/table";
    public static final URL DEFAULT_ICON = Icons.TABLE_ITEM_URL;
    private final ObjectProperty<Integer> id = new SimpleObjectProperty();
    private final ObjectProperty<TableType> type = new SimpleObjectProperty((Object)TableType.Time);
    private final ObjectProperty<String> roleKey = new SimpleObjectProperty();
    private final StringProperty name = new SimpleStringProperty();
    private final StringProperty title = new SimpleStringProperty();
    private final ObjectProperty<VirtualRaster> defaultRaster = new SimpleObjectProperty();
    private final ObjectProperty<Integer> visualOrderPosition = new SimpleObjectProperty();
    private final ObjectProperty<StructureClass> structureClass = new SimpleObjectProperty();
    private final ObjectProperty<SearchPolicy> objectSearchPolicy = new SimpleObjectProperty((Object)SearchPolicy.Auto);
    private final ObjectProperty<Column> aggrLabelColumn = new SimpleObjectProperty();
    private final ObjectProperty<Variable> phasingVariable = new SimpleObjectProperty();
    private final DoubleProperty phasingDelta = new SimpleDoubleProperty(0.0);
    private final StringProperty fxStylesheet = new SimpleStringProperty();
    private final ObjectProperty<TableStyle> style = new SimpleObjectProperty();
    private List<Column> columns = new ArrayList<Column>();
    private List<ColumnGroup> columnGroups = new ArrayList<ColumnGroup>();
    private List<Column> rootColumns = new ArrayList<Column>();
    private List<ColumnGroup> rootColumnGroups = new ArrayList<ColumnGroup>();

    public Table() {
    }

    public Table(int id) {
        this.setId(id);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ewms_tables_table_sequence")
    @SequenceGenerator(name="ewms_tables_table_sequence", sequenceName="ewms_tables_table_sequence")
    public Integer getId() {
        return (Integer)this.id.get();
    }

    protected void setId(int id) {
        this.id.set((Object)id);
    }

    public final ObjectProperty<Integer> idProperty() {
        return this.id;
    }

    @javax.persistence.Column(name="type", nullable=false)
    public TableType getType() {
        return (TableType)((Object)this.type.get());
    }

    public void setType(TableType type) {
        this.type.set((Object)type);
    }

    public final ObjectProperty<TableType> typeProperty() {
        return this.type;
    }

    @javax.persistence.Column(name="role_key")
    public String getRoleKey() {
        return (String)this.roleKey.get();
    }

    public void setRoleKey(String roleKey) {
        this.roleKey.set((Object)roleKey);
    }

    public final ObjectProperty<String> roleKeyProperty() {
        return this.roleKey;
    }

    @javax.persistence.Column(name="name", nullable=false, columnDefinition="TEXT")
    public String getName() {
        return (String)this.name.get();
    }

    @Transient
    public String getLocalName() {
        return LocaleText.tryParse((String)this.getName()).getTextOrDefault();
    }

    public void setName(String name) {
        this.name.set((Object)name);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    @javax.persistence.Column(name="title", columnDefinition="TEXT")
    public String getTitle() {
        return (String)this.title.get();
    }

    @Transient
    public String getLocalTitle() {
        return LocaleText.tryParse((String)this.getTitle()).getTextOrDefault();
    }

    public void setTitle(String title) {
        this.title.set((Object)title);
    }

    public final StringProperty titleProperty() {
        return this.title;
    }

    @javax.persistence.Column(name="default_raster")
    public VirtualRaster getDefaultRaster() {
        return (VirtualRaster)((Object)this.defaultRaster.get());
    }

    public void setDefaultRaster(VirtualRaster defaultRaster) {
        this.defaultRaster.set((Object)defaultRaster);
    }

    public final ObjectProperty<VirtualRaster> defaultRasterProperty() {
        return this.defaultRaster;
    }

    @javax.persistence.Column(name="visual_order_position")
    public Integer getVisualOrderPosition() {
        return (Integer)this.visualOrderPosition.get();
    }

    public void setVisualOrderPosition(Integer visualOrderPosition) {
        this.visualOrderPosition.set((Object)visualOrderPosition);
    }

    public final ObjectProperty<Integer> visualOrderPositionProperty() {
        return this.visualOrderPosition;
    }

    @ManyToOne
    @JoinColumn(name="aggr_label_column", nullable=true)
    public Column getAggrLabelColumn() {
        return (Column)this.aggrLabelColumn.get();
    }

    public void setAggrLabelColumn(Column aggrLabelColumn) {
        this.aggrLabelColumn.set((Object)aggrLabelColumn);
    }

    public final ObjectProperty<Column> aggrLabelColumnProperty() {
        return this.aggrLabelColumn;
    }

    @ManyToOne
    @JoinColumn(name="structure_class", nullable=false)
    public StructureClass getStructureClass() {
        return (StructureClass)this.structureClass.get();
    }

    public void setStructureClass(StructureClass structureClass) {
        this.structureClass.set((Object)structureClass);
    }

    public final ObjectProperty<StructureClass> structureClassProperty() {
        return this.structureClass;
    }

    @javax.persistence.Column(name="object_search_policy", nullable=false, columnDefinition="INTEGER DEFAULT 0")
    public SearchPolicy getObjectSearchPolicy() {
        return (SearchPolicy)((Object)this.objectSearchPolicy.get());
    }

    public void setObjectSearchPolicy(SearchPolicy searchPolicy) {
        this.objectSearchPolicy.set((Object)searchPolicy);
    }

    public ObjectProperty<SearchPolicy> objectSearchPolicyProperty() {
        return this.objectSearchPolicy;
    }

    @ManyToOne
    @JoinColumn(name="phasing_variable", nullable=true)
    public Variable getPhasingVariable() {
        return (Variable)this.phasingVariable.get();
    }

    public void setPhasingVariable(Variable variable) {
        this.phasingVariable.set((Object)variable);
    }

    public final ObjectProperty<Variable> phasingVariableProperty() {
        return this.phasingVariable;
    }

    @javax.persistence.Column(name="phasing_delta", columnDefinition="DOUBLE PRECISION DEFAULT 0")
    public double getPhasingDelta() {
        return this.phasingDelta.get();
    }

    public void setPhasingDelta(double delta) {
        this.phasingDelta.set(delta);
    }

    public final DoubleProperty phasingDeltaProperty() {
        return this.phasingDelta;
    }

    @javax.persistence.Column(name="fx_stylesheet", columnDefinition="TEXT")
    public String getFXStylesheet() {
        return (String)this.fxStylesheet.get();
    }

    public void setFXStylesheet(String fxStylesheet) {
        this.fxStylesheet.set((Object)fxStylesheet);
    }

    public final StringProperty fxStylesheetProperty() {
        return this.fxStylesheet;
    }

    public final ObjectProperty<TableStyle> styleProperty() {
        return this.style;
    }

    @Transient
    public final TableStyle getTableStyle() {
        return (TableStyle)this.styleProperty().get();
    }

    public final void setTableStyle(TableStyle style) {
        this.styleProperty().set((Object)style);
    }

    @javax.persistence.Column(name="style", columnDefinition="TEXT")
    public String getTableStyleSerialized() {
        if (this.getTableStyle() == null) {
            return null;
        }
        return this.getTableStyle().toJson();
    }

    public void setTableStyleSerialized(String json) {
        this.setTableStyle(TableStyle.parse(json));
    }

    @OneToMany(mappedBy="table", cascade={CascadeType.REMOVE})
    public List<Column> getColumns() {
        return this.columns;
    }

    void setColumns(List<Column> columns) {
        this.columns = columns;
    }

    @OneToMany(mappedBy="table", cascade={CascadeType.REMOVE})
    public List<ColumnGroup> getColumnGroups() {
        return this.columnGroups;
    }

    void setColumnGroups(List<ColumnGroup> columnGroups) {
        this.columnGroups = columnGroups;
    }

    @Transient
    public List<Column> getRootColumns() {
        return this.rootColumns;
    }

    @Transient
    public List<ColumnGroup> getRootColumnGroups() {
        return this.rootColumnGroups;
    }

    public void normalize() {
        for (Column column : this.getRootColumns()) {
            if (this.getColumns().contains(column)) continue;
            this.getColumns().add(column);
        }
        LinkedList<ColumnGroup> groups = new LinkedList<ColumnGroup>(this.getRootColumnGroups());
        while (!groups.isEmpty()) {
            ColumnGroup columnGroup = groups.removeFirst();
            for (Column column : columnGroup.getColumns()) {
                if (this.getColumns().contains(column)) continue;
                this.getColumns().add(column);
            }
            groups.addAll(columnGroup.getColumnGroups());
        }
    }

    @Transient
    public List<UIModelElement> getRootChildren() {
        LinkedList<UIModelElement> children = new LinkedList<UIModelElement>();
        children.addAll(this.getRootColumns());
        children.addAll(this.getRootColumnGroups());
        Collections.sort(children);
        return children;
    }

    public String toString() {
        return this.getLocalName();
    }

    public int hashCode() {
        if (this.getId() == null) {
            return super.hashCode();
        }
        return Table.class.hashCode() + 17 * this.getId();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Table)) {
            return false;
        }
        return this.hashCode() == obj.hashCode();
    }

    @Transient
    public String getIconUri() {
        return DEFAULT_ICON.toString();
    }
}

