/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.time;

import de.elpro.ewms.core.Messages;
import java.util.ArrayList;

public enum Raster {
    Milli_1(1L),
    Milli_2(2L),
    Milli_5(5L),
    Milli_10(10L),
    Milli_20(20L),
    Milli_25(25L),
    Milli_50(50L),
    Milli_100(100L),
    Milli_200(200L),
    Milli_250(250L),
    Milli_500(500L),
    Second_1(1000L),
    Second_2(2000L),
    Second_5(5000L),
    Second_10(10000L),
    Second_15(15000L),
    Second_30(30000L),
    Minute_1(60000L),
    Minute_2(120000L),
    Minute_5(300000L),
    Minute_10(600000L),
    Minute_15(900000L),
    Minute_30(1800000L),
    Hour(3600000L);

    private final long value;

    private Raster(long value) {
        this.value = value;
    }

    public long toMilli() {
        return this.value;
    }

    public static Raster getRaster(long value) {
        Raster[] rasterArray = Raster.values();
        int n = rasterArray.length;
        int n2 = 0;
        while (n2 < n) {
            Raster raster = rasterArray[n2];
            if (raster.value == value) {
                return raster;
            }
            ++n2;
        }
        return null;
    }

    public long getRasterEnd(long timestamp) {
        long offset = timestamp % this.toMilli();
        if (offset == 0L) {
            return timestamp;
        }
        return timestamp - offset + (offset > 0L ? this.toMilli() : 0L);
    }

    public long getRasterBegin(long timestamp) {
        long offset = timestamp % this.toMilli();
        if (offset == 0L) {
            return timestamp;
        }
        return timestamp - offset - (offset > 0L ? 0L : this.toMilli());
    }

    public Raster[] getCompatibleAggregationRasters() {
        ArrayList<Raster> rasters = new ArrayList<Raster>();
        rasters.add(this);
        int i = this.ordinal() + 1;
        while (i < Raster.values().length) {
            Raster candidate = Raster.values()[i];
            if (candidate.isCompatibleAggregation(this)) {
                rasters.add(candidate);
            }
            ++i;
        }
        return (Raster[])rasters.toArray(Raster[]::new);
    }

    public boolean isCompatibleAggregation(Raster forRaster) {
        return this.toMilli() / forRaster.toMilli() * forRaster.toMilli() == this.toMilli();
    }

    public String toString() {
        switch (this) {
            case Milli_1: {
                return Messages.time_Raster_1ms;
            }
            case Milli_2: {
                return Messages.time_Raster_2ms;
            }
            case Milli_5: {
                return Messages.time_Raster_5ms;
            }
            case Milli_10: {
                return Messages.time_Raster_10ms;
            }
            case Milli_20: {
                return Messages.time_Raster_20ms;
            }
            case Milli_25: {
                return Messages.time_Raster_25ms;
            }
            case Milli_50: {
                return Messages.time_Raster_50ms;
            }
            case Milli_100: {
                return Messages.time_Raster_100ms;
            }
            case Milli_200: {
                return Messages.time_Raster_200ms;
            }
            case Milli_250: {
                return Messages.time_Raster_250ms;
            }
            case Milli_500: {
                return Messages.time_Raster_500ms;
            }
            case Second_1: {
                return Messages.time_Raster_1sec;
            }
            case Second_2: {
                return Messages.time_Raster_2sec;
            }
            case Second_5: {
                return Messages.time_Raster_5sec;
            }
            case Second_10: {
                return Messages.time_Raster_10sec;
            }
            case Second_15: {
                return Messages.time_Raster_15sec;
            }
            case Second_30: {
                return Messages.time_Raster_30sec;
            }
            case Minute_1: {
                return Messages.time_Raster_1min;
            }
            case Minute_2: {
                return Messages.time_Raster_2min;
            }
            case Minute_5: {
                return Messages.time_Raster_5min;
            }
            case Minute_10: {
                return Messages.time_Raster_10min;
            }
            case Minute_15: {
                return Messages.time_Raster_15min;
            }
            case Minute_30: {
                return Messages.time_Raster_30min;
            }
            case Hour: {
                return Messages.time_Raster_hour;
            }
        }
        return this.name();
    }
}

