/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.time;

import de.elpro.ewms.core.time.TimeIntervalStringValue;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class TimeIntervalStringValueCollection
implements Collection<TimeIntervalStringValue> {
    private static final int DEFAULT_CAPACITY = 10;
    private long[] fromTs = new long[0];
    private long[] toTs = new long[0];
    private int[] startPosition = new int[0];
    private int[] textByteLength = new int[0];
    private byte[] textDataArray = new byte[0];
    private int size = 0;

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        return false;
    }

    @Override
    public Iterator<TimeIntervalStringValue> iterator() {
        return new TimeIntervalStringValueIterator();
    }

    public TimeIntervalStringValue[] toArray() {
        TimeIntervalStringValue[] obj = new TimeIntervalStringValue[this.size];
        int i = 0;
        for (TimeIntervalStringValue v : this) {
            obj[i++] = v;
        }
        new ArrayList();
        return obj;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return Arrays.copyOf(this.toArray(), this.size, a.getClass());
    }

    @Override
    public boolean add(TimeIntervalStringValue e) {
        if (e == null) {
            throw new IllegalArgumentException();
        }
        if (this.size == this.fromTs.length) {
            int newSize = this.size < 10 ? 10 : (this.size == 10 ? 20 : (int)((double)this.size * 1.3));
            this.fromTs = Arrays.copyOf(this.fromTs, newSize);
            this.toTs = Arrays.copyOf(this.toTs, newSize);
            this.startPosition = Arrays.copyOf(this.startPosition, newSize);
            this.textByteLength = Arrays.copyOf(this.textByteLength, newSize);
        }
        byte[] textBytes = e.getValue() == null ? null : ((String)e.getValue()).getBytes(StandardCharsets.UTF_8);
        int freeBytesLeft = this.textDataArray.length - (this.size != 0 ? this.startPosition[this.size - 1] + this.textByteLength[this.size - 1] : 0);
        if (textBytes != null && textBytes.length > freeBytesLeft) {
            int newSize = Math.max((int)((double)this.textDataArray.length * 1.3), this.textDataArray.length + textBytes.length);
            this.textDataArray = Arrays.copyOf(this.textDataArray, newSize);
        }
        int startPosition = this.size == 0 ? 0 : this.startPosition[this.size - 1] + this.textByteLength[this.size - 1];
        this.fromTs[this.size] = e.getFromTs();
        this.toTs[this.size] = e.getToTs();
        this.startPosition[this.size] = startPosition;
        int n = this.textByteLength[this.size] = textBytes != null ? textBytes.length : -1;
        if (textBytes != null) {
            int i = 0;
            while (i < textBytes.length) {
                this.textDataArray[startPosition + i] = textBytes[i];
                ++i;
            }
        }
        ++this.size;
        return true;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends TimeIntervalStringValue> c) {
        for (TimeIntervalStringValue timeIntervalStringValue : c) {
            this.add(timeIntervalStringValue);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.fromTs = new long[0];
        this.toTs = new long[0];
        this.startPosition = new int[0];
        this.textByteLength = new int[0];
        this.textDataArray = new byte[0];
        this.size = 0;
    }

    public long[] getFromTs() {
        return this.fromTs;
    }

    public void setFromTs(long[] fromTs) {
        this.fromTs = fromTs;
    }

    public long[] getToTs() {
        return this.toTs;
    }

    public void setToTs(long[] toTs) {
        this.toTs = toTs;
    }

    public int[] getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(int[] startPosition) {
        this.startPosition = startPosition;
    }

    public int[] getTextByteLength() {
        return this.textByteLength;
    }

    public void setTextByteLength(int[] textByteLength) {
        this.textByteLength = textByteLength;
    }

    public byte[] getTextDataArray() {
        return this.textDataArray;
    }

    public void setTextDataArray(byte[] textDataArray) {
        this.textDataArray = textDataArray;
    }

    public static TimeIntervalStringValueCollection of(int size, long[] fromTs, long[] toTs, int[] startPositions, int[] textByteLength, byte[] textDataArray) {
        TimeIntervalStringValueCollection collection = new TimeIntervalStringValueCollection();
        collection.fromTs = fromTs;
        collection.toTs = toTs;
        collection.startPosition = startPositions;
        collection.textByteLength = textByteLength;
        collection.textDataArray = textDataArray;
        collection.size = size;
        return collection;
    }

    private final class TimeIntervalStringValueIterator
    implements Iterator<TimeIntervalStringValue> {
        private int index = 0;

        private TimeIntervalStringValueIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < TimeIntervalStringValueCollection.this.size;
        }

        @Override
        public TimeIntervalStringValue next() {
            if (this.index == TimeIntervalStringValueCollection.this.size) {
                throw new NoSuchElementException();
            }
            long itemFromTs = TimeIntervalStringValueCollection.this.fromTs[this.index];
            long itemToTs = TimeIntervalStringValueCollection.this.toTs[this.index];
            int itemStartPosition = TimeIntervalStringValueCollection.this.startPosition[this.index];
            int itemByteLength = TimeIntervalStringValueCollection.this.textByteLength[this.index];
            String text = itemByteLength > 0 ? new String(TimeIntervalStringValueCollection.this.textDataArray, itemStartPosition, itemByteLength, StandardCharsets.UTF_8) : null;
            ++this.index;
            return new TimeIntervalStringValue(itemFromTs, itemToTs, text);
        }
    }
}

