/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.time;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;

public class TimeIntervalValue<V> {
    private final long fromTs;
    private final long toTs;
    private final V value;

    public TimeIntervalValue(long fromTs, long toTs, V value) {
        if (fromTs >= toTs) {
            throw new IllegalArgumentException(String.format("Not an interval %s <-> %s", LocalDateTime.ofInstant(Instant.ofEpochMilli(fromTs), ZoneOffset.systemDefault()), LocalDateTime.ofInstant(Instant.ofEpochMilli(toTs), ZoneOffset.systemDefault())));
        }
        this.fromTs = fromTs;
        this.toTs = toTs;
        this.value = value;
    }

    public long getFromTs() {
        return this.fromTs;
    }

    public long getToTs() {
        return this.toTs;
    }

    public V getValue() {
        return this.value;
    }

    public long getIntersectDuration(TimeIntervalValue<V> other) {
        return Math.min(this.toTs, other.toTs) - Math.max(this.fromTs, other.fromTs);
    }

    public boolean continues(TimeIntervalValue<V> other) {
        return other.toTs == this.fromTs && other.value.equals(this.value);
    }

    public TimeIntervalValue<V> in(long fromTs, long toTs) {
        if (fromTs > this.fromTs || toTs < this.toTs) {
            return new TimeIntervalValue<V>(Math.max(fromTs, this.fromTs), Math.min(toTs, this.toTs), this.value);
        }
        return this;
    }

    public String toString() {
        return String.format("[%s - %s, \"%s\"]", LocalDateTime.ofInstant(Instant.ofEpochMilli(this.fromTs), ZoneOffset.systemDefault()), LocalDateTime.ofInstant(Instant.ofEpochMilli(this.toTs), ZoneOffset.systemDefault()), this.value);
    }
}

