/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.time;

import java.time.Instant;

public class TimeRange {
    public static final TimeRange REALTIME = new TimeRange(Instant.MIN, Instant.MAX);
    public static final String DAO_NAMESPACE = "timerange";
    private Instant from;
    private Instant to;

    public TimeRange(Instant from, Instant to) {
        this.from = from;
        this.to = to;
    }

    public Instant getFrom() {
        return this.from;
    }

    public void setFrom(Instant from) {
        this.from = from;
    }

    public Instant getTo() {
        return this.to;
    }

    public void setTo(Instant to) {
        this.to = to;
    }

    public boolean in(long ts) {
        if (this.from != null && ts <= this.from.toEpochMilli()) {
            return false;
        }
        return this.to == null || ts <= this.to.toEpochMilli();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TimeRange)) {
            return false;
        }
        TimeRange tr = (TimeRange)obj;
        return this.from.equals(tr.getFrom()) && this.to.equals(tr.getTo());
    }

    public int hashCode() {
        return this.from.hashCode() + 17 * this.to.hashCode();
    }

    public String toString() {
        return String.format("%s <-> %s", this.from, this.to);
    }
}

