/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.time;

import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.time.TimeRangeFilterType;
import de.elpro.ewms.core.time.Timeline;
import de.elpro.ewms.core.time.TimelinePhase;
import java.time.LocalDate;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="ewms_timerange_filter", uniqueConstraints={@UniqueConstraint(columnNames={"user_id"})})
@Access(value=AccessType.PROPERTY)
public class TimeRangeFilterPreference {
    public static final String DAO_NAMESPACE = "timerange/prefs";
    private final ObjectProperty<Integer> id = new SimpleObjectProperty();
    private final ObjectProperty<User> user = new SimpleObjectProperty();
    private final ObjectProperty<TimeRangeFilterType> type = new SimpleObjectProperty((Object)TimeRangeFilterType.GlobalView_Date);
    private final ObjectProperty<Raster> autoUpdateInterval = new SimpleObjectProperty();
    private final ObjectProperty<Integer> customViewIndex = new SimpleObjectProperty();
    private final IntegerProperty yearFilterFrom = new SimpleIntegerProperty();
    private final IntegerProperty yearFilterTo = new SimpleIntegerProperty();
    private final ObjectProperty<Timeline> timeline = new SimpleObjectProperty();
    private final ObjectProperty<TimelinePhase> phaseFrom = new SimpleObjectProperty();
    private final ObjectProperty<TimelinePhase> phaseTo = new SimpleObjectProperty();
    private final ObjectProperty<LocalDate> dateFrom = new SimpleObjectProperty();
    private final ObjectProperty<LocalDate> dateTo = new SimpleObjectProperty();

    public TimeRangeFilterPreference() {
    }

    public TimeRangeFilterPreference(int id) {
        this.setId(id);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ewms_timerange_filter_sequence")
    @SequenceGenerator(name="ewms_timerange_filter_sequence", sequenceName="ewms_timerange_filter_sequence")
    public Integer getId() {
        return (Integer)this.id.get();
    }

    void setId(int id) {
        this.id.set((Object)id);
    }

    @ManyToOne
    @JoinColumn(name="user_id", nullable=false)
    public User getUser() {
        return (User)this.user.get();
    }

    public void setUser(User user) {
        this.user.set((Object)user);
    }

    @Column(name="type", nullable=false)
    public TimeRangeFilterType getType() {
        return (TimeRangeFilterType)((Object)this.type.get());
    }

    public void setType(TimeRangeFilterType type) {
        this.type.set((Object)type);
    }

    public final ObjectProperty<TimeRangeFilterType> typeProperty() {
        return this.type;
    }

    public ObjectProperty<Raster> autoUpdateIntervalProperty() {
        return this.autoUpdateInterval;
    }

    @Column(name="auto_update_interval")
    public Raster getAutoUpdateInterval() {
        return (Raster)((Object)this.autoUpdateIntervalProperty().get());
    }

    public void setAutoUpdateInterval(Raster raster) {
        this.autoUpdateIntervalProperty().set((Object)raster);
    }

    @Column(name="custom_view_index", nullable=true)
    public Integer getCustomViewIndex() {
        return (Integer)this.customViewIndex.get();
    }

    public void setCustomViewIndex(Integer index) {
        this.customViewIndex.set((Object)index);
    }

    public ObjectProperty<Integer> customViewIndexProperty() {
        return this.customViewIndex;
    }

    @Column(name="year_filter_from", nullable=false)
    public int getYearFilterFrom() {
        return this.yearFilterFrom.get();
    }

    public void setYearFilterFrom(int yearFilterFrom) {
        this.yearFilterFrom.set(yearFilterFrom);
    }

    public final IntegerProperty yearFilterFromProperty() {
        return this.yearFilterFrom;
    }

    @Column(name="year_filter_to", nullable=false)
    public int getYearFilterTo() {
        return this.yearFilterTo.get();
    }

    public void setYearFilterTo(int yearFilterTo) {
        this.yearFilterTo.set(yearFilterTo);
    }

    public final IntegerProperty yearFilterToProperty() {
        return this.yearFilterTo;
    }

    @ManyToOne
    @JoinColumn(name="timeline")
    public Timeline getTimeline() {
        return (Timeline)this.timeline.get();
    }

    public void setTimeline(Timeline timeline) {
        this.timeline.set((Object)timeline);
    }

    public final ObjectProperty<Timeline> timelineProperty() {
        return this.timeline;
    }

    @ManyToOne
    @JoinColumn(name="phase_from")
    public TimelinePhase getPhaseFrom() {
        return (TimelinePhase)this.phaseFrom.get();
    }

    public void setPhaseFrom(TimelinePhase phaseFrom) {
        this.phaseFrom.set((Object)phaseFrom);
    }

    public final ObjectProperty<TimelinePhase> phaseFromProperty() {
        return this.phaseFrom;
    }

    @ManyToOne
    @JoinColumn(name="phase_to")
    public TimelinePhase getPhaseTo() {
        return (TimelinePhase)this.phaseTo.get();
    }

    public void setPhaseTo(TimelinePhase phaseTo) {
        this.phaseTo.set((Object)phaseTo);
    }

    public final ObjectProperty<TimelinePhase> phaseToProperty() {
        return this.phaseTo;
    }

    @Column(name="date_from")
    public LocalDate getDateFrom() {
        return (LocalDate)this.dateFrom.get();
    }

    public void setDateFrom(LocalDate dateFrom) {
        this.dateFrom.set((Object)dateFrom);
        if (this.getDateTo() != null && this.getDateTo().isBefore(dateFrom)) {
            this.dateTo.set((Object)dateFrom);
        }
    }

    public final ObjectProperty<LocalDate> dateFrom() {
        return this.dateFrom;
    }

    public LocalDate getDateTo() {
        return (LocalDate)this.dateTo.get();
    }

    public void setDateTo(LocalDate dateTo) {
        this.dateTo.set((Object)dateTo);
        if (dateTo != null && this.getDateFrom().isAfter(dateTo)) {
            this.dateFrom.set((Object)dateTo);
        }
    }

    public final ObjectProperty<LocalDate> dateToProperty() {
        return this.dateTo;
    }
}

