/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.time;

import de.elpro.ewms.core.time.PhaseType;
import de.elpro.ewms.core.time.TimelinePhase;
import de.elpro.ewms.core.time.TimelineZone;
import de.elpro.resources.Resources;
import de.elpro.ui.model.IdObject;
import de.elpro.ui.model.UIModelElement;
import de.elpro.ui.text.LocaleText;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="ewms_timeline")
@Access(value=AccessType.PROPERTY)
public class Timeline
implements UIModelElement,
IdObject {
    public static final String DAO_NAMESPACE = "timeline";
    public static final URL DEFAULT_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"ewms/timeline/timeline.png");
    private final ObjectProperty<Integer> id = new SimpleObjectProperty();
    private final StringProperty key = new SimpleStringProperty();
    private final StringProperty name = new SimpleStringProperty();
    private final ObjectProperty<TimelineZone> zone = new SimpleObjectProperty((Object)TimelineZone.Virtual);
    private final StringProperty description = new SimpleStringProperty();
    private final ObjectProperty<Integer> visualOrderPosition = new SimpleObjectProperty();
    private List<PhaseType> types = new LinkedList<PhaseType>();
    private List<TimelinePhase> phases = new LinkedList<TimelinePhase>();

    public Timeline() {
    }

    public Timeline(int id) {
        this.setId(id);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ewms_timeline_sequence")
    @SequenceGenerator(name="ewms_timeline_sequence", sequenceName="ewms_timeline_sequence")
    public Integer getId() {
        return (Integer)this.id.get();
    }

    protected void setId(int id) {
        this.id.set((Object)id);
    }

    public final ObjectProperty<Integer> idProperty() {
        return this.id;
    }

    @Column(name="key", unique=true)
    public String getKey() {
        return (String)this.key.get();
    }

    public void setKey(String key) {
        this.key.set((Object)key);
    }

    public StringProperty keyProperty() {
        return this.key;
    }

    @Transient
    public String getLocalName() {
        return LocaleText.tryParse((String)this.getName()).getTextOrDefault();
    }

    @Column(name="name", nullable=false)
    public String getName() {
        return (String)this.name.get();
    }

    public void setName(String name) {
        this.name.set((Object)name);
    }

    public StringProperty nameProperty() {
        return this.name;
    }

    @Column(name="timeline_zone", nullable=false)
    public TimelineZone getZone() {
        return (TimelineZone)((Object)this.zone.get());
    }

    public void setZone(TimelineZone zone) {
        this.zone.set((Object)zone);
    }

    public ObjectProperty<TimelineZone> zoneProperty() {
        return this.zone;
    }

    @Column(name="description", columnDefinition="TEXT")
    public String getDescription() {
        return (String)this.description.get();
    }

    public void setDescription(String description) {
        this.description.set((Object)description);
    }

    public StringProperty descriptionProperty() {
        return this.description;
    }

    @Column(name="visual_order_position")
    public Integer getVisualOrderPosition() {
        return (Integer)this.visualOrderPosition.get();
    }

    public void setVisualOrderPosition(Integer visualOrderPosition) {
        this.visualOrderPosition.set((Object)visualOrderPosition);
    }

    public final ObjectProperty<Integer> visualOrderPositionProperty() {
        return this.visualOrderPosition;
    }

    @OneToMany(mappedBy="timeline", orphanRemoval=true)
    public List<PhaseType> getTypes() {
        return this.types;
    }

    protected void setTypes(List<PhaseType> types) {
        this.types = types;
    }

    @OneToMany(mappedBy="timeline", orphanRemoval=true)
    @OrderBy(value="from")
    public List<TimelinePhase> getPhases() {
        return this.phases;
    }

    protected void setPhases(List<TimelinePhase> phases) {
        this.phases = phases;
    }

    @Transient
    public String getIconUri() {
        return DEFAULT_ICON.toString();
    }

    public String toString() {
        return this.getLocalName();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Timeline)) {
            return false;
        }
        if (this.getKey() == null) {
            return super.equals(obj);
        }
        return this.getKey().equals(((Timeline)obj).getKey());
    }

    public int hashCode() {
        if (this.getKey() == null) {
            return super.hashCode();
        }
        return Timeline.class.hashCode() + 17 * this.getKey().hashCode();
    }
}

