/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.time;

import de.elpro.ewms.core.charts.ShapeType;
import de.elpro.ewms.core.time.PhaseType;
import de.elpro.ewms.core.time.Timeline;
import de.elpro.ui.model.IdObject;
import de.elpro.ui.model.UIModelElement;
import de.elpro.ui.text.LocaleText;
import java.time.LocalDate;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Shape;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="ewms_timeline_phase", uniqueConstraints={@UniqueConstraint(columnNames={"timeline", "from_day"})})
@Access(value=AccessType.PROPERTY)
public class TimelinePhase
implements UIModelElement,
IdObject {
    public static final String DAO_NAMESPACE = "phase";
    private final ObjectProperty<Integer> id = new SimpleObjectProperty();
    private final ObjectProperty<Timeline> timeline = new SimpleObjectProperty();
    private final ObjectProperty<LocalDate> from = new SimpleObjectProperty();
    private final ObjectProperty<PhaseType> type = new SimpleObjectProperty();
    private final StringProperty label = new SimpleStringProperty();

    public TimelinePhase() {
    }

    public TimelinePhase(int id) {
        this.setId(id);
    }

    public TimelinePhase(Timeline timeline, LocalDate from) {
        this.setTimeline(timeline);
        this.setFrom(from);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ewms_timeline_phase_sequence")
    @SequenceGenerator(name="ewms_timeline_phase_sequence", sequenceName="ewms_timeline_phase_sequence")
    public Integer getId() {
        return (Integer)this.id.get();
    }

    public void setId(int id) {
        this.id.set((Object)id);
    }

    public final ObjectProperty<Integer> idProperty() {
        return this.id;
    }

    @ManyToOne
    @JoinColumn(name="timeline", nullable=false)
    public Timeline getTimeline() {
        return (Timeline)this.timeline.get();
    }

    public void setTimeline(Timeline timeline) {
        this.timeline.set((Object)timeline);
    }

    public final ObjectProperty<Timeline> timelineProperty() {
        return this.timeline;
    }

    @Column(name="from_day", nullable=false)
    public LocalDate getFrom() {
        return (LocalDate)this.from.get();
    }

    public void setFrom(LocalDate from) {
        this.from.set((Object)from);
    }

    public final ObjectProperty<LocalDate> fromProperty() {
        return this.from;
    }

    @ManyToOne
    public PhaseType getType() {
        return (PhaseType)this.type.get();
    }

    public void setType(PhaseType type) {
        this.type.set((Object)type);
    }

    public final ObjectProperty<PhaseType> typeProperty() {
        return this.type;
    }

    @Transient
    public String getLocalLabel() {
        return LocaleText.tryParse((String)this.getLabel()).getTextOrDefault();
    }

    @Column(name="label", nullable=false)
    public String getLabel() {
        return (String)this.label.get();
    }

    public void setLabel(String label) {
        this.label.set((Object)label);
    }

    public final StringProperty labelProperty() {
        return this.label;
    }

    @Transient
    public Node getGraphic() {
        BorderPane pane = new BorderPane();
        pane.setCenter((Node)this.getShape());
        this.type.addListener((o, ov, nv) -> pane.setCenter((Node)this.getShape()));
        return pane;
    }

    @Transient
    private Shape getShape() {
        if (this.getType() == null) {
            return null;
        }
        ShapeType type = this.getType().getChartShapeType();
        if (type == null) {
            type = ShapeType.Rectangle;
        }
        return type.createFXShape(10.0, (Paint)Color.BLACK, (Paint)this.getType().getChartColor());
    }

    public ObservableValue<String> textProperty() {
        return Bindings.createStringBinding(() -> this.getLocalLabel(), (Observable[])new Observable[]{this.labelProperty()});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TimelinePhase)) {
            return false;
        }
        if (this.getId() == null) {
            return obj == this;
        }
        return this.getId().equals(((TimelinePhase)obj).getId());
    }

    public int hashCode() {
        return TimelinePhase.class.hashCode() + 17 * this.getId();
    }

    public String toString() {
        return this.getLocalLabel();
    }

    public int compareTo(Object o) {
        if (!(o instanceof TimelinePhase)) {
            return super.compareTo(o);
        }
        TimelinePhase tp = (TimelinePhase)o;
        if (!this.getTimeline().equals(this.getTimeline())) {
            return this.getTimeline().compareTo(this.getTimeline());
        }
        return this.getFrom().compareTo(tp.getFrom());
    }
}

