/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.time;

import de.elpro.ui.formats.TimeFormatType;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAccessor;

public class TsInterval
implements Comparable<TsInterval> {
    private long fromTs;
    private long toTs;

    public TsInterval(long fromTs, long toTs) {
        if (toTs <= fromTs) {
            LocalDateTime from = LocalDateTime.ofInstant(Instant.ofEpochMilli(fromTs), ZoneId.systemDefault());
            LocalDateTime to = LocalDateTime.ofInstant(Instant.ofEpochMilli(toTs), ZoneId.systemDefault());
            throw new IllegalArgumentException(String.format("Illegal Interval bounds to (%s) <= from (%s)", TimeFormatType.DateTimeHMs.format((TemporalAccessor)from), TimeFormatType.DateTimeHMs.format((TemporalAccessor)to)));
        }
        this.fromTs = fromTs;
        this.toTs = toTs;
    }

    public long getFromTs() {
        return this.fromTs;
    }

    public long getToTs() {
        return this.toTs;
    }

    public void setFromTs(long fromTs) {
        this.fromTs = fromTs;
    }

    public void setToTs(long toTs) {
        this.toTs = toTs;
    }

    public long getIntersectDuration(long intervalFromTs, long intervalToTs) {
        return Math.min(this.toTs, intervalToTs) - Math.max(this.fromTs, intervalFromTs);
    }

    public long getIntersectDuration(TsInterval interval) {
        return this.getIntersectDuration(interval.fromTs, interval.toTs);
    }

    public TsInterval getIntersectInterval(TsInterval interval) {
        long to;
        long from = Math.max(this.fromTs, interval.fromTs);
        return from < (to = Math.min(this.toTs, interval.toTs)) ? new TsInterval(from, to) : null;
    }

    public void merge(long intervalFromTs, long intervalToTs) {
        this.fromTs = Math.min(this.fromTs, intervalFromTs);
        this.toTs = Math.max(this.toTs, intervalToTs);
    }

    public void merge(TsInterval interval) {
        this.merge(interval.fromTs, interval.toTs);
    }

    public TsInterval copy() {
        return new TsInterval(this.fromTs, this.toTs);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TsInterval)) {
            return false;
        }
        TsInterval interval = (TsInterval)obj;
        return this.fromTs == interval.fromTs && this.toTs == interval.toTs;
    }

    public int hashCode() {
        int hashCode = TsInterval.class.hashCode();
        hashCode = (int)((long)hashCode + 7L * this.fromTs);
        hashCode = (int)((long)hashCode + 17L * this.toTs);
        return hashCode;
    }

    @Override
    public int compareTo(TsInterval o) {
        return Long.compare(this.fromTs, o.fromTs);
    }

    public String toString() {
        return String.format("[%s - %s]", TimeFormatType.DateTimeHMsMs.format((TemporalAccessor)LocalDateTime.ofInstant(Instant.ofEpochMilli(this.fromTs), ZoneOffset.systemDefault())), TimeFormatType.DateTimeHMsMs.format((TemporalAccessor)LocalDateTime.ofInstant(Instant.ofEpochMilli(this.toTs), ZoneOffset.systemDefault())));
    }
}

