/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.units;

import de.elpro.ewms.core.Messages;
import de.elpro.ewms.core.variable.value.ArchiveValue;
import de.elpro.ewms.core.variable.value.IStoredVarValue;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.Plausibility;
import de.elpro.ewms.core.variable.value.SupplementValue;
import de.elpro.ewms.core.variable.value.ValueSource;
import de.elpro.ewms.core.variable.value.VarValue;
import java.util.List;
import java.util.RandomAccess;

public enum Aggregation {
    Last,
    LastValid,
    Avg,
    Sum,
    Min,
    Max,
    BitOr,
    BitAnd;


    public IVarValue aggregateAndConvert(List<IVarValue> values) {
        if (!(values instanceof RandomAccess)) {
            throw new IllegalArgumentException("Random access list required");
        }
        long endTimestamp = values.get(values.size() - 1).getEndTimestamp();
        switch (this) {
            case Last: {
                IVarValue lastValue = values.get(values.size() - 1);
                if (lastValue.isValid() && lastValue instanceof ArchiveValue) {
                    ArchiveValue lastArchiveValue = (ArchiveValue)lastValue;
                    ArchiveValue firstValidArchiveValue = null;
                    int i = 0;
                    while (i < values.size()) {
                        IVarValue value = values.get(i);
                        if (value instanceof ArchiveValue && value.isValid()) {
                            firstValidArchiveValue = (ArchiveValue)value;
                            break;
                        }
                        ++i;
                    }
                    return new ArchiveValue(firstValidArchiveValue.getStartTimestamp(), lastArchiveValue.getEndTimestamp(), lastArchiveValue.getValue(), lastArchiveValue.getQuality(), lastArchiveValue.getPlausibility());
                }
                return lastValue.copy();
            }
            case LastValid: {
                IVarValue lastInvalidValue = null;
                int i = values.size() - 1;
                while (i >= 0) {
                    IVarValue tmp = values.get(i);
                    if (tmp.isValid()) {
                        if (tmp instanceof ArchiveValue) {
                            ArchiveValue lastArchiveValue = (ArchiveValue)tmp;
                            ArchiveValue firstValidArchiveValue = null;
                            int m = 0;
                            while (m <= i) {
                                IVarValue value = values.get(m);
                                if (value instanceof ArchiveValue && value.isValid()) {
                                    firstValidArchiveValue = (ArchiveValue)value;
                                    break;
                                }
                                ++m;
                            }
                            return new ArchiveValue(firstValidArchiveValue.getStartTimestamp(), lastArchiveValue.getEndTimestamp(), lastArchiveValue.getValue(), lastArchiveValue.getQuality(), lastArchiveValue.getPlausibility());
                        }
                        return tmp.copy();
                    }
                    if (lastInvalidValue == null && Double.isFinite(tmp.getValue())) {
                        lastInvalidValue = tmp;
                    }
                    --i;
                }
                return lastInvalidValue != null ? lastInvalidValue.copy() : new VarValue(endTimestamp, Double.NaN, -1.0, Plausibility.Missing, ValueSource.Mixed);
            }
            case Sum: {
                Integer firstValidValueIndex = null;
                Integer lastValidValueIndex = null;
                long lastValidTs = endTimestamp;
                double sum = 0.0;
                double sumQuality = 0.0;
                double weightedQuality = 0.0;
                int count = 0;
                SupplementValue firstSupplValue = null;
                boolean identicalSupplement = true;
                ArchiveValue firstArchValue = null;
                boolean archiveValuesOnly = true;
                int i = 0;
                while (i < values.size()) {
                    IVarValue tmp = values.get(i);
                    if (!(tmp instanceof SupplementValue)) {
                        identicalSupplement = false;
                    }
                    if (tmp.isValid()) {
                        if (firstValidValueIndex == null) {
                            firstValidValueIndex = i;
                        }
                        if (!(tmp instanceof ArchiveValue)) {
                            archiveValuesOnly = false;
                        }
                        if (identicalSupplement) {
                            SupplementValue sTmp = (SupplementValue)tmp;
                            if (firstSupplValue == null) {
                                firstSupplValue = sTmp;
                            } else if (sTmp.getRecordedTimestamp() != firstSupplValue.getRecordedTimestamp() || sTmp.getUserId() != firstSupplValue.getUserId()) {
                                identicalSupplement = false;
                            }
                        }
                        if (archiveValuesOnly && firstArchValue == null && tmp instanceof ArchiveValue) {
                            firstArchValue = (ArchiveValue)tmp;
                        }
                        lastValidTs = tmp.getEndTimestamp();
                        sum += tmp.getValue();
                        sumQuality += tmp.getQuality();
                        if (archiveValuesOnly) {
                            IStoredVarValue storedValue = (IStoredVarValue)tmp;
                            weightedQuality += tmp.getQuality() * (double)(storedValue.getEndTimestamp() - storedValue.getStartTimestamp());
                        }
                        ++count;
                        lastValidValueIndex = i;
                    }
                    ++i;
                }
                if (count > 0) {
                    if (identicalSupplement && firstSupplValue != null) {
                        return firstSupplValue.copy(firstSupplValue.getStartTimestamp(), lastValidTs, sum);
                    }
                    if (archiveValuesOnly && firstArchValue != null) {
                        return firstArchValue.copy(firstArchValue.getStartTimestamp(), lastValidTs, sum, weightedQuality / (double)(lastValidTs - firstArchValue.getStartTimestamp()), Plausibility.Ok);
                    }
                    return new VarValue(endTimestamp, sum, sumQuality / (double)(lastValidValueIndex + 1), ValueSource.Mixed);
                }
                return new VarValue(endTimestamp, Double.NaN, -1.0, Plausibility.Missing, ValueSource.Mixed);
            }
            case Avg: {
                Integer firstValidValueIndex = null;
                Integer lastValidValueIndex = null;
                Long lastValidTs = null;
                double sum = 0.0;
                double sumQuality = 0.0;
                double weightedQuality = 0.0;
                int count = 0;
                SupplementValue firstSupplValue = null;
                boolean identicalSupplement = true;
                ArchiveValue firstArchValue = null;
                boolean archiveValuesOnly = true;
                int i = 0;
                while (i < values.size()) {
                    IVarValue tmp = values.get(i);
                    if (!(tmp instanceof SupplementValue)) {
                        identicalSupplement = false;
                    }
                    if (tmp.isValid()) {
                        if (firstValidValueIndex == null) {
                            firstValidValueIndex = i;
                        }
                        if (!(tmp instanceof ArchiveValue)) {
                            archiveValuesOnly = false;
                        }
                        if (identicalSupplement) {
                            SupplementValue sTmp = (SupplementValue)tmp;
                            if (firstSupplValue == null) {
                                firstSupplValue = sTmp;
                            } else if (sTmp.getRecordedTimestamp() != firstSupplValue.getRecordedTimestamp() || sTmp.getUserId() != firstSupplValue.getUserId()) {
                                identicalSupplement = false;
                            }
                        }
                        if (archiveValuesOnly && firstArchValue == null && tmp instanceof ArchiveValue) {
                            firstArchValue = (ArchiveValue)tmp;
                        }
                        lastValidTs = tmp.getEndTimestamp();
                        sum += tmp.getValue();
                        sumQuality += tmp.getQuality();
                        if (archiveValuesOnly) {
                            IStoredVarValue storedValue = (IStoredVarValue)tmp;
                            weightedQuality += tmp.getQuality() * (double)(storedValue.getEndTimestamp() - storedValue.getStartTimestamp());
                        }
                        ++count;
                        lastValidValueIndex = i;
                    }
                    ++i;
                }
                if (count > 0) {
                    if (identicalSupplement && firstSupplValue != null) {
                        return firstSupplValue.copy(firstSupplValue.getStartTimestamp(), lastValidTs, sum / (double)count);
                    }
                    if (archiveValuesOnly && firstArchValue != null) {
                        return firstArchValue.copy(firstArchValue.getStartTimestamp(), lastValidTs, sum / (double)count, weightedQuality / (double)(lastValidTs - firstArchValue.getStartTimestamp()), Plausibility.Ok);
                    }
                    return new VarValue(endTimestamp, sum / (double)count, sumQuality / (double)(lastValidValueIndex + 1), ValueSource.Mixed);
                }
                return new VarValue(endTimestamp, Double.NaN, -1.0, Plausibility.Missing, ValueSource.Mixed);
            }
            case Min: {
                IVarValue minValue = null;
                long lastValidTs = endTimestamp;
                for (IVarValue tmp : values) {
                    if (!tmp.isValid()) continue;
                    lastValidTs = tmp.getEndTimestamp();
                    if (minValue != null && !(tmp.getValue() < minValue.getValue())) continue;
                    minValue = tmp;
                }
                if (minValue != null) {
                    return new VarValue(lastValidTs, minValue.getValue(), minValue.getQuality(), ValueSource.Mixed);
                }
                return new VarValue(endTimestamp, Double.NaN, -1.0, Plausibility.Missing, ValueSource.Mixed);
            }
            case Max: {
                IVarValue maxValue = null;
                long lastValidTs = endTimestamp;
                for (IVarValue tmp : values) {
                    if (!tmp.isValid()) continue;
                    lastValidTs = tmp.getEndTimestamp();
                    if (maxValue != null && !(tmp.getValue() > maxValue.getValue())) continue;
                    maxValue = tmp;
                }
                if (maxValue != null) {
                    return new VarValue(lastValidTs, maxValue.getValue(), maxValue.getQuality(), ValueSource.Mixed);
                }
                return new VarValue(endTimestamp, Double.NaN, -1.0, Plausibility.Missing, ValueSource.Mixed);
            }
            case BitOr: {
                long lastValidTs = endTimestamp;
                double bits = 0.0;
                double bitsQuality = 0.0;
                int count = 0;
                SupplementValue firstSupplValue = null;
                boolean identicalSupplement = true;
                for (IVarValue tmp : values) {
                    if (!(tmp instanceof SupplementValue)) {
                        identicalSupplement = false;
                    }
                    if (!tmp.isValid()) continue;
                    if (identicalSupplement) {
                        SupplementValue sTmp = (SupplementValue)tmp;
                        if (firstSupplValue == null) {
                            firstSupplValue = sTmp;
                        } else if (sTmp.getRecordedTimestamp() != firstSupplValue.getRecordedTimestamp() || sTmp.getUserId() != firstSupplValue.getUserId()) {
                            identicalSupplement = false;
                        }
                    }
                    lastValidTs = tmp.getEndTimestamp();
                    bits = (int)bits | (int)tmp.getValue();
                    bitsQuality += tmp.getQuality();
                    ++count;
                }
                if (count > 0) {
                    if (identicalSupplement && firstSupplValue != null) {
                        return firstSupplValue.copy(firstSupplValue.getStartTimestamp(), lastValidTs, bits);
                    }
                    return new VarValue(endTimestamp, bits, bitsQuality / (double)values.size(), ValueSource.Mixed);
                }
                return new VarValue(endTimestamp, Double.NaN, -1.0, Plausibility.Missing, ValueSource.Mixed);
            }
            case BitAnd: {
                long lastValidTs = endTimestamp;
                double bits = 0.0;
                double bitsQuality = 0.0;
                int count = 0;
                SupplementValue firstSupplValue = null;
                boolean identicalSupplement = true;
                for (IVarValue tmp : values) {
                    if (!(tmp instanceof SupplementValue)) {
                        identicalSupplement = false;
                    }
                    if (!tmp.isValid()) continue;
                    if (identicalSupplement) {
                        SupplementValue sTmp = (SupplementValue)tmp;
                        if (firstSupplValue == null) {
                            firstSupplValue = sTmp;
                        } else if (sTmp.getRecordedTimestamp() != firstSupplValue.getRecordedTimestamp() || sTmp.getUserId() != firstSupplValue.getUserId()) {
                            identicalSupplement = false;
                        }
                    }
                    lastValidTs = tmp.getEndTimestamp();
                    bits = (int)bits & (int)tmp.getValue();
                    bitsQuality += tmp.getQuality();
                    ++count;
                }
                if (count > 0) {
                    if (identicalSupplement && firstSupplValue != null) {
                        return firstSupplValue.copy(firstSupplValue.getStartTimestamp(), lastValidTs, bits);
                    }
                    return new VarValue(endTimestamp, bits, bitsQuality / (double)values.size(), ValueSource.Mixed);
                }
                return new VarValue(endTimestamp, Double.NaN, -1.0, Plausibility.Missing, ValueSource.Mixed);
            }
        }
        return null;
    }

    public double aggregate(double[] values) {
        switch (this) {
            case Last: {
                return values[values.length - 1];
            }
            case LastValid: {
                int i = values.length - 1;
                while (i >= 0) {
                    double tmp = values[i];
                    if (Double.isFinite(tmp)) {
                        return tmp;
                    }
                    --i;
                }
                return Double.NaN;
            }
            case Sum: {
                double sum = 0.0;
                int count = 0;
                double[] dArray = values;
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    double val = dArray[n2];
                    if (Double.isFinite(val)) {
                        sum += val;
                        ++count;
                    }
                    ++n2;
                }
                if (count > 0) {
                    return sum;
                }
                return Double.NaN;
            }
            case Avg: {
                double sum = 0.0;
                int count = 0;
                double[] dArray = values;
                int n = values.length;
                int n3 = 0;
                while (n3 < n) {
                    double val = dArray[n3];
                    if (Double.isFinite(val)) {
                        sum += val;
                        ++count;
                    }
                    ++n3;
                }
                if (count > 0) {
                    return sum / (double)count;
                }
                return Double.NaN;
            }
            case Min: {
                double min = Double.POSITIVE_INFINITY;
                boolean valid = false;
                double[] dArray = values;
                int n = values.length;
                int n4 = 0;
                while (n4 < n) {
                    double val = dArray[n4];
                    if (!Double.isNaN(val)) {
                        min = Math.min(val, min);
                        valid = true;
                    }
                    ++n4;
                }
                if (valid) {
                    return min;
                }
                return Double.NaN;
            }
            case Max: {
                double max = Double.NEGATIVE_INFINITY;
                boolean valid = false;
                double[] dArray = values;
                int n = values.length;
                int n5 = 0;
                while (n5 < n) {
                    double val = dArray[n5];
                    if (!Double.isNaN(val)) {
                        max = Math.max(val, max);
                        valid = true;
                    }
                    ++n5;
                }
                if (valid) {
                    return max;
                }
                return Double.NaN;
            }
            case BitOr: {
                double bits = 0.0;
                int count = 0;
                double[] dArray = values;
                int n = values.length;
                int n6 = 0;
                while (n6 < n) {
                    double val = dArray[n6];
                    if (Double.isFinite(val)) {
                        bits = (int)bits | (int)val;
                        ++count;
                    }
                    ++n6;
                }
                if (count > 0) {
                    return bits;
                }
                return Double.NaN;
            }
            case BitAnd: {
                double bits = 0.0;
                int count = 0;
                double[] dArray = values;
                int n = values.length;
                int n7 = 0;
                while (n7 < n) {
                    double val = dArray[n7];
                    if (Double.isFinite(val)) {
                        bits = (int)bits & (int)val;
                        ++count;
                    }
                    ++n7;
                }
                if (count > 0) {
                    return bits;
                }
                return Double.NaN;
            }
        }
        return Double.NaN;
    }

    public String toString() {
        switch (this) {
            case Last: {
                return Messages.variable_aggregation_last;
            }
            case LastValid: {
                return Messages.variable_aggregation_lastvalid;
            }
            case Avg: {
                return Messages.variable_aggregation_avg;
            }
            case Sum: {
                return Messages.variable_aggregation_sum;
            }
            case Min: {
                return Messages.variable_aggregation_min;
            }
            case Max: {
                return Messages.variable_aggregation_max;
            }
            case BitOr: {
                return Messages.variable_aggregation_bit_or;
            }
            case BitAnd: {
                return Messages.variable_aggregation_bit_and;
            }
        }
        return super.toString();
    }
}

