/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.units;

import de.elpro.ewms.core.bundle.Activator;
import de.elpro.ewms.core.units.DisplayUnitFormat;
import de.elpro.ewms.core.units.MeasuringUnitDefinition;
import de.elpro.ewms.core.units.MeasuringUnitFormat;
import de.elpro.ewms.core.units.MeasuringUnitFormats;
import de.elpro.ewms.core.units.PhysicalUnit;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javafx.util.StringConverter;
import org.eclipse.fx.core.log.Logger;

public class MeasuringUnit {
    private static final Logger logger = Activator.createLogger(MeasuringUnit.class);
    static final Map<String, MeasuringUnit> UNITS = new TreeMap<String, MeasuringUnit>();
    public static final StringConverter<MeasuringUnit> CONVERTER = new StringConverter<MeasuringUnit>(){

        public String toString(MeasuringUnit object) {
            if (object == null) {
                return null;
            }
            return object.getId();
        }

        public MeasuringUnit fromString(String id) {
            if (id == null) {
                return null;
            }
            return MeasuringUnit.getMeasuringUnit(id);
        }
    };
    private final String id;
    private final String key;
    private final String commonCode;
    private final PhysicalUnit physicalUnit;
    private final Map<DisplayUnitFormat, String> displayUnits = new HashMap<DisplayUnitFormat, String>();
    private final Map<MeasuringUnitFormat, DecimalFormat> valueFormats = new HashMap<MeasuringUnitFormat, DecimalFormat>();

    MeasuringUnit(String physicalUnitKey, String key, String commonCode) {
        this.id = MeasuringUnit.createId(physicalUnitKey, key);
        this.key = key;
        this.commonCode = commonCode;
        this.physicalUnit = PhysicalUnit.getPhysicalUnit(physicalUnitKey);
    }

    protected MeasuringUnit(String key, PhysicalUnit physicalUnit) {
        this(key, null, physicalUnit);
    }

    protected MeasuringUnit(String key, String commonCode, PhysicalUnit physicalUnit) {
        this.id = MeasuringUnit.createId(physicalUnit.getKey(), key);
        this.key = key;
        this.commonCode = commonCode;
        this.physicalUnit = physicalUnit;
        this.physicalUnit.addPredefinedMeasuringUnit(this);
        this.physicalUnit.addMeasuringUnit(this);
        if (UNITS.containsKey(this.getId())) {
            throw new IllegalArgumentException(String.format("Duplicate measuring unit with key '%s'", this.getId()));
        }
        UNITS.put(this.getId(), this);
    }

    public final String getId() {
        return this.id;
    }

    public final String getKey() {
        return this.key;
    }

    public final String getCommonCode() {
        return this.commonCode;
    }

    public final Integer getOPCUnitId() {
        if (this.commonCode == null || this.commonCode.isEmpty()) {
            return null;
        }
        int unitId = 0;
        int i = 0;
        while (i < this.commonCode.length()) {
            int c = Character.getNumericValue(this.commonCode.charAt(i));
            unitId <<= 8;
            unitId |= c;
            ++i;
        }
        return unitId;
    }

    public static final String createId(String physicalUnitKey, String measuringUnitKey) {
        return String.format("%s / %s", physicalUnitKey, measuringUnitKey);
    }

    public final PhysicalUnit getPhysicalUnit() {
        return this.physicalUnit;
    }

    public static MeasuringUnit getMeasuringUnit(String id) {
        if (id == null) {
            return null;
        }
        MeasuringUnit unit = UNITS.get(id);
        if (unit == null) {
            logger.errorf("Cannot find measuring unit.", (Throwable)new Exception(String.format("Unknown measuring unit ID %s", id)), new Object[0]);
            return MeasuringUnit.toUnknownMeasuringUnit(id);
        }
        return unit;
    }

    public double getFactor() {
        return 1.0;
    }

    public double getDivisor() {
        return 1.0;
    }

    public double getAddend() {
        return 0.0;
    }

    public void putDisplayUnitText(DisplayUnitFormat format, String text) {
        this.displayUnits.put(format, text);
    }

    public String getDisplayUnitText() {
        return this.getDisplayUnitText(DisplayUnitFormat.SIMPLE);
    }

    public String getDisplayUnitText(DisplayUnitFormat format) {
        String displayUnitText = this.displayUnits.get((Object)format);
        if (displayUnitText == null) {
            displayUnitText = this.displayUnits.get((Object)DisplayUnitFormat.SIMPLE);
        }
        return displayUnitText;
    }

    public void putValueFormat(MeasuringUnitFormat format, String valueFormatText) {
        this.valueFormats.put(format, new DecimalFormat(valueFormatText));
    }

    public DecimalFormat getValueFormat(MeasuringUnitFormat format) {
        DecimalFormat valueFormat = this.valueFormats.get(format);
        if (valueFormat == null) {
            valueFormat = format.getDefaultDecimalFormat();
        }
        if (valueFormat == null) {
            valueFormat = this.valueFormats.get(MeasuringUnitFormats.SIMPLE);
        }
        if (valueFormat == null) {
            valueFormat = MeasuringUnitFormats.SIMPLE.getDefaultDecimalFormat();
        }
        return valueFormat != null ? valueFormat : new DecimalFormat("###,###,###,###,##0.000");
    }

    public double convert(double value, MeasuringUnit fromMU) {
        if (this == fromMU) {
            return value;
        }
        if (fromMU.getPhysicalUnit() != this.getPhysicalUnit()) {
            throw new IllegalArgumentException(String.format("Cannot convert from %s to %s since physical units are not the same!", this, fromMU));
        }
        double conversionFactor = this.getFactor() * fromMU.getDivisor() / (this.getDivisor() * fromMU.getFactor());
        return (value - fromMU.getAddend()) * conversionFactor + this.getAddend();
    }

    public String formatValue(double value) {
        return this.formatValue(value, this, true);
    }

    public String formatValue(double value, MeasuringUnit valueUnit) {
        return this.formatValue(value, valueUnit, true);
    }

    public String formatValue(double value, boolean showUnitText) {
        return this.formatValue(value, this, showUnitText);
    }

    public String formatValue(double value, MeasuringUnit valueUnit, boolean showUnitText) {
        return this.formatValue(value, valueUnit, MeasuringUnitFormats.SIMPLE, showUnitText);
    }

    public String formatValue(double value, MeasuringUnitFormat muFormat, boolean showUnitText) {
        return this.formatValue(value, this, muFormat, showUnitText);
    }

    public String formatValue(double value, MeasuringUnit valueUnit, MeasuringUnitFormat muFormat, boolean showUnitText) {
        double displayValue = this.convert(value, valueUnit);
        DecimalFormat format = this.getValueFormat(muFormat != null ? muFormat : MeasuringUnitFormats.SIMPLE);
        if (showUnitText) {
            return String.format("%s [%s]", format.format(displayValue), this.getDisplayUnitText(DisplayUnitFormat.SIMPLE));
        }
        return format.format(displayValue);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MeasuringUnit)) {
            return false;
        }
        return this.getId().equals(((MeasuringUnit)obj).getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return this.getKey();
    }

    public MeasuringUnitDefinition toDefinition() {
        MeasuringUnitDefinition def = new MeasuringUnitDefinition();
        def.setPhysicalUnitKey(this.getPhysicalUnit().getKey());
        def.setKey(this.getKey());
        def.setCommonCode(this.getCommonCode());
        def.setFactor(this.getFactor());
        def.setDivisor(this.getDivisor());
        def.setAddend(this.getAddend());
        def.setSimpleDisplayUnit(this.getDisplayUnitText(DisplayUnitFormat.SIMPLE));
        def.setSimpleValueFormat("###,###,###,###,##0.000");
        return def;
    }

    public static final MeasuringUnit toUnknownMeasuringUnit(String id) {
        String[] parts = id.split("/");
        if (parts.length != 2) {
            return null;
        }
        PhysicalUnit pu = PhysicalUnit.toUnknownPhysicalUnit(parts[0].trim());
        MeasuringUnit mu = new MeasuringUnit(parts[1].trim(), pu);
        mu.putDisplayUnitText(DisplayUnitFormat.SIMPLE, "<unknown>");
        return mu;
    }
}

